/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.stats;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.management.geronimo.stats.TomcatWebConnectorStatsImpl;
import org.apache.tomcat.util.modeler.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorStats {
    private static final Logger log = LoggerFactory.getLogger(ConnectorStats.class);
    protected MBeanServer mBeanServer = null;
    protected Registry registry;
    private ObjectName grpName;
    private ObjectName tpName;
    private TomcatWebConnectorStatsImpl stats = new TomcatWebConnectorStatsImpl();

    public ConnectorStats() {
        this.registry = Registry.getRegistry(null, null);
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        try {
            this.grpName = new ObjectName("*:type=GlobalRequestProcessor,*");
            this.tpName = new ObjectName("*:type=ThreadPool,*");
        }
        catch (Exception ex) {
            log.error("Error - " + ex.toString());
        }
    }

    public Stats getStats(String port) {
        this.stats.setStartTime();
        this.updateStats(this.stats, port);
        return this.stats;
    }

    public Stats updateStats(String port) {
        this.updateStats(this.stats, port);
        return this.stats;
    }

    private void updateStats(TomcatWebConnectorStatsImpl stats, String port) {
        try {
            ObjectName objectName;
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(this.tpName, null);
            for (ObjectInstance oi : set) {
                objectName = oi.getObjectName();
                if (objectName.getKeyProperty("name").indexOf(port) <= -1) continue;
                this.tpName = objectName;
                break;
            }
            set = this.mBeanServer.queryMBeans(this.grpName, null);
            for (ObjectInstance oi : set) {
                objectName = oi.getObjectName();
                if (objectName.getKeyProperty("name").indexOf(port) <= -1) continue;
                this.grpName = objectName;
                break;
            }
            stats.setLastSampleTime();
            long maxTime = (Long)this.mBeanServer.getAttribute(this.grpName, "maxTime");
            long processingTime = (Long)this.mBeanServer.getAttribute(this.grpName, "processingTime");
            int requestCount = (Integer)this.mBeanServer.getAttribute(this.grpName, "requestCount");
            int errorCount = (Integer)this.mBeanServer.getAttribute(this.grpName, "errorCount");
            long bytesReceived = (Long)this.mBeanServer.getAttribute(this.grpName, "bytesReceived");
            long bytesSent = (Long)this.mBeanServer.getAttribute(this.grpName, "bytesSent");
            stats.setRequestTime(requestCount, 0L, maxTime, processingTime);
            stats.setErrorCount(errorCount);
            stats.setBytesSentCount(bytesSent);
            stats.setBytesReceivedCount(bytesReceived);
            long openConnections = 0L;
            long maxOpenConnections = 0L;
            stats.setOpenConnection(openConnections, maxOpenConnections, 0L);
            int currentThreadsBusy = (Integer)this.mBeanServer.getAttribute(this.tpName, "currentThreadsBusy");
            int currentThreadCount = (Integer)this.mBeanServer.getAttribute(this.tpName, "currentThreadCount");
            int maxThreads = (Integer)this.mBeanServer.getAttribute(this.tpName, "maxThreads");
            stats.setBusyThreads((long)currentThreadsBusy, (long)currentThreadCount, 0L, (long)maxThreads, 0L);
        }
        catch (Exception ex) {
            log.error("Error getting attribute " + this.grpName + " " + ex.toString());
        }
    }
}

