/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.listener;

import java.util.Stack;
import javax.security.auth.Subject;
import org.apache.catalina.Container;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.tomcat.GeronimoStandardContext;

public class RunAsInstanceListener
implements InstanceListener {
    private static final ThreadLocal<Stack<Callers>> threadLocal = new ThreadLocal<Stack<Callers>>(){

        @Override
        protected Stack<Callers> initialValue() {
            return new Stack<Callers>();
        }
    };

    public void instanceEvent(InstanceEvent event) {
        Container parent;
        if (event.getType().equals("beforeService")) {
            Container parent2 = event.getWrapper().getParent();
            if (parent2 instanceof GeronimoStandardContext) {
                Stack<Callers> callersStack = threadLocal.get();
                GeronimoStandardContext context = (GeronimoStandardContext)parent2;
                Wrapper wrapper = event.getWrapper();
                String runAsRole = wrapper.getRunAs();
                Subject runAsSubject = context.getSubjectForRole(runAsRole);
                Callers oldCallers = ContextManager.pushNextCaller((Subject)runAsSubject);
                callersStack.push(oldCallers);
            }
        } else if (event.getType().equals("afterService") && (parent = event.getWrapper().getParent()) instanceof GeronimoStandardContext) {
            Stack<Callers> callersStack = threadLocal.get();
            Callers oldCallers = callersStack.pop();
            ContextManager.popCallers((Callers)oldCallers);
        }
    }
}

