/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import java.util.Map;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.cluster.ChannelInterceptorGBean;
import org.apache.geronimo.tomcat.cluster.MembershipServiceGBean;
import org.apache.geronimo.tomcat.cluster.ReceiverGBean;
import org.apache.geronimo.tomcat.cluster.SenderGBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Logger log = LoggerFactory.getLogger(ChannelGBean.class);
    public static final String J2EE_TYPE = "Channel";
    private final Channel channel;
    public static final GBeanInfo GBEAN_INFO;

    public ChannelGBean() {
        this.channel = null;
    }

    public ChannelGBean(String className, Map initParams, MembershipServiceGBean membership, ReceiverGBean receiver, SenderGBean sender, ChannelInterceptorGBean interceptorChain) throws Exception {
        if (className == null) {
            throw new IllegalArgumentException("Must have a 'className' attribute.");
        }
        this.channel = (Channel)Class.forName(className).newInstance();
        this.setParameters(this.channel, initParams);
        if (this.channel instanceof GroupChannel) {
            GroupChannel groupChannel = (GroupChannel)this.channel;
            if (membership != null) {
                groupChannel.setMembershipService((MembershipService)membership.getInternalObject());
            }
            if (receiver != null) {
                groupChannel.setChannelReceiver((ChannelReceiver)receiver.getInternalObject());
            }
            if (sender != null) {
                groupChannel.setChannelSender((ChannelSender)sender.getInternalObject());
            }
        } else {
            log.warn(className + " is not an instance of GroupChannel. Did not set Receiver, Sender, or MembershipService");
        }
        if (interceptorChain != null) {
            for (ChannelInterceptorGBean channelInterceptorGBean = interceptorChain; channelInterceptorGBean != null; channelInterceptorGBean = channelInterceptorGBean.getNextInterceptor()) {
                this.channel.addInterceptor((ChannelInterceptor)channelInterceptorGBean.getInternalObject());
            }
        }
    }

    @Override
    public Object getInternalObject() {
        return this.channel;
    }

    public void doFail() {
        log.warn("Failed");
    }

    public void doStart() throws Exception {
        log.debug("Started channel gbean.");
    }

    public void doStop() throws Exception {
        log.debug("Stopped channel gbean.");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)J2EE_TYPE, ChannelGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("Membership", MembershipServiceGBean.class, "MembershipService");
        infoFactory.addReference("Receiver", ReceiverGBean.class, "Receiver");
        infoFactory.addReference("Sender", SenderGBean.class, "Sender");
        infoFactory.addReference("ChannelInterceptor", ChannelInterceptorGBean.class, "ChannelInterceptor");
        infoFactory.addOperation("getInternalObject", "Object");
        infoFactory.setConstructor(new String[]{"className", "initParams", "Membership", "Receiver", "Sender", "ChannelInterceptor"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

