/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletSecurityElement;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationServletRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.osgi.web.WebApplicationUtils;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.ApplicationPolicyConfigurationManager;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.tomcat.BundleDirContext;
import org.apache.geronimo.tomcat.GeronimoFileDirContext;
import org.apache.geronimo.tomcat.GeronimoWebAppLoader;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.TomcatDeploymentWatcher;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.interceptor.BeforeAfterContext;
import org.apache.geronimo.tomcat.interceptor.ComponentContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.InstanceContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.PolicyContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.RequestListenerBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.UserTransactionBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.WebApplicationIdentityBeforeAfter;
import org.apache.geronimo.tomcat.listener.DispatchListener;
import org.apache.geronimo.tomcat.listener.RunAsInstanceListener;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.tomcat.valve.GeronimoBeforeAfterValve;
import org.apache.geronimo.tomcat.valve.ProtectedTargetValve;
import org.apache.geronimo.web.WebModuleListener;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.geronimo.web.security.SpecSecurityBuilder;
import org.apache.geronimo.web.security.WebSecurityConstraintStore;
import org.apache.geronimo.webservices.POJOWebServiceServlet;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;
import org.apache.naming.resources.FileDirContext;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoStandardContext
extends StandardContext {
    private static final long serialVersionUID = 3834587716552831032L;
    private static final boolean allowLinking = Boolean.getBoolean("org.apache.geronimo.tomcat.GeronimoStandardContext.allowLinking");
    private static final Logger logger = LoggerFactory.getLogger(GeronimoStandardContext.class);
    private Subject defaultSubject = null;
    private RunAsSource runAsSource = RunAsSource.NULL;
    private Map<String, WebServiceContainer> webServiceMap = null;
    private boolean pipelineInitialized;
    private BeforeAfter beforeAfter = null;
    private int contextCount = 0;
    private boolean authenticatorInstalled;
    private ConfigurationFactory configurationFactory;
    private String policyContextId;
    private WebSecurityConstraintStore webSecurityConstraintStore;
    private ApplicationPolicyConfigurationManager applicationPolicyConfigurationManager;
    private Bundle bundle;
    private ServiceRegistration serviceRegistration;
    private List<WebModuleListener> webModuleListeners;
    private ThreadLocal<Stack<BeforeAfterContext>> beforeAfterContexts = new ThreadLocal<Stack<BeforeAfterContext>>(){

        @Override
        protected Stack<BeforeAfterContext> initialValue() {
            return new Stack<BeforeAfterContext>();
        }
    };
    private final Object instanceListenersLock = new Object();
    private final Object wrapperLifecyclesLock = new Object();
    private final Object wrapperListenersLock = new Object();

    public GeronimoStandardContext() {
        this.setXmlNamespaceAware(true);
        this.setProcessTlds(false);
        this.setUseHttpOnly(false);
        this.setXmlValidation(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextProperties(TomcatContext ctx) throws DeploymentException {
        Manager manager;
        CatalinaCluster cluster;
        List<LifecycleListener> listenerChain;
        SecurityHolder securityHolder;
        this.bundle = ctx.getBundle();
        this.setResources(this.createDirContext(ctx));
        javax.naming.Context enc = ctx.getJndiContext();
        this.setInstanceManager(ctx.getInstanceManager());
        ServletContext servletContext = this.getServletContext();
        if (ctx instanceof TomcatWebAppContext) {
            List webModuleListenerClassNames;
            TomcatWebAppContext tomcatWebAppContext = (TomcatWebAppContext)ctx;
            this.setJavaVMs(tomcatWebAppContext.getJavaVMs());
            this.setServer(tomcatWebAppContext.getServer());
            this.setJ2EEApplication(tomcatWebAppContext.getJ2EEApplication());
            this.setJ2EEServer(tomcatWebAppContext.getJ2EEServer());
            servletContext.setAttribute("WEB_APP_NAME", (Object)tomcatWebAppContext.getWARName());
            if (tomcatWebAppContext.getRuntimeCustomizer() != null) {
                HashMap attributes = new HashMap();
                HashMap<Class, Object> customizerContext = new HashMap<Class, Object>();
                customizerContext.put(Map.class, attributes);
                customizerContext.put(javax.naming.Context.class, enc);
                tomcatWebAppContext.getRuntimeCustomizer().customize(customizerContext);
                for (Map.Entry entry : attributes.entrySet()) {
                    servletContext.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
            this.applicationPolicyConfigurationManager = tomcatWebAppContext.getApplicationPolicyConfigurationManager();
            if (tomcatWebAppContext.getSecurityHolder() != null) {
                this.configurationFactory = tomcatWebAppContext.getSecurityHolder().getConfigurationFactory();
            }
            float schemaVersion = ((Float)tomcatWebAppContext.getDeploymentAttribute("SCHEMA_VERSION")).floatValue();
            boolean metaComplete = (Boolean)tomcatWebAppContext.getDeploymentAttribute("META_COMPLETE");
            this.webSecurityConstraintStore = new WebSecurityConstraintStore(tomcatWebAppContext.getWebAppInfo(), this.bundle, schemaVersion >= 2.5f && !metaComplete, this.getInternalServletContext());
            servletContext.setAttribute(InstanceManager.class.getName(), (Object)ctx.getInstanceManager());
            List orderedLists = (List)tomcatWebAppContext.getDeploymentAttribute("ORDERED_LIBS");
            if (orderedLists != null) {
                servletContext.setAttribute("javax.servlet.context.orderedLibs", Collections.unmodifiableList(orderedLists));
            }
            Map servletContainerInitializerClassNamesMap = (Map)tomcatWebAppContext.getDeploymentAttribute("SERVLET_CONTAINER_INITIALIZERS");
            Bundle bundle = tomcatWebAppContext.getBundle();
            if (servletContainerInitializerClassNamesMap != null) {
                for (Map.Entry entry : servletContainerInitializerClassNamesMap.entrySet()) {
                    String servletContainerInitializerClassName = (String)entry.getKey();
                    Set classNames = (Set)entry.getValue();
                    try {
                        ServletContainerInitializer servletContainerInitializer = (ServletContainerInitializer)bundle.loadClass(servletContainerInitializerClassName).newInstance();
                        if (classNames == null || classNames.size() == 0) {
                            this.addServletContainerInitializer(servletContainerInitializer, null);
                            continue;
                        }
                        HashSet<Class> classSet = new HashSet<Class>();
                        for (String cls : classNames) {
                            try {
                                classSet.add(bundle.loadClass(cls));
                            }
                            catch (ClassNotFoundException e) {
                                this.getLogger().warn((Object)("Fail to load class " + cls + " interested by ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                            }
                        }
                        this.addServletContainerInitializer(servletContainerInitializer, classSet);
                    }
                    catch (IllegalAccessException e) {
                        this.getLogger().error((Object)("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        this.getLogger().error((Object)("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        this.getLogger().error((Object)("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName), (Throwable)e);
                    }
                }
            }
            if ((webModuleListenerClassNames = (List)tomcatWebAppContext.getDeploymentAttribute("org.apache.geronimo.webapplication.web_modue_listeners")) != null && webModuleListenerClassNames.size() > 0) {
                this.webModuleListeners = new ArrayList<WebModuleListener>(webModuleListenerClassNames.size());
                for (String webModuleListenerClassName : webModuleListenerClassNames) {
                    try {
                        Class cls = bundle.loadClass(webModuleListenerClassName);
                        Object webModuleListener = cls.newInstance();
                        this.webModuleListeners.add((WebModuleListener)webModuleListener);
                    }
                    catch (ClassNotFoundException e) {
                        logger.warn("Unable to load the listener class" + webModuleListenerClassName, (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        logger.warn("Unable to create the listener instance " + webModuleListenerClassName, (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.warn("Unable to create the listener instance " + webModuleListenerClassName, (Throwable)e);
                    }
                }
            }
        }
        int index = 0;
        BeforeAfter interceptor = new RequestListenerBeforeAfter(null, index++, this);
        interceptor = new InstanceContextBeforeAfter(interceptor, index++, index++, ctx.getUnshareableResources(), ctx.getApplicationManagedSecurityResources(), ctx.getTrackedConnectionAssociator());
        if (enc != null) {
            interceptor = new ComponentContextBeforeAfter(interceptor, index++, enc);
        }
        if ((securityHolder = ctx.getSecurityHolder()) != null) {
            this.runAsSource = securityHolder.getRunAsSource();
            if (securityHolder.getPolicyContextID() != null) {
                this.policyContextId = securityHolder.getPolicyContextID();
                PolicyContext.setContextID((String)this.policyContextId);
                this.defaultSubject = securityHolder.getDefaultSubject();
                if (this.defaultSubject == null) {
                    this.defaultSubject = ContextManager.EMPTY;
                }
                interceptor = new PolicyContextBeforeAfter(interceptor, index++, index++, index++, this.policyContextId, this.defaultSubject);
            }
        }
        interceptor = new UserTransactionBeforeAfter(interceptor, index++, ctx.getUserTransaction());
        interceptor = new WebApplicationIdentityBeforeAfter(interceptor, index++, ctx.getAbstractName().getNameProperty("name"));
        this.addValve((Valve)new ProtectedTargetValve());
        Valve clusteredValve = ctx.getClusteredValve();
        if (null != clusteredValve) {
            this.addValve(clusteredValve);
        }
        GeronimoBeforeAfterValve geronimoBAValve = new GeronimoBeforeAfterValve(interceptor, index);
        this.addValve((Valve)geronimoBAValve);
        this.beforeAfter = interceptor;
        this.contextCount = index;
        this.addValve((Valve)new SystemMethodValve());
        List<Valve> valveChain = ctx.getValveChain();
        if (valveChain != null) {
            for (Valve valve : valveChain) {
                this.addValve(valve);
            }
        }
        if ((listenerChain = ctx.getLifecycleListenerChain()) != null) {
            for (LifecycleListener listener : listenerChain) {
                this.addLifecycleListener(listener);
            }
        }
        if ((cluster = ctx.getCluster()) != null) {
            this.setCluster((Cluster)cluster);
        }
        if ((manager = ctx.getManager()) != null) {
            this.setManager(manager);
        }
        this.pipelineInitialized = true;
        ClassLoader oldClassLoader = this.bindThread();
        try {
            this.webServiceMap = ctx.getWebServices();
        }
        finally {
            this.unbindThread(oldClassLoader);
        }
        Map<String, String> contextAttributes = ctx.getContextAttributes();
        if (!ctx.getContextAttributes().containsKey("allowLinking")) {
            contextAttributes.put("allowLinking", String.valueOf(allowLinking));
        }
        for (Map.Entry<String, String> entry : contextAttributes.entrySet()) {
            if (IntrospectionUtils.setProperty((Object)((Object)this), (String)entry.getKey(), (String)entry.getValue()) || !this.getLogger().isWarnEnabled()) continue;
            this.getLogger().warn((Object)("Fail to configure attribute " + entry.getKey() + " with value " + entry.getValue() + ", please check whether the attribute exists or is typo correctly"));
        }
        this.addInstanceListener(DispatchListener.class.getName());
        if (this.runAsSource != null) {
            this.addInstanceListener(RunAsInstanceListener.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wrapper createWrapper() {
        InstanceListener listener;
        StandardWrapper wrapper = null;
        if (this.getWrapperClass() != null) {
            try {
                wrapper = (Wrapper)this.getInstanceManager().newInstance(this.getWrapperClass());
            }
            catch (Throwable t) {
                this.getLogger().error((Object)"createWrapper", t);
                return null;
            }
        } else {
            wrapper = new StandardWrapper();
        }
        Object object = this.instanceListenersLock;
        synchronized (object) {
            for (String instanceListener : this.findInstanceListeners()) {
                try {
                    listener = (InstanceListener)this.getInstanceManager().newInstance(instanceListener);
                    wrapper.addInstanceListener(listener);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperLifecyclesLock;
        synchronized (object) {
            for (String wrapperLifecycle : this.findWrapperLifecycles()) {
                try {
                    listener = (LifecycleListener)this.getInstanceManager().newInstance(wrapperLifecycle);
                    wrapper.addLifecycleListener((LifecycleListener)listener);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperListenersLock;
        synchronized (object) {
            for (String wrapperListener : this.findWrapperListeners()) {
                try {
                    listener = (ContainerListener)this.getInstanceManager().newInstance(wrapperListener);
                    wrapper.addContainerListener((ContainerListener)listener);
                }
                catch (Throwable t) {
                    this.getLogger().error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroundProcess() {
        BeforeAfterContext beforeAfterContext = null;
        if (this.beforeAfter != null) {
            beforeAfterContext = new BeforeAfterContext(this.contextCount);
            this.beforeAfter.before(beforeAfterContext, null, null, 0);
        }
        try {
            super.backgroundProcess();
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(beforeAfterContext, null, null, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        BeforeAfterContext beforeAfterContext = null;
        if (this.beforeAfter != null) {
            beforeAfterContext = new BeforeAfterContext(this.contextCount);
            this.beforeAfter.before(beforeAfterContext, null, null, 0);
        }
        try {
            this.stop();
            this.destroy();
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(beforeAfterContext, null, null, 0);
            }
        }
    }

    protected void initInternal() throws LifecycleException {
        String docBase = this.getDocBase();
        super.initInternal();
        this.setDocBase(docBase);
    }

    protected void startInternal() throws LifecycleException {
        if (this.pipelineInitialized) {
            try {
                Valve valve = this.getPipeline().getFirst();
                valve.invoke(null, null);
                if (this.hasRunAsServlet()) {
                    if (this.runAsSource == null) {
                        throw new GeronimoSecurityException("web.xml or annotation specifies a run-as role but no subject configuration supplied for run-as roles");
                    }
                } else {
                    this.removeInstanceListener(RunAsInstanceListener.class.getName());
                }
            }
            catch (IOException e) {
                if (e.getCause() instanceof LifecycleException) {
                    throw (LifecycleException)e.getCause();
                }
                throw new LifecycleException((Throwable)e);
            }
            catch (ServletException e) {
                throw new LifecycleException((Throwable)e);
            }
            SpecSecurityBuilder specSecurityBuilder = new SpecSecurityBuilder(this.webSecurityConstraintStore.exportMergedWebAppInfo());
            HashMap<String, ComponentPermissions> contextIdPermissionsMap = new HashMap<String, ComponentPermissions>();
            contextIdPermissionsMap.put(this.getPolicyContextId(), specSecurityBuilder.buildSpecSecurityConfig());
            if (this.applicationPolicyConfigurationManager != null) {
                try {
                    this.applicationPolicyConfigurationManager.updateApplicationPolicyConfiguration(contextIdPermissionsMap);
                }
                catch (LoginException e) {
                    this.getLogger().error((Object)"Fail to set application policy configurations", (Throwable)e);
                    throw new RuntimeException("Fail to set application policy configurations", e);
                }
                catch (PolicyContextException e) {
                    this.getLogger().error((Object)"Fail to set application policy configurations", (Throwable)e);
                    throw new RuntimeException("Fail to set application policy configurations", e);
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().error((Object)"Fail to set application policy configurations", (Throwable)e);
                    throw new RuntimeException("Fail to set application policy configurations", e);
                }
                finally {
                    specSecurityBuilder.clear();
                }
            }
            if (WebApplicationUtils.isWebApplicationBundle((Bundle)this.bundle)) {
                this.serviceRegistration = WebApplicationUtils.registerServletContext((Bundle)this.bundle, (ServletContext)this.getServletContext());
            }
        } else {
            super.startInternal();
        }
    }

    public synchronized void setLoader(Loader delegate) {
        super.setLoader((Loader)new GeronimoWebAppLoader(this, delegate));
    }

    public ServletContext getInternalServletContext() {
        return this.context;
    }

    protected DirContext createDirContext(TomcatContext tomcatContext) throws DeploymentException {
        File bundleFileRoot = BundleUtils.toFile((Bundle)this.bundle);
        if (bundleFileRoot != null) {
            File applicationRoot;
            File file = applicationRoot = tomcatContext.getModulePath() == null ? bundleFileRoot : new File(bundleFileRoot, tomcatContext.getModulePath());
            if (applicationRoot.exists() && applicationRoot.isDirectory()) {
                return this.createFileDirContext(tomcatContext, applicationRoot);
            }
        }
        return this.createBundleDirContext(tomcatContext);
    }

    private DirContext createFileDirContext(TomcatContext tomcatContext, File applicationRoot) throws DeploymentException {
        FileDirContext fileDirContext = new FileDirContext();
        this.setDocBase(applicationRoot.getAbsolutePath());
        File libraryDirectory = new File(applicationRoot, "WEB-INF/lib");
        if (libraryDirectory.exists()) {
            for (File libraryFile : libraryDirectory.listFiles()) {
                if (!libraryFile.getName().toLowerCase().endsWith(".jar") || !libraryFile.isFile()) continue;
                try {
                    fileDirContext.addResourcesJar(new URL("jar:" + libraryFile.toURI().toURL().toExternalForm() + "!/ "));
                }
                catch (MalformedURLException e) {
                    logger.warn("Unable to add jar file for resource searching", (Throwable)e);
                }
            }
        }
        return fileDirContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DirContext createBundleDirContext(TomcatContext tomcatContext) throws DeploymentException {
        File realPathTempDirectory;
        boolean developmentStage;
        ArrayList<DirContext> altDirContexts;
        block26: {
            File jarResourceRootDirectory;
            boolean refreshmentRequired;
            File checksumFile;
            boolean getRealPathSupportRequired;
            File tempRootDirectory;
            block25: {
                byte[] checksum;
                block24: {
                    altDirContexts = new ArrayList<DirContext>();
                    Engine engine = (Engine)this.getParent().getParent();
                    String serviceName = engine.getService().getName();
                    String engineName = engine.getName();
                    String hostName = this.getParent().getName();
                    String tomcatHome = System.getProperty("catalina.home");
                    tempRootDirectory = new File(tomcatHome + File.separator + "resources" + File.separator + serviceName + File.separator + engineName + File.separator + hostName + File.separator + (this.getName().equals("/") ? "_" : this.getName()));
                    WebAppInfo webAppInfo = tomcatContext.getWebAppInfo();
                    String applicationStageConfiguration = (String)webAppInfo.contextParams.get("org.apache.geronimo.webapplication.stage");
                    String globalStageConfiguration = System.getProperty("org.apache.geronimo.webapplication.stage", "PRODUCTION");
                    developmentStage = applicationStageConfiguration == null ? globalStageConfiguration.equalsIgnoreCase("DEVELOPMENT") : applicationStageConfiguration.equalsIgnoreCase("DEVELOPMENT");
                    String globalGetRealPathConfiguration = System.getProperty("org.apache.geronimo.webapplication.getrealpath.support");
                    String applicationGetRealPathConfiguration = (String)webAppInfo.contextParams.get("org.apache.geronimo.webapplication.getrealpath.support");
                    getRealPathSupportRequired = applicationGetRealPathConfiguration == null ? !"false".equalsIgnoreCase(globalGetRealPathConfiguration) : !"false".equalsIgnoreCase(applicationGetRealPathConfiguration);
                    this.deleteTempDirectoryOnUndeployed(tomcatContext, tempRootDirectory);
                    checksumFile = new File(tempRootDirectory, "checksum.flag");
                    refreshmentRequired = false;
                    checksum = null;
                    try {
                        URL bundleURL = new URL(this.bundle.getLocation());
                        checksum = GeronimoStandardContext.getChecksum(bundleURL);
                        if (checksumFile.exists()) {
                            byte[] savedChecksum = GeronimoStandardContext.readChecksum(checksumFile);
                            if (!Arrays.equals(checksum, savedChecksum)) {
                                refreshmentRequired = true;
                            }
                            break block24;
                        }
                        refreshmentRequired = true;
                    }
                    catch (Exception e) {
                        this.getLogger().warn((Object)"Unable to compute module checksum", (Throwable)e);
                        refreshmentRequired = true;
                    }
                }
                if (refreshmentRequired && checksum != null) {
                    tempRootDirectory.mkdirs();
                    try {
                        GeronimoStandardContext.writeChecksum(checksumFile, checksum);
                    }
                    catch (Exception e) {
                        this.getLogger().error((Object)"Unable to write module checksum file", (Throwable)e);
                    }
                }
                jarResourceRootDirectory = new File(tempRootDirectory, "jar_resources");
                if (refreshmentRequired || !jarResourceRootDirectory.exists()) {
                    try {
                        FileUtils.recursiveDelete((File)jarResourceRootDirectory);
                        jarResourceRootDirectory.mkdirs();
                        Enumeration en = tomcatContext.getBundle().findEntries(tomcatContext.getModulePath() != null ? tomcatContext.getModulePath() + "/WEB-INF/lib" : "WEB-INF/lib", "*.jar", false);
                        if (en == null) break block25;
                        while (en.hasMoreElements()) {
                            URL jarUrl = (URL)en.nextElement();
                            File jarResourceDirectory = new File(jarResourceRootDirectory, jarUrl.getFile().substring(jarUrl.getFile().lastIndexOf(47) + 1));
                            jarResourceDirectory.mkdirs();
                            ZipInputStream in = null;
                            try {
                                in = new ZipInputStream(jarUrl.openStream());
                                JarUtils.unzipToDirectory((ZipInputStream)in, (File)jarResourceDirectory, (String)"META-INF/resources", (boolean)false);
                            }
                            catch (Throwable throwable) {
                                IOUtils.close(in);
                                throw throwable;
                            }
                            IOUtils.close((Closeable)in);
                        }
                    }
                    catch (IOException e) {
                        checksumFile.delete();
                        throw new DeploymentException("Fail to create static resoruce cache for jar files in WEB-INF folder", (Throwable)e);
                    }
                }
            }
            for (File resourceDirectory : jarResourceRootDirectory.listFiles()) {
                if (!resourceDirectory.isDirectory() || !resourceDirectory.getName().endsWith(".jar") || resourceDirectory.listFiles().length <= 0) continue;
                FileDirContext fileDirContext = new FileDirContext();
                fileDirContext.setAllowLinking(allowLinking);
                fileDirContext.setDocBase(resourceDirectory.getAbsolutePath());
                altDirContexts.add((DirContext)fileDirContext);
            }
            if (!getRealPathSupportRequired && !developmentStage) {
                return new BundleDirContext(tomcatContext.getBundle(), tomcatContext.getModulePath(), altDirContexts, null);
            }
            realPathTempDirectory = new File(tempRootDirectory, "real_path");
            if (refreshmentRequired || !realPathTempDirectory.exists()) {
                FileUtils.recursiveDelete((File)realPathTempDirectory);
                realPathTempDirectory.mkdirs();
                String modulePath = tomcatContext.getModulePath() == null ? "" : tomcatContext.getModulePath();
                try {
                    File bundleFile = BundleUtils.toFile((Bundle)this.bundle);
                    if (bundleFile != null) {
                        if (bundleFile.isFile()) {
                            JarUtils.unzipToDirectory((ZipFile)new ZipFile(bundleFile), (File)realPathTempDirectory, (String)modulePath, (boolean)true);
                            break block26;
                        } else {
                            FileUtils.copyFile((File)new File(bundleFile, modulePath), (File)realPathTempDirectory);
                        }
                        break block26;
                    }
                    ZipInputStream zipIn = null;
                    try {
                        zipIn = new ZipInputStream(new URL(this.bundle.getLocation()).openStream());
                        JarUtils.unzipToDirectory((ZipInputStream)zipIn, (File)realPathTempDirectory, (String)modulePath, (boolean)true);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(zipIn);
                        throw throwable;
                    }
                    IOUtils.close((Closeable)zipIn);
                }
                catch (IOException e) {
                    checksumFile.delete();
                    this.getLogger().warn((Object)"fail to extract the bundle, getRealPath might not work", (Throwable)e);
                }
            }
        }
        if (developmentStage) {
            GeronimoFileDirContext fileDirContext = new GeronimoFileDirContext(altDirContexts);
            fileDirContext.setAllowLinking(allowLinking);
            this.setDocBase(realPathTempDirectory.getAbsolutePath());
            return fileDirContext;
        }
        return new BundleDirContext(tomcatContext.getBundle(), tomcatContext.getModulePath(), altDirContexts, realPathTempDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTempDirectoryOnUndeployed(TomcatContext tomcatContext, File tempDirectory) {
        if (!(tomcatContext instanceof TomcatWebAppContext)) {
            return;
        }
        TomcatWebAppContext tomcatWebAppContext = (TomcatWebAppContext)tomcatContext;
        BundleContext bundleContext = this.bundle.getBundleContext();
        ServiceReference tomcatDeploymentWatcherReference = null;
        try {
            tomcatDeploymentWatcherReference = bundleContext.getServiceReference(TomcatDeploymentWatcher.class.getName());
            if (tomcatDeploymentWatcherReference == null) {
                return;
            }
            TomcatDeploymentWatcher tomcatDeploymentWatcher = (TomcatDeploymentWatcher)bundleContext.getService(tomcatDeploymentWatcherReference);
            tomcatDeploymentWatcher.deleteOnUndeployed(this.bundle, tomcatWebAppContext.getAbstractName(), tempDirectory);
        }
        catch (Exception e) {
            logger.warn("Unable to add temporary directory " + tempDirectory + "to the Tomcat deployment watcher, that folder will not be delete on the undeployment", (Throwable)e);
        }
        finally {
            if (tomcatDeploymentWatcherReference != null) {
                try {
                    bundleContext.ungetService(tomcatDeploymentWatcherReference);
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        ClassLoader oldClassLoader = null;
        try {
            oldClassLoader = this.bindThread();
            if (this.webModuleListeners != null) {
                for (WebModuleListener webModuleListener : this.webModuleListeners) {
                    if (webModuleListener instanceof WebModuleListener) {
                        webModuleListener.moduleDestoryed(this.getServletContext());
                        continue;
                    }
                    logger.warn("Invalid WebModuleListener " + webModuleListener.getClass().getName());
                }
            }
        }
        finally {
            this.unbindThread(oldClassLoader);
        }
    }

    public BeforeAfter getBeforeAfter() {
        return this.beforeAfter;
    }

    public int getContextCount() {
        return this.contextCount;
    }

    protected boolean hasRunAsServlet() {
        for (Container servlet : this.findChildren()) {
            if (!(servlet instanceof Wrapper) || ((Wrapper)servlet).getRunAs() == null) continue;
            return true;
        }
        return false;
    }

    public Subject getSubjectForRole(String runAsRole) {
        return this.runAsSource.getSubjectForRole(runAsRole);
    }

    public boolean isAuthenticatorInstalled() {
        return this.authenticatorInstalled;
    }

    public void setAuthenticatorInstalled(boolean authenticatorInstalled) {
        this.authenticatorInstalled = authenticatorInstalled;
    }

    public ConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    public Subject getDefaultSubject() {
        return this.defaultSubject;
    }

    public String getPolicyContextId() {
        return this.policyContextId;
    }

    public String getBasePath() {
        if (this.getDocBase() == null) {
            return null;
        }
        return super.getBasePath();
    }

    public ServletRegistration.Dynamic dynamicServletAdded(Wrapper wrapper) {
        ApplicationServletRegistration registration = new ApplicationServletRegistration(wrapper, (Context)this);
        if (wrapper.getServlet() == null || this.webSecurityConstraintStore.isContainerCreatedDynamicServlet(wrapper.getServlet())) {
            this.webSecurityConstraintStore.addContainerCreatedDynamicServletEntry((ServletRegistration.Dynamic)registration, wrapper.getServletClass());
        }
        ClassLoader cl = this.getParentClassLoader();
        try {
            WebServiceContainer webServiceContainer;
            Class<?> baseServletClass = cl.loadClass(Servlet.class.getName());
            Class<?> servletClass = cl.loadClass(wrapper.getServletClass());
            if (!baseServletClass.isAssignableFrom(servletClass) && this.webServiceMap != null && (webServiceContainer = this.webServiceMap.get(wrapper.getName())) != null) {
                wrapper.setServletClass("org.apache.geronimo.webservices.POJOWebServiceServlet");
                String webServicecontainerID = wrapper.getName() + WebServiceContainerInvoker.WEBSERVICE_CONTAINER + webServiceContainer.hashCode();
                this.getServletContext().setAttribute(webServicecontainerID, (Object)webServiceContainer);
                wrapper.addInitParameter(WebServiceContainerInvoker.WEBSERVICE_CONTAINER, webServicecontainerID);
                String pojoClassID = wrapper.getName() + POJOWebServiceServlet.POJO_CLASS + servletClass.hashCode();
                this.getServletContext().setAttribute(pojoClassID, servletClass);
                wrapper.addInitParameter(POJOWebServiceServlet.POJO_CLASS, pojoClassID);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return registration;
    }

    public void dynamicServletCreated(Servlet servlet) {
        this.webSecurityConstraintStore.addContainerCreatedDynamicServlet(servlet);
    }

    public Set<String> addServletSecurity(ApplicationServletRegistration registration, ServletSecurityElement servletSecurityElement) {
        return this.webSecurityConstraintStore.setDynamicServletSecurity((ServletRegistration.Dynamic)registration, servletSecurityElement);
    }

    public void addSecurityRole(String role) {
        super.addSecurityRole(role);
        this.webSecurityConstraintStore.declareRoles(new String[]{role});
    }

    protected ClassLoader bindThread() {
        ClassLoader oldClassLoader = super.bindThread();
        BeforeAfterContext beforeAfterContext = null;
        if (this.beforeAfter != null) {
            beforeAfterContext = new BeforeAfterContext(this.contextCount);
            this.beforeAfter.before(beforeAfterContext, null, null, 0);
            this.beforeAfterContexts.get().push(beforeAfterContext);
        }
        return oldClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindThread(ClassLoader oldContextClassLoader) {
        try {
            super.unbindThread(oldContextClassLoader);
        }
        finally {
            if (this.beforeAfter != null) {
                this.beforeAfter.after(this.beforeAfterContexts.get().pop(), null, null, 0);
            }
        }
    }

    public boolean fireRequestInitEvent(ServletRequest request) {
        return true;
    }

    public boolean fireRequestDestroyEvent(ServletRequest request) {
        return true;
    }

    public boolean fireRequestDestroyEventInBeforeAfter(ServletRequest request) {
        return super.fireRequestDestroyEvent(request);
    }

    public boolean fireRequestInitEventInBeforeAfter(ServletRequest request) {
        return super.fireRequestInitEvent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] getChecksum(URL url) throws Exception {
        long lastModified;
        InputStream in;
        block5: {
            byte[] byArray;
            in = null;
            try {
                URLConnection connection = url.openConnection();
                File file = BundleUtils.toFile((URL)url);
                if (file != null) {
                    if (!file.isFile()) throw new IOException("Unable to calculate checksum for the directory");
                    in = new FileInputStream(file);
                } else {
                    in = connection.getInputStream();
                }
                lastModified = connection.getLastModified();
                if (lastModified != 0L) break block5;
                byArray = GeronimoStandardContext.calculateChecksum(in, "SHA-1");
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
            IOUtils.close((Closeable)in);
            return byArray;
        }
        byte[] byArray = GeronimoStandardContext.toByteArray(lastModified);
        IOUtils.close((Closeable)in);
        return byArray;
    }

    private static byte[] calculateChecksum(InputStream stream, String algorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest digester = MessageDigest.getInstance(algorithm);
        digester.reset();
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = stream.read(buf, 0, buf.length)) != -1) {
            digester.update(buf, 0, len);
        }
        return digester.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeChecksum(File file, byte[] data) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(data);
        }
        finally {
            IOUtils.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readChecksum(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            byte[] byArray = IOUtils.getBytes((InputStream)in);
            return byArray;
        }
        finally {
            IOUtils.close((Closeable)in);
        }
    }

    private static byte[] toByteArray(long value) {
        byte[] buffer = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
        return buffer;
    }

    private class SystemMethodValve
    extends ValveBase {
        public SystemMethodValve() {
            super(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Request request, Response response) throws IOException, ServletException {
            if (request == null && response == null) {
                ClassLoader oldClassLoader = null;
                try {
                    oldClassLoader = GeronimoStandardContext.this.bindThread();
                    if (GeronimoStandardContext.this.webModuleListeners != null) {
                        for (WebModuleListener webModuleListener : GeronimoStandardContext.this.webModuleListeners) {
                            if (webModuleListener instanceof WebModuleListener) {
                                webModuleListener.moduleInitialized(GeronimoStandardContext.this.getServletContext());
                                continue;
                            }
                            logger.warn("Invalid WebModuleListener " + webModuleListener.getClass().getName());
                        }
                    }
                }
                finally {
                    GeronimoStandardContext.this.unbindThread(oldClassLoader);
                }
                try {
                    GeronimoStandardContext.super.startInternal();
                }
                catch (LifecycleException e) {
                    throw (IOException)new IOException("wrapping lifecycle exception").initCause(e);
                }
                if (!GeronimoStandardContext.this.getAvailable()) {
                    throw new IOException("Context did not start for an unknown reason");
                }
            } else {
                this.getNext().invoke(request, response);
            }
        }
    }
}

