/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.Map;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardEngine;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.system.jmx.MBeanServerReference;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.HostGBean;
import org.apache.geronimo.tomcat.LifecycleListenerGBean;
import org.apache.geronimo.tomcat.ManagerGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatServerGBean;
import org.apache.geronimo.tomcat.ValveGBean;
import org.apache.geronimo.tomcat.cluster.CatalinaClusterGBean;
import org.apache.geronimo.tomcat.security.jacc.JACCRealm;
import org.apache.tomcat.util.modeler.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class EngineGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Logger log = LoggerFactory.getLogger(EngineGBean.class);
    private static final String NAME = "name";
    private static final String DEFAULTHOST = "defaultHost";
    private final Engine engine;

    public EngineGBean(@ParamReference(name="Server") TomcatServerGBean server, @ParamAttribute(name="serviceName") String serviceName, @ParamAttribute(name="className") String className, @ParamAttribute(name="initParams") Map initParams, @ParamReference(name="DefaultHost", namingType="Host") HostGBean defaultHost, @ParamReference(name="RealmGBean", namingType="GBean") ObjectRetriever realmGBean, @ParamReference(name="ConfigurationFactory", namingType="GBean") ConfigurationFactory configurationFactory, @ParamReference(name="TomcatValveChain", namingType="TomcatValve") ValveGBean tomcatValveChain, @ParamReference(name="LifecycleListenerChain", namingType="TomcatLifecycleListener") LifecycleListenerGBean listenerChain, @ParamReference(name="CatalinaCluster", namingType="Cluster") CatalinaClusterGBean clusterGBean, @ParamReference(name="Manager", namingType="Manager") ManagerGBean manager, @ParamReference(name="MBeanServerReference") MBeanServerReference mbeanServerReference) throws Exception {
        if (server == null) {
            if (className == null) {
                className = "org.apache.geronimo.tomcat.TomcatEngine";
            }
            if (initParams == null) {
                throw new IllegalArgumentException("Must have 'name' value in initParams.");
            }
            if (defaultHost == null) {
                throw new IllegalArgumentException("Must have a 'defaultHost' attribute.");
            }
            if (!initParams.containsKey(NAME)) {
                throw new IllegalArgumentException("Must have a 'name' value initParams.");
            }
            if (initParams.containsKey(DEFAULTHOST)) {
                log.warn("The defaultHost initParams value is no longer used and will be ignored.");
                initParams.remove(DEFAULTHOST);
            }
            this.engine = (Engine)Class.forName(className).newInstance();
            this.setParameters(this.engine, initParams);
            this.engine.setRealm((Realm)JACCRealm.INSTANCE);
            Host host = (Host)defaultHost.getInternalObject();
            if (host.getParent() != null) {
                throw new IllegalStateException("Default host is already in use by another engine: " + host.getParent());
            }
            this.engine.setDefaultHost(host.getName());
            this.addHost(host);
            if (manager != null) {
                this.engine.setManager((Manager)manager.getInternalObject());
            }
            if (this.engine instanceof StandardEngine) {
                if (tomcatValveChain != null) {
                    for (ValveGBean valveGBean = tomcatValveChain; valveGBean != null; valveGBean = valveGBean.getNextValve()) {
                        ((StandardEngine)this.engine).addValve((Valve)valveGBean.getInternalObject());
                    }
                }
                if (listenerChain != null) {
                    for (LifecycleListenerGBean listenerGBean = listenerChain; listenerGBean != null; listenerGBean = listenerGBean.getNextListener()) {
                        ((StandardEngine)this.engine).addLifecycleListener((LifecycleListener)listenerGBean.getInternalObject());
                    }
                }
            }
            if (mbeanServerReference != null) {
                Registry.getRegistry(null, null).setMBeanServer(mbeanServerReference.getMBeanServer());
            }
            if (clusterGBean != null) {
                this.engine.setCluster((Cluster)clusterGBean.getInternalObject());
            }
        } else {
            this.engine = (Engine)server.getService(serviceName).getContainer();
        }
    }

    public void removeHost(Host host) {
        this.engine.removeChild((Container)host);
    }

    public void addHost(Host host) {
        this.engine.addChild((Container)host);
    }

    @Override
    public Object getInternalObject() {
        return this.engine;
    }

    public void doFail() {
        log.warn("Failed");
    }

    public void doStart() throws Exception {
        log.debug("Started");
    }

    public void doStop() throws Exception {
        log.debug("Stopped");
    }
}

