/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardEngine;
import org.apache.geronimo.tomcat.model.ClusterType;
import org.apache.geronimo.tomcat.model.HostType;
import org.apache.geronimo.tomcat.model.ListenerType;
import org.apache.geronimo.tomcat.model.RealmType;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EngineType", propOrder={"realm", "host", "cluster", "listener"})
public class EngineType {
    @XmlElement(name="Realm")
    protected RealmType realm;
    @XmlElement(name="Host")
    protected List<HostType> host;
    @XmlElement(name="Cluster")
    protected ClusterType cluster;
    @XmlElement(name="Listener")
    protected List<ListenerType> listener;
    @XmlAttribute
    protected String className = StandardEngine.class.getName();
    @XmlAttribute
    protected String name;
    @XmlAttribute
    protected String defaultHost;
    @XmlAttribute
    protected String jvmRoute;
    @XmlAttribute
    protected Integer backgroundProcessorDelay;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public RealmType getRealm() {
        return this.realm;
    }

    public void setRealm(RealmType value) {
        this.realm = value;
    }

    public List<HostType> getHost() {
        if (this.host == null) {
            this.host = new ArrayList<HostType>();
        }
        return this.host;
    }

    public ClusterType getCluster() {
        return this.cluster;
    }

    public List<ListenerType> getListener() {
        if (this.listener == null) {
            this.listener = new ArrayList<ListenerType>();
        }
        return this.listener;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String value) {
        this.defaultHost = value;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public void setJvmRoute(String value) {
        this.jvmRoute = value;
    }

    public Integer getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    public void setBackgroundProcessorDelay(Integer value) {
        this.backgroundProcessorDelay = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public Engine getEngine(ClassLoader cl) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", this.getName());
        properties.put("defaultHost", this.getDefaultHost());
        properties.put("jvmRoute", this.getJvmRoute());
        properties.put("backgroundProcessorDelay", this.getBackgroundProcessorDelay());
        for (Map.Entry<QName, String> entry : this.otherAttributes.entrySet()) {
            String name = entry.getKey().getLocalPart();
            properties.put(name, entry.getValue());
        }
        ObjectRecipe recipe = new ObjectRecipe(this.className, properties);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        Engine engine = (Engine)recipe.create(cl);
        if (this.realm != null) {
            Realm realm = this.realm.getRealm(cl);
            engine.setRealm(realm);
        }
        for (HostType hostType : this.getHost()) {
            Host host = hostType.getHost(cl);
            engine.addChild((Container)host);
        }
        if (this.getCluster() != null) {
            engine.setCluster(this.getCluster().getCluster(cl));
        }
        if (engine instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)engine;
            for (ListenerType listenerType : this.getListener()) {
                LifecycleListener listener = listenerType.getLifecycleListener(cl);
                lifecycle.addLifecycleListener(listener);
            }
        }
        return engine;
    }
}

