/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.interceptor;

import java.util.Set;
import javax.resource.ResourceException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.SharedConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;

public class InstanceContextBeforeAfter
implements BeforeAfter {
    private final BeforeAfter next;
    private final int oldIndex;
    private final int newIndex;
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;

    public InstanceContextBeforeAfter(BeforeAfter next, int oldIndex, int newIndex, Set unshareableResources, Set applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator) {
        this.next = next;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
    }

    public void before(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        try {
            SharedConnectorInstanceContext newConnectorInstanceContext = new SharedConnectorInstanceContext(this.unshareableResources, this.applicationManagedSecurityResources, false);
            ConnectorInstanceContext oldContext = this.trackedConnectionAssociator.enter((ConnectorInstanceContext)newConnectorInstanceContext);
            if (oldContext != null) {
                newConnectorInstanceContext.share(oldContext);
            }
            context[this.oldIndex] = oldContext;
            context[this.newIndex] = newConnectorInstanceContext;
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        if (this.next != null) {
            this.next.before(context, httpRequest, httpResponse, dispatch);
        }
    }

    public void after(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        if (this.next != null) {
            this.next.after(context, httpRequest, httpResponse, dispatch);
        }
        try {
            ConnectorInstanceContext oldConnectorInstanceContext = (ConnectorInstanceContext)context[this.oldIndex];
            SharedConnectorInstanceContext newConnectorInstanceContext = (SharedConnectorInstanceContext)context[this.newIndex];
            if (oldConnectorInstanceContext != null) {
                newConnectorInstanceContext.hide();
            }
            this.trackedConnectionAssociator.exit(oldConnectorInstanceContext);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }
}

