/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.util.HashMap;
import java.util.Map;
import javax.management.j2ee.statistics.Stats;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.CommonProtocol;
import org.apache.geronimo.tomcat.connector.TomcatWebConnector;

public abstract class ConnectorGBean
extends BaseGBean
implements CommonProtocol,
GBeanLifecycle,
ObjectRetriever,
TomcatWebConnector {
    private static final Log log = LogFactory.getLog(ConnectorGBean.class);
    public static final String CONNECTOR_CONTAINER_REFERENCE = "TomcatContainer";
    protected final ServerInfo serverInfo;
    protected final Connector connector;
    private final TomcatContainer container;
    private String name;
    public static final GBeanInfo GBEAN_INFO;

    public ConnectorGBean(String name, Map initParams, String tomcatProtocol, TomcatContainer container, ServerInfo serverInfo) throws Exception {
        if (initParams == null) {
            initParams = new HashMap();
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (container == null) {
            throw new IllegalArgumentException("container cannot be null.");
        }
        if (serverInfo == null) {
            throw new IllegalArgumentException("serverInfo cannot be null.");
        }
        tomcatProtocol = this.validateProtocol(tomcatProtocol);
        this.name = name;
        this.container = container;
        this.serverInfo = serverInfo;
        this.connector = new Connector(tomcatProtocol);
        this.setParameters(this.connector, initParams);
    }

    public void doFail() {
        log.warn((Object)(this.name + " connector failed"));
        this.doStop();
    }

    public void doStart() throws LifecycleException {
        this.container.addConnector(this.connector);
        this.connector.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + " connector started"));
        }
    }

    public void doStop() {
        try {
            this.connector.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)e);
        }
        this.container.removeConnector(this.connector);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + " connector stopped"));
        }
    }

    protected String validateProtocol(String tomcatProtocol) {
        return tomcatProtocol;
    }

    public abstract int getDefaultPort();

    public abstract String getGeronimoProtocol();

    public abstract Stats getStats();

    public abstract void resetStats();

    public Object getInternalObject() {
        return this.connector;
    }

    public String getName() {
        return this.name;
    }

    public void setAllowTrace(boolean allow) {
        this.connector.setAllowTrace(allow);
    }

    public boolean getAllowTrace() {
        return this.connector.getAllowTrace();
    }

    public void setEmptySessionPath(boolean emptySessionPath) {
        this.connector.setEmptySessionPath(emptySessionPath);
    }

    public void setEnableLookups(boolean enabled) {
        this.connector.setEnableLookups(enabled);
    }

    public int getMaxPostSize() {
        int value = this.connector.getMaxPostSize();
        return value == 0 ? 0x200000 : value;
    }

    public void setMaxPostSize(int bytes) {
        this.connector.setMaxPostSize(bytes);
    }

    public String getProtocol() {
        return this.getGeronimoProtocol();
    }

    public String getTomcatProtocol() {
        return this.connector.getProtocol();
    }

    public String getProxyName() {
        return this.connector.getProxyName();
    }

    public int getProxyPort() {
        return this.connector.getProxyPort();
    }

    public int getRedirectPort() {
        return this.connector.getRedirectPort();
    }

    public String getScheme() {
        return this.connector.getScheme();
    }

    public boolean getSecure() {
        return this.connector.getSecure();
    }

    public String getUriEncoding() {
        return this.connector.getURIEncoding();
    }

    public boolean getUseBodyEncodingForURI() {
        return this.connector.getUseBodyEncodingForURI();
    }

    public boolean getUseIPVHosts() {
        return this.connector.getUseIPVHosts();
    }

    public void setMaxSavePostSize(int maxSavePostSize) {
        this.connector.setMaxSavePostSize(maxSavePostSize);
    }

    public void setProxyName(String proxyName) {
        if (proxyName.equals("")) {
            proxyName = null;
        }
        this.connector.setProxyName(proxyName);
    }

    public void setProxyPort(int port) {
        this.connector.setProxyPort(port);
    }

    public void setRedirectPort(int port) {
        this.connector.setRedirectPort(port);
    }

    public void setScheme(String scheme) {
        this.connector.setScheme(scheme);
    }

    public void setSecure(boolean secure) {
        this.connector.setSecure(secure);
    }

    public boolean getSslEnabled() {
        Object value = this.connector.getAttribute("SSLEnabled");
        return value == null ? false : new Boolean(value.toString());
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.connector.setAttribute("SSLEnabled", (Object)sslEnabled);
    }

    public void setUriEncoding(String uriEncoding) {
        this.connector.setURIEncoding(uriEncoding);
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.connector.setUseBodyEncodingForURI(useBodyEncodingForURI);
    }

    public void setUseIPVHosts(boolean useIPVHosts) {
        this.connector.setUseIPVHosts(useIPVHosts);
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.connector.setXpoweredBy(xpoweredBy);
    }

    public boolean getEnableLookups() {
        return this.connector.getEnableLookups();
    }

    public int getMaxSavePostSize() {
        int value = this.connector.getMaxSavePostSize();
        return value == 0 ? 4096 : value;
    }

    public boolean getEmptySessionPath() {
        return this.connector.getEmptySessionPath();
    }

    public boolean getXpoweredBy() {
        return this.connector.getXpoweredBy();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Connector", ConnectorGBean.class);
        infoFactory.addAttribute("name", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addAttribute("protocol", String.class, true);
        infoFactory.addReference(CONNECTOR_CONTAINER_REFERENCE, TomcatContainer.class, "GBean");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(ObjectRetriever.class);
        infoFactory.addInterface(TomcatWebConnector.class);
        infoFactory.addInterface(CommonProtocol.class, new String[]{"allowTrace", "emptySessionPath", "enableLookups", "maxPostSize", "maxSavePostSize", "protocol", "tomcatProtocol", "proxyName", "proxyPort", "redirectPort", "scheme", "secure", "sslEnabled", "uriEncoding", "useBodyEncodingForURI", "useIPVHosts", "xpoweredBy"}, new String[]{"allowTrace", "emptySessionPath", "enableLookups", "maxPostSize", "maxSavePostSize", "protocol", "tomcatProtocol", "proxyName", "proxyPort", "redirectPort", "scheme", "secure", "sslEnabled", "uriEncoding", "useBodyEncodingForURI", "useIPVHosts", "xpoweredBy"});
        infoFactory.setConstructor(new String[]{"name", "initParams", "protocol", CONNECTOR_CONTAINER_REFERENCE, "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

