/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.interceptor;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;

public class UserTransactionBeforeAfter
implements BeforeAfter {
    private static Log log = LogFactory.getLog(UserTransactionBeforeAfter.class);
    private final UserTransaction userTransaction;
    private final BeforeAfter next;
    private final int index;

    public UserTransactionBeforeAfter(BeforeAfter next, int index, UserTransaction userTransaction) {
        this.next = next;
        this.index = index;
        this.userTransaction = userTransaction;
    }

    public void after(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        boolean active;
        if (this.next != null) {
            this.next.after(context, httpRequest, httpResponse, dispatch);
        }
        if (!(active = ((Boolean)context[this.index]).booleanValue()) && this.isMarkedRollback() || dispatch == 0 && this.isActive()) {
            try {
                this.userTransaction.rollback();
            }
            catch (SystemException e) {
                throw new RuntimeException("Error rolling back transaction left open by user program", e);
            }
        }
    }

    public void before(Object[] context, ServletRequest request, ServletResponse response, int dispatch) {
        context[this.index] = this.isActive();
        this.next.before(context, request, response, dispatch);
    }

    private boolean isActive() {
        try {
            return this.userTransaction.getStatus() != 6 && this.userTransaction.getStatus() != 3;
        }
        catch (SystemException e) {
            log.error((Object)"Could not determine transaction status", (Throwable)e);
            throw new RuntimeException("Could not determine transaction status", e);
        }
    }

    private boolean isMarkedRollback() {
        try {
            return this.userTransaction.getStatus() == 1;
        }
        catch (SystemException e) {
            log.error((Object)"Could not determine transaction status", (Throwable)e);
            throw new RuntimeException("Could not determine transaction status", e);
        }
    }
}

