/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.ArrayList;
import java.util.Map;
import org.apache.catalina.Cluster;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardHost;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.LifecycleListenerGBean;
import org.apache.geronimo.tomcat.ManagerGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.ValveGBean;
import org.apache.geronimo.tomcat.cluster.CatalinaClusterGBean;

public class HostGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Log log = LogFactory.getLog(HostGBean.class);
    public static final String J2EE_TYPE = "Host";
    private static final String WORKDIR = "workDir";
    private static final String NAME = "name";
    private final Host host;
    public static final GBeanInfo GBEAN_INFO;

    public HostGBean() {
        this.host = null;
    }

    public HostGBean(String className, Map initParams, ArrayList aliases, ObjectRetriever realmGBean, ValveGBean tomcatValveChain, LifecycleListenerGBean listenerChain, CatalinaClusterGBean clusterGBean, ManagerGBean manager) throws Exception {
        if (className == null) {
            className = "org.apache.catalina.core.StandardHost";
        }
        if (initParams == null) {
            throw new IllegalArgumentException("Must have a 'name' value in initParams.");
        }
        if (!initParams.containsKey(NAME)) {
            throw new IllegalArgumentException("Must have a 'name' value initParams.");
        }
        if (!initParams.containsKey(WORKDIR)) {
            initParams.put(WORKDIR, "work");
        }
        this.host = (Host)Class.forName(className).newInstance();
        this.setParameters(this.host, initParams);
        if (aliases != null) {
            for (String alias : aliases) {
                this.host.addAlias(alias);
            }
        }
        if (realmGBean != null) {
            this.host.setRealm((Realm)realmGBean.getInternalObject());
        }
        if (this.host instanceof StandardHost) {
            if (tomcatValveChain != null) {
                for (ValveGBean valveGBean = tomcatValveChain; valveGBean != null; valveGBean = valveGBean.getNextValve()) {
                    ((StandardHost)this.host).addValve((Valve)valveGBean.getInternalObject());
                }
            }
            if (listenerChain != null) {
                for (LifecycleListenerGBean listenerGBean = listenerChain; listenerGBean != null; listenerGBean = listenerGBean.getNextListener()) {
                    ((StandardHost)this.host).addLifecycleListener((LifecycleListener)listenerGBean.getInternalObject());
                }
            }
        }
        if (clusterGBean != null) {
            this.host.setCluster((Cluster)clusterGBean.getInternalObject());
        }
        if (manager != null) {
            this.host.setManager((Manager)manager.getInternalObject());
        }
    }

    public Object getInternalObject() {
        return this.host;
    }

    public void doFail() {
        log.warn((Object)"Failed");
    }

    public void doStart() throws Exception {
        log.debug((Object)("Started host name '" + this.host.getName() + "'"));
    }

    public void doStop() throws Exception {
        log.debug((Object)("Stopped host '" + this.host.getName() + "'"));
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"TomcatHost", HostGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addAttribute("aliases", ArrayList.class, true);
        infoFactory.addReference("RealmGBean", ObjectRetriever.class, "GBean");
        infoFactory.addReference("TomcatValveChain", ValveGBean.class, "TomcatValve");
        infoFactory.addReference("LifecycleListenerChain", LifecycleListenerGBean.class, "TomcatLifecycleListener");
        infoFactory.addReference("CatalinaCluster", CatalinaClusterGBean.class, "Cluster");
        infoFactory.addReference("Manager", ManagerGBean.class, "Manager");
        infoFactory.addOperation("getInternalObject");
        infoFactory.setConstructor(new String[]{"className", "initParams", "aliases", "RealmGBean", "TomcatValveChain", "LifecycleListenerChain", "CatalinaCluster", "Manager"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

