/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.tools.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import org.apache.geronimo.deployment.tools.loader.AbstractDeployable;
import org.apache.geronimo.kernel.config.MultiParentClassLoader;

public class WebDeployable
extends AbstractDeployable {
    private final ClassLoader webLoader;

    public WebDeployable(URL moduleURL) throws DDBeanCreateException {
        this(moduleURL, null);
    }

    public WebDeployable(URL moduleURL, List parentClassLoaders) throws DDBeanCreateException {
        super(ModuleType.WAR, moduleURL, "WEB-INF/web.xml");
        ClassLoader parent = super.getModuleLoader();
        ArrayList<URL> path = new ArrayList<URL>();
        URL url = parent.getResource("WEB-INF/classes/");
        if (url != null) {
            path.add(url);
        }
        Enumeration e = this.entries();
        while (e.hasMoreElements()) {
            String jarName;
            String entry = (String)e.nextElement();
            if (!entry.startsWith("WEB-INF/lib/") || (jarName = entry.substring(12)).indexOf(47) != -1 || !jarName.endsWith(".jar") && !jarName.endsWith(".zip")) continue;
            path.add(parent.getResource(entry));
        }
        URL[] urls = path.toArray(new URL[path.size()]);
        if (parentClassLoaders != null) {
            parentClassLoaders.add(parent);
            ClassLoader[] parents = parentClassLoaders.toArray(new ClassLoader[parentClassLoaders.size()]);
            this.webLoader = new MultiParentClassLoader(null, urls, parents);
        } else {
            this.webLoader = new URLClassLoader(urls, parent);
        }
    }

    public ClassLoader getModuleLoader() {
        return this.webLoader;
    }
}

