/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.serverinfo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ServerConstants {
    private static final String VERSION;
    private static final String BUILD_DATE;
    private static final String BUILD_TIME;
    private static final String COPYRIGHT;

    public static String getVersion() {
        return VERSION;
    }

    public static String getBuildDate() {
        return BUILD_DATE;
    }

    public static String getBuildTime() {
        return BUILD_TIME;
    }

    public static String getCopyright() {
        return COPYRIGHT;
    }

    static {
        Properties versionInfo = new Properties();
        try {
            InputStream input = ServerConstants.class.getClassLoader().getResourceAsStream("org/apache/geronimo/system/serverinfo/geronimo-version.properties");
            if (input == null) {
                throw new Error("Missing geronimo-version.properties");
            }
            versionInfo.load(input);
        }
        catch (IOException e) {
            throw new Error("Could not load geronimo-version.properties", e);
        }
        VERSION = versionInfo.getProperty("version");
        if (VERSION == null || VERSION.length() == 0) {
            throw new Error("geronimo-version.properties does not contain a 'version' property");
        }
        BUILD_DATE = versionInfo.getProperty("build.date");
        if (BUILD_DATE == null || BUILD_DATE.length() == 0) {
            throw new Error("geronimo-version.properties does not contain a 'build.date' property");
        }
        BUILD_TIME = versionInfo.getProperty("build.time");
        if (BUILD_TIME == null || BUILD_TIME.length() == 0) {
            throw new Error("geronimo-version.properties does not contain a 'build.time' property");
        }
        COPYRIGHT = versionInfo.getProperty("copyright");
        if (COPYRIGHT == null || COPYRIGHT.length() == 0) {
            throw new Error("geronimo-version.properties does not contain a 'copyright' property");
        }
    }
}

