/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class DirectoryInitializationGBean {
    public static final GBeanInfo GBEAN_INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryInitializationGBean(String prefix, String path, ServerInfo serverInfo, ClassLoader classLoader) throws IOException {
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        int prefixLength = prefix.length();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        URL sourceURL = classLoader.getResource(prefix + path);
        URLConnection conn = sourceURL.openConnection();
        JarURLConnection jarConn = (JarURLConnection)conn;
        JarFile jarFile = jarConn.getJarFile();
        JarEntry sourceEntry = jarConn.getJarEntry();
        byte[] buf = new byte[8192];
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String entryName;
            String entryPath;
            File targetPath;
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(sourceEntry.getName()) || (targetPath = serverInfo.resolveServer(entryPath = (entryName = entry.getName()).substring(prefixLength))).exists()) continue;
            if (entry.isDirectory()) {
                targetPath.mkdirs();
                continue;
            }
            InputStream in = jarFile.getInputStream(entry);
            try {
                FileOutputStream out = new FileOutputStream(targetPath);
                try {
                    int chunk;
                    while ((chunk = in.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, chunk);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                in.close();
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)DirectoryInitializationGBean.class, (String)"GBean");
        infoBuilder.addAttribute("prefix", String.class, true);
        infoBuilder.addAttribute("path", String.class, true);
        infoBuilder.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.setConstructor(new String[]{"prefix", "path", "ServerInfo", "classLoader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

