/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.jmx.MBeanServerNotFound;
import org.apache.geronimo.system.jmx.MBeanServerReference;

public class RealMBeanServerReference
implements MBeanServerReference {
    private MBeanServer mbeanServer;
    public static final GBeanInfo GBEAN_INFO;

    public RealMBeanServerReference(String mbeanServerId) throws MBeanServerNotFound {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(mbeanServerId);
        if (servers.size() == 0) {
            this.mbeanServer = MBeanServerFactory.createMBeanServer("geronimo");
        } else {
            if (servers.size() > 1) {
                throw new MBeanServerNotFound(servers.size() + " MBeanServers were found with the agent id " + mbeanServerId);
            }
            this.mbeanServer = servers.get(0);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)RealMBeanServerReference.class);
        infoFactory.addAttribute("mbeanServerId", String.class, true);
        infoFactory.setConstructor(new String[]{"mbeanServerId"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

