/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.kernel.management.NotificationType;

public final class JMXUtil {
    private JMXUtil() {
    }

    public static MBeanInfo toMBeanInfo(GBeanInfo gBeanInfo) {
        String className = gBeanInfo.getClassName();
        String description = "No description available";
        Set gbeanAttributes = gBeanInfo.getAttributes();
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[gbeanAttributes.size()];
        int a = 0;
        Iterator iterator = gbeanAttributes.iterator();
        while (iterator.hasNext()) {
            GAttributeInfo gAttributeInfo = (GAttributeInfo)iterator.next();
            attributes[a] = new MBeanAttributeInfo(gAttributeInfo.getName(), gAttributeInfo.getType(), "no description available", gAttributeInfo.isReadable(), gAttributeInfo.isWritable(), JMXUtil.isIs(gAttributeInfo));
            ++a;
        }
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{};
        Set gbeanOperations = gBeanInfo.getOperations();
        MBeanOperationInfo[] operations = new MBeanOperationInfo[gbeanOperations.size()];
        int o = 0;
        Iterator iterator2 = gbeanOperations.iterator();
        while (iterator2.hasNext()) {
            GOperationInfo gOperationInfo = (GOperationInfo)iterator2.next();
            List gparameters = gOperationInfo.getParameterList();
            MBeanParameterInfo[] parameters = new MBeanParameterInfo[gparameters.size()];
            int p = 0;
            Iterator piterator = gparameters.iterator();
            while (piterator.hasNext()) {
                String type = (String)piterator.next();
                parameters[p] = new MBeanParameterInfo("parameter" + p, type, "no description available");
                ++p;
            }
            operations[o] = new MBeanOperationInfo(gOperationInfo.getName(), "no description available", parameters, "java.lang.Object", 3);
            ++o;
        }
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(NotificationType.TYPES, "javax.management.Notification", "J2EE Notifications")};
        MBeanInfo mbeanInfo = new MBeanInfo(className, description, attributes, constructors, operations, notifications);
        return mbeanInfo;
    }

    private static boolean isIs(GAttributeInfo gAttributeInfo) {
        String getterName = gAttributeInfo.getGetterName();
        if (getterName == null) {
            return false;
        }
        return getterName.startsWith("is");
    }
}

