/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.apache.geronimo.system.configuration.InvalidAttributeException;
import org.apache.geronimo.system.configuration.OutputFormat;
import org.apache.geronimo.system.configuration.XMLSerializer;
import org.apache.geronimo.util.EncryptionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GBeanOverride
implements Serializable {
    private final Object name;
    private boolean load;
    private final Map attributes = new LinkedHashMap();
    private final Map references = new LinkedHashMap();
    private final ArrayList clearAttributes = new ArrayList();
    private final ArrayList nullAttributes = new ArrayList();
    private final ArrayList clearReferences = new ArrayList();
    private final String gbeanInfo;

    public GBeanOverride(String name, boolean load) {
        this.name = name;
        this.load = load;
        this.gbeanInfo = null;
    }

    public GBeanOverride(AbstractName name, boolean load) {
        this.name = name;
        this.load = load;
        this.gbeanInfo = null;
    }

    public GBeanOverride(GBeanData gbeanData) throws InvalidAttributeException {
        GBeanInfo gbeanInfo = gbeanData.getGBeanInfo();
        this.gbeanInfo = gbeanInfo.getSourceClass();
        if (this.gbeanInfo == null) {
            throw new IllegalArgumentException("GBeanInfo must have a source class set");
        }
        this.name = gbeanData.getAbstractName();
        this.load = true;
        Iterator iterator = gbeanData.getAttributes().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String attributeName = (String)entry.getKey();
            GAttributeInfo attributeInfo = gbeanInfo.getAttribute(attributeName);
            if (attributeInfo == null) {
                throw new InvalidAttributeException("No attribute: " + attributeName + " for gbean: " + gbeanData.getAbstractName());
            }
            Object attributeValue = entry.getValue();
            this.setAttribute(attributeName, attributeValue, attributeInfo.getType());
        }
        this.references.putAll(gbeanData.getReferences());
    }

    public GBeanOverride(Element gbean) throws InvalidGBeanException {
        String nameString = gbean.getAttribute("name");
        this.name = nameString.indexOf(63) > -1 ? new AbstractName(URI.create(nameString)) : nameString;
        String gbeanInfoString = gbean.getAttribute("gbeanInfo");
        this.gbeanInfo = gbeanInfoString.length() > 0 ? gbeanInfoString : null;
        if (this.gbeanInfo != null && !(this.name instanceof AbstractName)) {
            throw new InvalidGBeanException("A gbean element using the gbeanInfo attribute must be specified using a full AbstractName: name=" + nameString);
        }
        String loadString = gbean.getAttribute("load");
        this.load = !"false".equals(loadString);
        NodeList attributes = gbean.getElementsByTagName("attribute");
        for (int a = 0; a < attributes.getLength(); ++a) {
            String nullString;
            Element attribute = (Element)attributes.item(a);
            String attributeName = attribute.getAttribute("name");
            if (attribute.hasAttribute("value")) {
                this.setAttribute(attributeName, (String)EncryptionManager.decrypt((String)attribute.getAttribute("value")));
                continue;
            }
            if (attribute.hasAttribute("null") && (nullString = attribute.getAttribute("null")).equals("true")) {
                this.setNullAttribute(attributeName);
                continue;
            }
            String rawAttribute = GBeanOverride.getContentsAsText(attribute);
            if (rawAttribute.length() == 0) {
                this.setClearAttribute(attributeName);
                continue;
            }
            String attributeValue = (String)EncryptionManager.decrypt((String)rawAttribute);
            this.setAttribute(attributeName, attributeValue);
        }
        NodeList references = gbean.getElementsByTagName("reference");
        for (int r = 0; r < references.getLength(); ++r) {
            Element reference = (Element)references.item(r);
            String referenceName = reference.getAttribute("name");
            LinkedHashSet<AbstractNameQuery> objectNamePatterns = new LinkedHashSet<AbstractNameQuery>();
            NodeList patterns = reference.getElementsByTagName("pattern");
            if (patterns.getLength() == 0) {
                this.setClearReference(referenceName);
                continue;
            }
            for (int p = 0; p < patterns.getLength(); ++p) {
                Element pattern = (Element)patterns.item(p);
                if (pattern == null) continue;
                String groupId = GBeanOverride.getChildAsText(pattern, "groupId");
                String artifactId = GBeanOverride.getChildAsText(pattern, "artifactId");
                String version = GBeanOverride.getChildAsText(pattern, "version");
                String type = GBeanOverride.getChildAsText(pattern, "type");
                String module = GBeanOverride.getChildAsText(pattern, "module");
                String name = GBeanOverride.getChildAsText(pattern, "name");
                Artifact referenceArtifact = null;
                if (artifactId != null) {
                    referenceArtifact = new Artifact(groupId, artifactId, version, type);
                }
                HashMap<String, String> nameMap = new HashMap<String, String>();
                if (module != null) {
                    nameMap.put("module", module);
                }
                if (name != null) {
                    nameMap.put("name", name);
                }
                AbstractNameQuery abstractNameQuery = new AbstractNameQuery(referenceArtifact, nameMap, Collections.EMPTY_SET);
                objectNamePatterns.add(abstractNameQuery);
            }
            this.setReferencePatterns(referenceName, new ReferencePatterns(objectNamePatterns));
        }
    }

    private static String getChildAsText(Element element, String name) throws InvalidGBeanException {
        NodeList children = element.getElementsByTagName(name);
        if (children == null || children.getLength() == 0) {
            return null;
        }
        if (children.getLength() > 1) {
            throw new InvalidGBeanException("invalid name, too many parts named: " + name);
        }
        return GBeanOverride.getContentsAsText((Element)children.item(0));
    }

    private static String getContentsAsText(Element element) throws InvalidGBeanException {
        String value = "";
        NodeList text = element.getChildNodes();
        for (int t = 0; t < text.getLength(); ++t) {
            Node n = text.item(t);
            if (n.getNodeType() == 3) {
                value = value + n.getNodeValue();
                continue;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            OutputFormat of = new OutputFormat("xml", null, false);
            of.setOmitXMLDeclaration(true);
            XMLSerializer serializer = new XMLSerializer(pw, of);
            try {
                serializer.prepare();
                serializer.serializeNode(n);
                value = value + sw.toString();
                continue;
            }
            catch (IOException ioe) {
                throw new InvalidGBeanException("Error serializing GBean element", (Throwable)ioe);
            }
        }
        return value.trim();
    }

    public Object getName() {
        return this.name;
    }

    public String getGBeanInfo() {
        return this.gbeanInfo;
    }

    public boolean isLoad() {
        return this.load;
    }

    public void setLoad(boolean load) {
        this.load = load;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attributeName) {
        return (String)this.attributes.get(attributeName);
    }

    public ArrayList getClearAttributes() {
        return this.clearAttributes;
    }

    public ArrayList getNullAttributes() {
        return this.nullAttributes;
    }

    public boolean getNullAttribute(String attributeName) {
        return this.nullAttributes.contains(attributeName);
    }

    public boolean getClearAttribute(String attributeName) {
        return this.clearAttributes.contains(attributeName);
    }

    public ArrayList getClearReferences() {
        return this.clearReferences;
    }

    public boolean getClearReference(String referenceName) {
        return this.clearReferences.contains(referenceName);
    }

    public void setClearAttribute(String attributeName) {
        if (!this.clearAttributes.contains(attributeName)) {
            this.clearAttributes.add(attributeName);
        }
    }

    public void setNullAttribute(String attributeName) {
        if (!this.nullAttributes.contains(attributeName)) {
            this.nullAttributes.add(attributeName);
        }
    }

    public void setClearReference(String referenceName) {
        if (!this.clearReferences.contains(referenceName)) {
            this.clearReferences.add(referenceName);
        }
    }

    public void setAttribute(String attributeName, Object attributeValue, String attributeType) throws InvalidAttributeException {
        String stringValue = GBeanOverride.getAsText(attributeValue, attributeType);
        this.attributes.put(attributeName, stringValue);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public Map getReferences() {
        return this.references;
    }

    public ReferencePatterns getReferencePatterns(String name) {
        return (ReferencePatterns)this.references.get(name);
    }

    public void setReferencePatterns(String name, ReferencePatterns patterns) {
        this.references.put(name, patterns);
    }

    public Element writeXml(Document doc, Element parent) {
        Element attribute;
        String name;
        String name2;
        Map.Entry entry;
        String gbeanName = this.name instanceof String ? (String)this.name : this.name.toString();
        Element gbean = doc.createElement("gbean");
        parent.appendChild(gbean);
        gbean.setAttribute("name", gbeanName);
        if (this.gbeanInfo != null) {
            gbean.setAttribute("gbeanInfo", this.gbeanInfo);
        }
        if (!this.load) {
            gbean.setAttribute("load", "false");
        }
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            name2 = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                this.setNullAttribute(name2);
                continue;
            }
            if (this.getNullAttribute(name2)) {
                this.nullAttributes.remove(name2);
            }
            if (name2.toLowerCase().indexOf("password") > -1) {
                value = EncryptionManager.encrypt((Serializable)((Object)value));
            }
            Element attribute2 = doc.createElement("attribute");
            attribute2.setAttribute("name", name2);
            gbean.appendChild(attribute2);
            if (value.length() == 0) {
                attribute2.setAttribute("value", "");
                continue;
            }
            try {
                DocumentBuilderFactory factory = XmlUtil.newDocumentBuilderFactory();
                DocumentBuilder builder = factory.newDocumentBuilder();
                String xml = "<fragment>" + value + "</fragment>";
                InputSource input = new InputSource(new StringReader(xml));
                Document fragment = builder.parse(input);
                Node root = fragment.getFirstChild();
                NodeList children = root.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    child = doc.importNode(child, true);
                    attribute2.appendChild(child);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to write attribute value fragment: " + e.getMessage(), e);
            }
        }
        iterator = this.clearAttributes.iterator();
        while (iterator.hasNext()) {
            name = (String)((Object)iterator.next());
            attribute = doc.createElement("attribute");
            gbean.appendChild(attribute);
            attribute.setAttribute("name", name);
        }
        iterator = this.nullAttributes.iterator();
        while (iterator.hasNext()) {
            name = (String)((Object)iterator.next());
            attribute = doc.createElement("attribute");
            gbean.appendChild(attribute);
            attribute.setAttribute("name", name);
            attribute.setAttribute("null", "true");
        }
        iterator = this.references.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            name2 = (String)entry.getKey();
            ReferencePatterns patterns = (ReferencePatterns)entry.getValue();
            Element reference = doc.createElement("reference");
            reference.setAttribute("name", name2);
            gbean.appendChild(reference);
            Set<AbstractNameQuery> patternSet = patterns.isResolved() ? Collections.singleton(new AbstractNameQuery(patterns.getAbstractName())) : patterns.getPatterns();
            Iterator patternIterator = patternSet.iterator();
            while (patternIterator.hasNext()) {
                Map nameMap;
                AbstractNameQuery pattern = (AbstractNameQuery)patternIterator.next();
                Element pat = doc.createElement("pattern");
                reference.appendChild(pat);
                Artifact artifact = pattern.getArtifact();
                if (artifact != null) {
                    if (artifact.getGroupId() != null) {
                        Element group = doc.createElement("groupId");
                        group.appendChild(doc.createTextNode(artifact.getGroupId()));
                        pat.appendChild(group);
                    }
                    if (artifact.getArtifactId() != null) {
                        Element art = doc.createElement("artifactId");
                        art.appendChild(doc.createTextNode(artifact.getArtifactId()));
                        pat.appendChild(art);
                    }
                    if (artifact.getVersion() != null) {
                        Element version = doc.createElement("version");
                        version.appendChild(doc.createTextNode(artifact.getVersion().toString()));
                        pat.appendChild(version);
                    }
                    if (artifact.getType() != null) {
                        Element type = doc.createElement("type");
                        type.appendChild(doc.createTextNode(artifact.getType()));
                        pat.appendChild(type);
                    }
                }
                if ((nameMap = pattern.getName()).get("module") != null) {
                    Element module = doc.createElement("module");
                    module.appendChild(doc.createTextNode(nameMap.get("module").toString()));
                    pat.appendChild(module);
                }
                if (nameMap.get("name") == null) continue;
                Element patName = doc.createElement("name");
                patName.appendChild(doc.createTextNode(nameMap.get("name").toString()));
                pat.appendChild(patName);
            }
        }
        iterator = this.clearReferences.iterator();
        while (iterator.hasNext()) {
            name = (String)((Object)iterator.next());
            Element reference = doc.createElement("reference");
            reference.setAttribute("name", name);
            gbean.appendChild(reference);
        }
        return gbean;
    }

    public static String getAsText(Object value, String type) throws InvalidAttributeException {
        try {
            String attributeStringValue = null;
            if (value != null) {
                PropertyEditor editor = PropertyEditors.findEditor((String)type, (ClassLoader)GBeanOverride.class.getClassLoader());
                if (editor == null) {
                    throw new InvalidAttributeException("Unable to format attribute of type " + type + "; no editor found");
                }
                editor.setValue(value);
                attributeStringValue = editor.getAsText();
            }
            return attributeStringValue;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidAttributeException("Unable to store attribute type " + type);
        }
    }
}

