/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.util;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.x500.X500Principal;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.security.DomainPrincipal;
import org.apache.geronimo.security.PrimaryDomainPrincipal;
import org.apache.geronimo.security.PrimaryPrincipal;
import org.apache.geronimo.security.PrimaryRealmPrincipal;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.deploy.PrincipalInfo;

public class ConfigurationUtil {
    public static X500Principal generateX500Principal(String name) {
        return new X500Principal(name);
    }

    public static Principal generatePrincipal(PrincipalInfo principalInfo, ClassLoader classLoader) {
        return ConfigurationUtil.generatePrincipal(principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static Principal generatePrincipal(final String className, final String principalName, final ClassLoader classLoader) {
        try {
            return (Principal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> clazz = classLoader.loadClass(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
                    return (Principal)constructor.newInstance(principalName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            if (e.getException() != null) {
                e.getException().printStackTrace();
            }
            return null;
        }
    }

    public static RealmPrincipal generateRealmPrincipal(String realm, String loginDomain, PrincipalInfo principalInfo, ClassLoader classLoader) {
        return ConfigurationUtil.generateRealmPrincipal(realm, loginDomain, principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static RealmPrincipal generateRealmPrincipal(String realm, String loginDomain, String className, String principalName, ClassLoader classLoader) {
        return new RealmPrincipal(realm, loginDomain, ConfigurationUtil.generatePrincipal(className, principalName, classLoader));
    }

    public static DomainPrincipal generateDomainPrincipal(String loginDomain, PrincipalInfo principalInfo, ClassLoader classLoader) {
        return ConfigurationUtil.generateDomainPrincipal(loginDomain, principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static DomainPrincipal generateDomainPrincipal(String loginDomain, String className, String principalName, ClassLoader classLoader) {
        return new DomainPrincipal(loginDomain, ConfigurationUtil.generatePrincipal(className, principalName, classLoader));
    }

    public static PrimaryRealmPrincipal generatePrimaryRealmPrincipal(String realm, String domain, PrincipalInfo principalInfo, ClassLoader classLoader) throws DeploymentException {
        return ConfigurationUtil.generatePrimaryRealmPrincipal(realm, domain, principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static PrimaryRealmPrincipal generatePrimaryRealmPrincipal(final String realm, final String domain, final String className, final String principalName, final ClassLoader classLoader) throws DeploymentException {
        try {
            return (PrimaryRealmPrincipal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Principal p = null;
                    Class<?> clazz = classLoader.loadClass(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryRealmPrincipal(realm, domain, p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DeploymentException("Unable to create realm principal", (Throwable)pae.getException());
        }
    }

    public static PrimaryDomainPrincipal generatePrimaryDomainPrincipal(String domain, PrincipalInfo principalInfo, ClassLoader classLoader) throws DeploymentException {
        return ConfigurationUtil.generatePrimaryDomainPrincipal(domain, principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static PrimaryDomainPrincipal generatePrimaryDomainPrincipal(final String domain, final String className, final String principalName, final ClassLoader classLoader) throws DeploymentException {
        try {
            return (PrimaryDomainPrincipal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Principal p = null;
                    Class<?> clazz = classLoader.loadClass(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryDomainPrincipal(domain, p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DeploymentException("Unable to create domain principal", (Throwable)pae.getException());
        }
    }

    public static PrimaryPrincipal generatePrimaryPrincipal(PrincipalInfo principalInfo, ClassLoader classLoader) throws DeploymentException {
        return ConfigurationUtil.generatePrimaryPrincipal(principalInfo.getClassName(), principalInfo.getPrincipalName(), classLoader);
    }

    public static PrimaryPrincipal generatePrimaryPrincipal(final String className, final String principalName, final ClassLoader classLoader) throws DeploymentException {
        try {
            return (PrimaryPrincipal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Principal p = null;
                    Class<?> clazz = classLoader.loadClass(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryPrincipal(p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DeploymentException("Unable to create principal", (Throwable)pae.getException());
        }
    }

    public static void registerPolicyContextHandler(PolicyContextHandler handler, boolean replace) throws PolicyContextException {
        String[] keys = handler.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            PolicyContext.registerHandler((String)keys[i], (PolicyContextHandler)handler, (boolean)replace);
        }
    }
}

