/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.credentialstore;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.security.credentialstore.CredentialStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectConfigurationCredentialStoreImpl
implements CredentialStore {
    private final Map<String, Map<String, Subject>> subjectStore = new HashMap<String, Map<String, Subject>>();
    public static final GBeanInfo GBEAN_INFO;

    public DirectConfigurationCredentialStoreImpl(Map<String, Map<String, Map<String, String>>> subjectInfo, ClassLoader cl) throws DeploymentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        for (Map.Entry<String, Map<String, Map<String, String>>> realmEntry : subjectInfo.entrySet()) {
            HashMap<String, Subject> realm = new HashMap<String, Subject>();
            for (Map.Entry<String, Map<String, String>> subjectEntry : realmEntry.getValue().entrySet()) {
                String id = subjectEntry.getKey();
                Map<String, String> principals = subjectEntry.getValue();
                Subject subject = new Subject();
                for (Map.Entry<String, String> principalInfo : principals.entrySet()) {
                    String className = principalInfo.getKey();
                    String principalName = principalInfo.getValue();
                    Class<?> clazz = cl.loadClass(className);
                    Constructor<?> c = clazz.getConstructor(String.class);
                    Principal p = (Principal)c.newInstance(principalName);
                    subject.getPrincipals().add(p);
                }
                realm.put(id, subject);
            }
            this.subjectStore.put(realmEntry.getKey(), realm);
        }
    }

    @Override
    public Subject getSubject(String realm, String id) throws LoginException {
        Map<String, Subject> realmMap = this.subjectStore.get(realm);
        if (realmMap == null) {
            throw new LoginException("Unknown realm : " + realm);
        }
        Subject subject = realmMap.get(id);
        if (subject == null) {
            throw new LoginException("Unknown id: " + id + " in realm: " + realm);
        }
        return subject;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(DirectConfigurationCredentialStoreImpl.class);
        infoBuilder.addAttribute("credentialStore", Map.class, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.setConstructor(new String[]{"credentialStore", "classLoader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

