/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class RepeatedFailureLockoutLoginModule
implements LoginModule {
    public static final String FAILURE_COUNT_OPTION = "failureCount";
    public static final String FAILURE_PERIOD_OPTION = "failurePeriodSecs";
    public static final String LOCKOUT_DURATION_OPTION = "lockoutDurationSecs";
    private static final HashMap<String, LoginHistory> userData = new HashMap();
    private CallbackHandler handler;
    private String username;
    private int failureCount = 5;
    private int failurePeriod = 300000;
    private int lockoutDuration = 1800000;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String ldString;
        String fpString;
        String fcString = (String)options.get(FAILURE_COUNT_OPTION);
        if (fcString != null && !(fcString = fcString.trim()).equals("")) {
            this.failureCount = Integer.parseInt(fcString);
        }
        if ((fpString = (String)options.get(FAILURE_PERIOD_OPTION)) != null && !(fpString = fpString.trim()).equals("")) {
            this.failurePeriod = Integer.parseInt(fpString) * 1000;
        }
        if ((ldString = (String)options.get(LOCKOUT_DURATION_OPTION)) != null && !(ldString = ldString.trim()).equals("")) {
            this.lockoutDuration = Integer.parseInt(ldString) * 1000;
        }
        this.handler = callbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        NameCallback user = new NameCallback("User name:");
        Callback[] callbacks = new Callback[]{user};
        try {
            this.handler.handle(callbacks);
        }
        catch (Exception e) {
            throw (LoginException)new LoginException("Unable to process callback: " + e.getMessage()).initCause(e);
        }
        if (callbacks.length != 1) {
            throw new IllegalStateException("Number of callbacks changed by server!");
        }
        user = (NameCallback)callbacks[0];
        this.username = user.getName();
        if (this.username != null) {
            LoginHistory history;
            HashMap<String, LoginHistory> hashMap = userData;
            synchronized (hashMap) {
                history = userData.get(this.username);
            }
            if (history != null && !history.isLoginAllowed(this.lockoutDuration, this.failurePeriod, this.failureCount)) {
                this.username = null;
                throw new FailedLoginException("Maximum login failures exceeded; try again later");
            }
        }
        return false;
    }

    public boolean commit() throws LoginException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort() throws LoginException {
        if (this.username != null) {
            LoginHistory history;
            HashMap<String, LoginHistory> hashMap = userData;
            synchronized (hashMap) {
                history = userData.get(this.username);
                if (history == null) {
                    history = new LoginHistory(this.username);
                    userData.put(this.username, history);
                }
            }
            history.addFailure();
            this.username = null;
        }
        return false;
    }

    public boolean logout() throws LoginException {
        this.username = null;
        this.handler = null;
        return false;
    }

    private static class LoginHistory
    implements Serializable {
        private static final long serialVersionUID = 7792298296084531182L;
        private String user;
        private LinkedList<Long> data = new LinkedList();
        private long lockExpires = -1L;

        public LoginHistory(String user) {
            this.user = user;
        }

        public String getUser() {
            return this.user;
        }

        public synchronized boolean isLoginAllowed(int lockoutLengthMillis, int failureAgeMillis, int maxFailures) {
            long now = System.currentTimeMillis();
            this.cleanup(now - (long)failureAgeMillis);
            if (this.lockExpires > now) {
                return false;
            }
            if (this.data.size() >= maxFailures) {
                this.lockExpires = this.data.getLast() + (long)lockoutLengthMillis;
                if (this.lockExpires > now) {
                    return false;
                }
            }
            return true;
        }

        public synchronized void addFailure() {
            this.data.add(System.currentTimeMillis());
        }

        public synchronized void cleanup(long ignoreOlderThan) {
            Long time;
            Iterator it = this.data.iterator();
            while (it.hasNext() && (time = (Long)it.next()) < ignoreOlderThan) {
                it.remove();
            }
        }
    }
}

