/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas.client;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;
import org.apache.geronimo.security.jaas.client.LoginModuleProxy;
import org.apache.geronimo.security.jaas.server.JaasLoginServiceMBean;
import org.apache.geronimo.security.jaas.server.JaasSessionId;

public class ServerLoginProxy
extends LoginModuleProxy {
    CallbackHandler handler;
    Callback[] callbacks;
    private final int lmIndex;
    private final JaasLoginServiceMBean service;
    private final JaasSessionId sessionHandle;

    public ServerLoginProxy(LoginModuleControlFlag controlFlag, Subject subject, int lmIndex, JaasLoginServiceMBean service, JaasSessionId sessionHandle) {
        super(controlFlag, subject);
        this.lmIndex = lmIndex;
        this.service = service;
        this.sessionHandle = sessionHandle;
    }

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        this.handler = handler;
    }

    public boolean login() throws LoginException {
        try {
            this.callbacks = this.service.getServerLoginCallbacks(this.sessionHandle, this.lmIndex);
            if (this.handler != null) {
                this.handler.handle(this.callbacks);
            } else if (this.callbacks != null && this.callbacks.length > 0) {
                System.err.println("No callback handler available for " + this.callbacks.length + " callbacks!");
            }
            return this.service.performLogin(this.sessionHandle, this.lmIndex, this.callbacks);
        }
        catch (FailedLoginException e) {
            throw e;
        }
        catch (Exception e) {
            LoginException le = new LoginException("Error filling callback list");
            le.initCause(e);
            throw le;
        }
    }

    public boolean commit() throws LoginException {
        return this.service.performCommit(this.sessionHandle, this.lmIndex);
    }

    public boolean abort() throws LoginException {
        return this.service.performAbort(this.sessionHandle, this.lmIndex);
    }

    public boolean logout() throws LoginException {
        return false;
    }
}

