/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.jaas.NamedUsernamePasswordCredential;

public class NamedUPCredentialLoginModule
implements LoginModule {
    public static final String CREDENTIAL_NAME = "org.apache.geronimo.jaas.NamedUPCredentialLoginModule.Name";
    private String name;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private NamedUsernamePasswordCredential nupCredential;

    public boolean abort() throws LoginException {
        return this.logout();
    }

    public boolean commit() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Object> pvtCreds = this.subject.getPrivateCredentials();
        if (this.nupCredential != null && !pvtCreds.contains(this.nupCredential)) {
            pvtCreds.add(this.nupCredential);
        }
        return true;
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        String username = ((NameCallback)callbacks[0]).getName();
        char[] password = ((PasswordCallback)callbacks[1]).getPassword();
        if (username == null || password == null) {
            return true;
        }
        this.nupCredential = new NamedUsernamePasswordCredential(username, password, this.name);
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.nupCredential == null) {
            return true;
        }
        Set pvtCreds = this.subject.getPrivateCredentials(NamedUsernamePasswordCredential.class);
        if (pvtCreds.contains(this.nupCredential)) {
            pvtCreds.remove(this.nupCredential);
        }
        try {
            this.nupCredential.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
        this.nupCredential = null;
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.name = (String)options.get(CREDENTIAL_NAME);
    }
}

