/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.geronimo.naming.reference.SimpleReference;

public class ClientEjbReference
extends SimpleReference {
    private final String url;
    private final String deploymentId;

    public ClientEjbReference(String url, String deploymentId) {
        this.url = url;
        this.deploymentId = deploymentId;
    }

    public Object getContent() throws NameNotFoundException {
        Properties p = new Properties();
        p.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        p.put("java.naming.provider.url", this.url);
        p.put("openejb.client.moduleId", "openejb/Deployment");
        try {
            InitialContext ctx = new InitialContext(p);
            Object value = ctx.lookup(this.deploymentId);
            return value;
        }
        catch (NamingException e) {
            throw (NameNotFoundException)new NameNotFoundException().initCause(e);
        }
    }
}

