/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import java.util.Set;
import javax.naming.NameNotFoundException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.naming.reference.ConfigurationAwareReference;

public class GBeanReference
extends ConfigurationAwareReference {
    private final Class type;

    public GBeanReference(Artifact[] configId, Set abstractNameQueries, Class type) {
        super(configId, abstractNameQueries);
        this.type = type;
    }

    public String getClassName() {
        return this.type.getName();
    }

    public Object getContent() throws IllegalStateException, NameNotFoundException {
        AbstractName target;
        try {
            target = this.resolveTargetName();
        }
        catch (GBeanNotFoundException e) {
            throw (NameNotFoundException)new NameNotFoundException("Could not resolve gbean from name query: " + this.abstractNameQueries).initCause(e);
        }
        try {
            return this.getKernel().getGBean(target);
        }
        catch (GBeanNotFoundException e) {
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(e);
            throw illegalStateException;
        }
    }
}

