/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gjndi.binding;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;

public class GBeanBinding
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog(GBeanBinding.class);
    private final Context context;
    private final String name;
    private final AbstractNameQuery abstractNameQuery;
    private final Kernel kernel;
    private final LifecycleListener listener = new GBeanLifecycleListener();
    private final LinkedHashMap bindings = new LinkedHashMap();
    public static final GBeanInfo GBEAN_INFO;

    public GBeanBinding(Context context, String name, AbstractNameQuery abstractNameQuery, Kernel kernel) {
        this.context = context;
        this.name = name;
        this.abstractNameQuery = abstractNameQuery;
        this.kernel = kernel;
    }

    public synchronized void doStart() {
        this.kernel.getLifecycleMonitor().addLifecycleListener(this.listener, this.abstractNameQuery);
        Set set = this.kernel.listGBeans(this.abstractNameQuery);
        for (AbstractName abstractName : set) {
            try {
                if (!this.kernel.isRunning(abstractName)) continue;
                this.addBinding(abstractName);
            }
            catch (NamingException e) {
                log.error((Object)("Error adding binding for " + abstractName), (Throwable)e);
            }
        }
    }

    public void doStop() {
        this.destroy();
    }

    public void doFail() {
        this.destroy();
    }

    private synchronized void destroy() {
        this.kernel.getLifecycleMonitor().removeLifecycleListener(this.listener);
        HashSet abstractNames = new HashSet(this.bindings.keySet());
        for (AbstractName abstractName : abstractNames) {
            this.removeBinding(abstractName);
        }
        this.bindings.clear();
    }

    protected synchronized void addBinding(AbstractName abstractName) throws NamingException {
        if (this.bindings.containsKey(abstractName)) {
            return;
        }
        Object instance = null;
        try {
            instance = this.kernel.getGBean(abstractName);
        }
        catch (GBeanNotFoundException e) {
            throw (NamingException)new NamingException("GBean not found: " + abstractName).initCause(e);
        }
        instance = this.preprocessVaue(abstractName, instance);
        this.addBinding(abstractName, instance);
    }

    private synchronized void addBinding(AbstractName abstractName, Object value) throws NamingException {
        if (this.bindings.isEmpty()) {
            this.context.bind(this.name, value);
        }
        this.bindings.put(abstractName, value);
    }

    protected synchronized void removeBinding(AbstractName abstractName) {
        Map.Entry entry = GBeanBinding.first(this.bindings);
        if (entry != null && entry.getKey().equals(abstractName)) {
            Object oldValue = this.bindings.remove(abstractName);
            entry = GBeanBinding.first(this.bindings);
            if (entry != null) {
                Object newAbstractName = entry.getValue();
                Object newValue = entry.getValue();
                try {
                    this.context.rebind(this.name, newValue);
                }
                catch (NamingException e) {
                    boolean unbound = this.unbind(abstractName, oldValue);
                    if (unbound) {
                        log.error((Object)("Unable to rebind binding " + this.name + " to " + newAbstractName));
                    }
                }
            } else {
                this.unbind(abstractName, oldValue);
            }
        } else {
            this.bindings.remove(abstractName);
        }
    }

    private boolean unbind(AbstractName abstractName, Object value) {
        try {
            if (this.context.lookup(this.name) != value) {
                return true;
            }
        }
        catch (NamingException ignored) {
            return true;
        }
        try {
            this.context.unbind(this.name);
            return true;
        }
        catch (NamingException e1) {
            log.error((Object)("Unable to remove binding " + this.name + " to " + abstractName), (Throwable)e1);
            return false;
        }
    }

    private static Map.Entry first(LinkedHashMap map) {
        if (map.isEmpty()) {
            return null;
        }
        return map.entrySet().iterator().next();
    }

    protected Object preprocessVaue(AbstractName abstractName, Object value) throws NamingException {
        return value;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic(GBeanBinding.class, (String)"GBeanBinding");
        builder.addReference("Context", Context.class);
        builder.addAttribute("name", String.class, true);
        builder.addAttribute("abstractNameQuery", AbstractNameQuery.class, true);
        builder.setConstructor(new String[]{"Context", "name", "abstractNameQuery", "kernel"});
        GBEAN_INFO = builder.getBeanInfo();
    }

    private class GBeanLifecycleListener
    extends LifecycleAdapter {
        private GBeanLifecycleListener() {
        }

        public void running(AbstractName abstractName) {
            try {
                GBeanBinding.this.addBinding(abstractName);
            }
            catch (NamingException e) {
                log.error((Object)("Error adding binding for " + abstractName));
            }
        }

        public void stopping(AbstractName abstractName) {
            GBeanBinding.this.removeBinding(abstractName);
        }

        public void stopped(AbstractName abstractName) {
            GBeanBinding.this.removeBinding(abstractName);
        }

        public void failed(AbstractName abstractName) {
            GBeanBinding.this.removeBinding(abstractName);
        }

        public void unloaded(AbstractName abstractName) {
            GBeanBinding.this.removeBinding(abstractName);
        }
    }
}

