/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import javax.naming.NameNotFoundException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.naming.reference.ConfigurationAwareReference;

public class EntityManagerFactoryReference
extends ConfigurationAwareReference {
    public EntityManagerFactoryReference(Artifact configId, AbstractNameQuery abstractNameQuery) {
        super(configId, abstractNameQuery);
    }

    public String getClassName() {
        return "javax.persistence.EntityManagerFactory";
    }

    public Object getContent() throws NameNotFoundException {
        Object entityManagerFactory;
        AbstractName target;
        Kernel kernel = this.getKernel();
        try {
            target = this.resolveTargetName();
        }
        catch (GBeanNotFoundException e) {
            throw (NameNotFoundException)new NameNotFoundException("Could not resolve name query: " + this.abstractNameQueries).initCause(e);
        }
        try {
            entityManagerFactory = kernel.invoke(target, "getEntityManagerFactory");
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Could not get EntityManagerFactory").initCause(e);
        }
        if (entityManagerFactory == null) {
            throw new IllegalStateException("entity manager not returned. Target " + target + " not started");
        }
        return entityManagerFactory;
    }
}

