/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.myfaces.webapp;

import java.util.ArrayList;
import java.util.List;
import javax.faces.webapp.FacesServlet;
import org.apache.geronimo.web.info.FilterInfo;
import org.apache.geronimo.web.info.FilterMappingInfo;
import org.apache.geronimo.web.info.ServletInfo;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.myfaces.shared_impl.webapp.webxml.DelegatedFacesServlet;
import org.apache.myfaces.shared_impl.webapp.webxml.FilterMapping;
import org.apache.myfaces.shared_impl.webapp.webxml.ServletMapping;
import org.apache.myfaces.shared_impl.webapp.webxml.WebXml;
import org.osgi.framework.Bundle;

public class GeronimoWebXml
extends WebXml {
    private List<ServletMapping> facesServletMappings;
    private List<FilterMapping> facesExtensionsFilterMapppings;
    private boolean errorPagePresent;
    private String delegateFacesServlet;

    public GeronimoWebXml(Bundle bundle, WebAppInfo webAppInfo, String delegateFacesServlet) {
        this.errorPagePresent = webAppInfo.errorPages != null && webAppInfo.errorPages.size() > 0;
        this.delegateFacesServlet = delegateFacesServlet;
        this.facesServletMappings = new ArrayList<ServletMapping>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (ServletInfo servletInfo : webAppInfo.servlets) {
            Class<?> servletClass;
            if (servletInfo.servletClass == null) continue;
            try {
                servletClass = contextClassLoader.loadClass(servletInfo.servletClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not load the servlet class " + servletInfo.servletClass, e);
            }
            if (!this.isFacesServlet(servletClass)) continue;
            for (String urlPattern : servletInfo.servletMappings) {
                this.facesServletMappings.add(new ServletMapping(servletInfo.servletName, servletClass, urlPattern));
            }
        }
        this.facesExtensionsFilterMapppings = new ArrayList<FilterMapping>();
        for (FilterInfo filterInfo : webAppInfo.filters) {
            Class<?> filterClass;
            try {
                filterClass = contextClassLoader.loadClass(filterInfo.filterClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not load the filter class " + filterInfo.filterClass, e);
            }
            if (!this.isFacesExtensionsFilter(filterClass)) continue;
            for (FilterMappingInfo filterMappingInfo : filterInfo.urlMappings) {
                for (String urlPattern : filterMappingInfo.mapping) {
                    this.facesExtensionsFilterMapppings.add(new FilterMapping(filterInfo.filterName, filterClass, urlPattern));
                }
            }
        }
    }

    public List<ServletMapping> getFacesServletMappings() {
        return this.facesServletMappings;
    }

    public List<FilterMapping> getFacesExtensionsFilterMappings() {
        return this.facesExtensionsFilterMapppings;
    }

    public boolean isErrorPagePresent() {
        return this.errorPagePresent;
    }

    protected boolean isFacesServlet(Class<?> servletClass) {
        return FacesServlet.class.isAssignableFrom(servletClass) || DelegatedFacesServlet.class.isAssignableFrom(servletClass) || servletClass.getName().equals(this.delegateFacesServlet);
    }

    protected boolean isFacesExtensionsFilter(Class<?> filterClass) {
        return "org.apache.myfaces.component.html.util.ExtensionsFilter".equals(filterClass.getName()) || "org.apache.myfaces.webapp.filter.ExtensionsFilter".equals(filterClass.getName());
    }
}

