/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.myfaces.deployment;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import javax.faces.webapp.FacesServlet;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.myfaces.LifecycleProviderGBean;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.javaee.FacesConfigDocument;
import org.apache.geronimo.xbeans.javaee.FacesConfigManagedBeanType;
import org.apache.geronimo.xbeans.javaee.FacesConfigType;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee6.ParamValueType;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.myfaces.webapp.StartupServletContextListener;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyFacesModuleBuilderExtension
implements ModuleBuilderExtension {
    private static final Logger log = LoggerFactory.getLogger(MyFacesModuleBuilderExtension.class);
    private final Environment defaultEnvironment;
    private final AbstractNameQuery providerFactoryNameQuery;
    private final NamingBuilder namingBuilders;
    private static final String CONTEXT_LISTENER_NAME = StartupServletContextListener.class.getName();
    private static final String FACES_SERVLET_NAME = FacesServlet.class.getName();
    private static final String SCHEMA_LOCATION_URL = "http://java.sun.com/xml/ns/javaee/web-facesconfig_2_0.xsd";
    private static final String VERSION = "2.0";
    public static final GBeanInfo GBEAN_INFO;

    public MyFacesModuleBuilderExtension(Environment defaultEnvironment, AbstractNameQuery providerFactoryNameQuery, NamingBuilder namingBuilders) {
        this.defaultEnvironment = defaultEnvironment;
        this.providerFactoryNameQuery = providerFactoryNameQuery;
        this.namingBuilders = namingBuilders;
    }

    public void createModule(Module module, Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        this.mergeEnvironment(module);
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        this.mergeEnvironment(module);
    }

    private void mergeEnvironment(Module module) {
        if (!(module instanceof WebModule)) {
            return;
        }
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        if (!this.hasFacesServlet(webApp)) {
            return;
        }
        EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.defaultEnvironment);
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    public void initContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
    }

    public void addGBeans(EARContext earContext, Module module, Bundle bundle, Collection repository) throws DeploymentException {
        if (!(module instanceof WebModule)) {
            return;
        }
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        if (!this.hasFacesServlet(webApp)) {
            return;
        }
        EARContext moduleContext = module.getEarContext();
        Map sharedContext = module.getSharedContext();
        GBeanData webAppData = (GBeanData)sharedContext.get("WEB_APP_DATA");
        Object value = webAppData.getAttribute("listenerClassNames");
        if (value instanceof Collection && !((Collection)value).contains(CONTEXT_LISTENER_NAME)) {
            ((Collection)value).add(CONTEXT_LISTENER_NAME);
        }
        AbstractName moduleName = moduleContext.getModuleName();
        HashMap<EARContext.Key, Object> buildingContext = new HashMap<EARContext.Key, Object>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, moduleName);
        Map compContext = (Map)NamingBuilder.JNDI_KEY.get(module.getSharedContext());
        buildingContext.put(NamingBuilder.JNDI_KEY, compContext);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext);
        buildingContext.put(NamingBuilder.INJECTION_KEY, holder);
        XmlObject jettyWebApp = (XmlObject)webModule.getVendorDD();
        ClassFinder classFinder = this.createMyFacesClassFinder(webApp, webModule);
        webModule.setClassFinder(classFinder);
        this.namingBuilders.buildNaming((XmlObject)webApp, jettyWebApp, (Module)webModule, buildingContext);
        AbstractName providerName = moduleContext.getNaming().createChildName(moduleName, "jsf-lifecycle", "jsf");
        GBeanData providerData = new GBeanData(providerName, LifecycleProviderGBean.class);
        providerData.setAttribute("holder", (Object)holder);
        providerData.setReferencePatterns("ContextSource", webAppData.getReferencePatterns("ContextSource"));
        providerData.setReferencePattern("LifecycleProviderFactory", this.providerFactoryNameQuery);
        try {
            moduleContext.addGBean(providerData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Duplicate jsf config gbean in web module", (Throwable)e);
        }
        webAppData.addDependency(providerName);
    }

    private boolean hasFacesServlet(WebAppType webApp) {
        for (ServletType servlet : webApp.getServletArray()) {
            if (!servlet.isSetServletClass() || !FACES_SERVLET_NAME.equals(servlet.getServletClass().getStringValue().trim())) continue;
            return true;
        }
        return false;
    }

    protected ClassFinder createMyFacesClassFinder(WebAppType webApp, WebModule webModule) throws DeploymentException {
        List<Class> classes = this.getFacesClasses(webApp, webModule);
        return new ClassFinder(classes);
    }

    private List<Class> getFacesClasses(WebAppType webApp, WebModule webModule) throws DeploymentException {
        ParamValueType[] paramValues;
        log.debug("getFacesClasses( " + webApp.toString() + "," + '\n' + (webModule != null ? webModule.getName() : null) + " ): Entry");
        Deployable deployable = webModule.getDeployable();
        Bundle bundle = webModule.getEarContext().getDeploymentBundle();
        ArrayList<Class> classes = new ArrayList<Class>();
        URL url = deployable.getResource("META-INF/faces-config.xml");
        if (url != null) {
            this.parseConfigFile(url, bundle, classes);
        }
        if ((url = deployable.getResource("WEB-INF/faces-config.xml")) != null) {
            this.parseConfigFile(url, bundle, classes);
        }
        for (ParamValueType paramValue : paramValues = webApp.getContextParamArray()) {
            if (!paramValue.getParamName().getStringValue().trim().equals("javax.faces.CONFIG_FILES")) continue;
            String configFiles = paramValue.getParamValue().getStringValue().trim();
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String configfile = st.nextToken().trim();
                if (configfile.equals("")) continue;
                if (configfile.startsWith("/")) {
                    configfile = configfile.substring(1);
                }
                if ((url = deployable.getResource(configfile)) == null) {
                    throw new DeploymentException("Could not locate config file " + configfile);
                }
                this.parseConfigFile(url, bundle, classes);
            }
            break;
        }
        log.debug("getFacesClasses() Exit: " + classes.size() + " " + ((Object)classes).toString());
        return classes;
    }

    private void parseConfigFile(URL url, Bundle bundle, List<Class> classes) throws DeploymentException {
        log.debug("parseConfigFile( " + url.toString() + " ): Entry");
        try {
            FacesConfigManagedBeanType[] managedBeans;
            XmlObject xml = XmlBeansUtil.parse((URL)url, null);
            FacesConfigDocument fcd = MyFacesModuleBuilderExtension.convertToFacesConfigSchema(xml);
            FacesConfigType facesConfig = fcd.getFacesConfig();
            for (FacesConfigManagedBeanType managedBean : managedBeans = facesConfig.getManagedBeanArray()) {
                FullyQualifiedClassType cls = managedBean.getManagedBeanClass();
                String className = cls.getStringValue().trim();
                try {
                    Class clas = bundle.loadClass(className);
                    classes.add(clas);
                }
                catch (ClassNotFoundException e) {
                    log.warn("MyFacesModuleBuilderExtension: Could not load managed bean class: " + className + " mentioned in faces-config.xml file at " + url.toString());
                }
            }
        }
        catch (XmlException xmle) {
            throw new DeploymentException("Could not parse alleged faces-config.xml at " + url.toString(), (Throwable)xmle);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error reading jsf configuration file " + url, (Throwable)ioe);
        }
        log.debug("parseConfigFile(): Exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FacesConfigDocument convertToFacesConfigSchema(XmlObject xmlObject) throws XmlException {
        log.debug("convertToFacesConfigSchema( " + xmlObject.toString() + " ): Entry");
        XmlCursor cursor = xmlObject.newCursor();
        try {
            cursor.toStartDoc();
            cursor.toFirstChild();
            String nameSpaceURI = cursor.getName().getNamespaceURI();
            if ("http://java.sun.com/xml/ns/javaee".equals(nameSpaceURI) || "http://java.sun.com/xml/ns/j2ee".equals(nameSpaceURI)) {
                SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)SCHEMA_LOCATION_URL, (String)VERSION);
            } else {
                SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)SCHEMA_LOCATION_URL, (String)VERSION);
            }
        }
        finally {
            cursor.dispose();
        }
        XmlObject result = xmlObject.changeType(FacesConfigDocument.type);
        if (result != null) {
            XmlBeansUtil.validateDD((XmlObject)result);
            log.debug("convertToFacesConfigSchema(): Exit 2");
            return (FacesConfigDocument)result;
        }
        XmlBeansUtil.validateDD((XmlObject)xmlObject);
        log.debug("convertToFacesConfigSchema(): Exit 3");
        return (FacesConfigDocument)xmlObject;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(MyFacesModuleBuilderExtension.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("providerFactoryNameQuery", AbstractNameQuery.class, true, true);
        infoBuilder.addReference("NamingBuilders", NamingBuilder.class, "ModuleBuilder");
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "providerFactoryNameQuery", "NamingBuilders"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

