/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.BasicKernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationMarshaler;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationResolver;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.GBeanState;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.SerializedConfigurationMarshaler;
import org.apache.geronimo.kernel.repository.Artifact;

public final class ConfigurationUtil {
    private static final Log log = LogFactory.getLog((Class)ConfigurationUtil.class);
    private static final ConfigurationMarshaler configurationMarshaler;
    static /* synthetic */ Class class$java$util$Collection;

    public static ConfigurationMarshaler createConfigurationMarshaler(String marshalerClass) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class clazz = null;
        if (classLoader != null) {
            try {
                clazz = ClassLoading.loadClass(marshalerClass, classLoader);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (clazz == null) {
            classLoader = ConfigurationUtil.class.getClassLoader();
            try {
                clazz = ClassLoading.loadClass(marshalerClass, classLoader);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (clazz != null) {
            Object object = clazz.newInstance();
            if (object instanceof ConfigurationMarshaler) {
                return (ConfigurationMarshaler)object;
            }
            log.warn((Object)("Configuration marshaler class is not an instance of ConfigurationMarshaler " + marshalerClass + ": using default configuration "));
        }
        return null;
    }

    private ConfigurationUtil() {
    }

    public static GBeanState newGBeanState(Collection gbeans) {
        return configurationMarshaler.newGBeanState(gbeans);
    }

    public static AbstractName loadBootstrapConfiguration(Kernel kernel, InputStream in, ClassLoader classLoader) throws Exception {
        ConfigurationData configurationData = ConfigurationUtil.readConfigurationData(in);
        return ConfigurationUtil.loadBootstrapConfiguration(kernel, configurationData, classLoader);
    }

    public static AbstractName loadBootstrapConfiguration(Kernel kernel, ConfigurationData configurationData, ClassLoader classLoader) throws Exception {
        if (kernel == null) {
            throw new NullPointerException("kernel is null");
        }
        if (configurationData == null) {
            throw new NullPointerException("configurationData is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        List dependencies = configurationData.getEnvironment().getDependencies();
        if (!dependencies.isEmpty()) {
            configurationData.getEnvironment().setDependencies(Collections.EMPTY_SET);
        }
        Artifact configId = configurationData.getId();
        AbstractName abstractName = Configuration.getConfigurationAbstractName(configId);
        GBeanData gbeanData = new GBeanData(abstractName, Configuration.GBEAN_INFO);
        gbeanData.setAttribute("configurationData", configurationData);
        gbeanData.setAttribute("configurationResolver", new ConfigurationResolver(configurationData, null, null));
        kernel.loadGBean(gbeanData, classLoader);
        kernel.startGBean(gbeanData.getAbstractName());
        Configuration configuration = (Configuration)kernel.getGBean(gbeanData.getAbstractName());
        ConfigurationUtil.startConfigurationGBeans(configuration.getAbstractName(), configuration, kernel);
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager(kernel);
        configurationManager.loadConfiguration(configId);
        return gbeanData.getAbstractName();
    }

    public static void writeConfigurationData(ConfigurationData configurationData, OutputStream out) throws IOException {
        configurationMarshaler.writeConfigurationData(configurationData, out);
    }

    public static ConfigurationData readConfigurationData(InputStream in) throws IOException, ClassNotFoundException {
        return configurationMarshaler.readConfigurationData(in);
    }

    public static void writeConfigInfo(PrintWriter writer, ConfigurationData configurationData) {
        ConfigurationUtil.writeConfigInfo("", writer, configurationData);
    }

    private static void writeConfigInfo(String prefix, PrintWriter writer, ConfigurationData configurationData) {
        writer.println(prefix + "id=" + configurationData.getId());
        writer.println(prefix + "type=" + configurationData.getModuleType());
        writer.println(prefix + "created=" + configurationData.getCreated());
        Set ownedConfigurations = configurationData.getOwnedConfigurations();
        int i = 0;
        Iterator iterator = ownedConfigurations.iterator();
        while (iterator.hasNext()) {
            Artifact ownedConfiguration = (Artifact)iterator.next();
            writer.println(prefix + "owned." + i++ + "=" + ownedConfiguration);
        }
        i = 0;
        Iterator it = configurationData.getChildConfigurations().values().iterator();
        while (it.hasNext()) {
            ConfigurationData data = (ConfigurationData)it.next();
            ConfigurationUtil.writeConfigInfo("child." + i + ".", writer, data);
            ++i;
        }
        writer.flush();
    }

    public static ConfigurationInfo readConfigurationInfo(InputStream in, AbstractName storeName, File inPlaceLocation) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        return ConfigurationUtil.readConfigurationInfo("", properties, storeName, inPlaceLocation);
    }

    private static ConfigurationInfo readConfigurationInfo(String prefix, Properties properties, AbstractName storeName, File inPlaceLocation) throws IOException {
        String next;
        String value;
        long time;
        String id = properties.getProperty(prefix + "id");
        Artifact configId = Artifact.create(id);
        String type = properties.getProperty(prefix + "type");
        ConfigurationModuleType moduleType = ConfigurationModuleType.getByName(type);
        if (moduleType == null) {
            throw new IllegalArgumentException("Unknown module type: " + type);
        }
        String created = properties.getProperty(prefix + "created");
        try {
            time = Long.parseLong(created);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid created time: " + created);
        }
        LinkedHashSet<Artifact> ownedConfigurations = new LinkedHashSet<Artifact>();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String name = (String)entry.getKey();
            if (!name.startsWith(prefix + "owned.")) continue;
            value = (String)entry.getValue();
            Artifact ownedConfiguration = Artifact.create(value);
            ownedConfigurations.add(ownedConfiguration);
        }
        LinkedHashSet<ConfigurationInfo> childConfigurations = new LinkedHashSet<ConfigurationInfo>();
        int test = 0;
        while ((value = properties.getProperty((next = prefix + "child." + test + ".") + ".id")) != null) {
            childConfigurations.add(ConfigurationUtil.readConfigurationInfo(next, properties, storeName, inPlaceLocation));
            ++test;
        }
        return new ConfigurationInfo(storeName, configId, moduleType, time, ownedConfigurations, childConfigurations, inPlaceLocation);
    }

    public static ConfigurationManager getConfigurationManager(Kernel kernel) {
        Set names = kernel.listGBeans(new AbstractNameQuery(ConfigurationManager.class.getName()));
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            AbstractName abstractName = (AbstractName)iterator.next();
            if (kernel.isRunning(abstractName)) continue;
            iterator.remove();
        }
        if (names.isEmpty()) {
            throw new IllegalStateException("A Configuration Manager could not be found in the kernel");
        }
        if (names.size() > 1) {
            throw new IllegalStateException("More than one Configuration Manager was found in the kernel");
        }
        AbstractName configurationManagerName = (AbstractName)names.iterator().next();
        return (ConfigurationManager)kernel.getProxyManager().createProxy(configurationManagerName, ConfigurationManager.class);
    }

    public static EditableConfigurationManager getEditableConfigurationManager(Kernel kernel) {
        Set names = kernel.listGBeans(new AbstractNameQuery(EditableConfigurationManager.class.getName()));
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            AbstractName abstractName = (AbstractName)iterator.next();
            if (kernel.isRunning(abstractName)) continue;
            iterator.remove();
        }
        if (names.isEmpty()) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalStateException("More than one Configuration Manager was found in the kernel");
        }
        AbstractName configurationManagerName = (AbstractName)names.iterator().next();
        return (EditableConfigurationManager)kernel.getProxyManager().createProxy(configurationManagerName, EditableConfigurationManager.class);
    }

    public static void releaseConfigurationManager(Kernel kernel, ConfigurationManager configurationManager) {
        kernel.getProxyManager().destroyProxy(configurationManager);
    }

    static void preprocessGBeanData(AbstractName configurationName, Configuration configuration, GBeanData gbeanData) throws InvalidConfigException {
        Iterator references = gbeanData.getReferencesNames().iterator();
        while (references.hasNext()) {
            AbstractName abstractName;
            String referenceName = (String)references.next();
            GReferenceInfo referenceInfo = gbeanData.getGBeanInfo().getReference(referenceName);
            if (referenceInfo == null) {
                throw new InvalidConfigException("No reference named " + referenceName + " in gbean " + gbeanData.getAbstractName());
            }
            boolean isSingleValued = !referenceInfo.getProxyType().equals((class$java$util$Collection == null ? ConfigurationUtil.class$("java.util.Collection") : class$java$util$Collection).getName());
            if (!isSingleValued) continue;
            ReferencePatterns referencePatterns = gbeanData.getReferencePatterns(referenceName);
            try {
                abstractName = configuration.findGBean(referencePatterns);
            }
            catch (GBeanNotFoundException e) {
                throw new InvalidConfigException("Unable to resolve reference \"" + referenceName + "\" in gbean " + gbeanData.getAbstractName() + " to a gbean matching the pattern " + referencePatterns, e);
            }
            gbeanData.setReferencePatterns(referenceName, new ReferencePatterns(abstractName));
        }
        HashSet<ReferencePatterns> newDependencies = new HashSet<ReferencePatterns>();
        Iterator dependencyIterator = gbeanData.getDependencies().iterator();
        while (dependencyIterator.hasNext()) {
            AbstractName abstractName;
            ReferencePatterns referencePatterns = (ReferencePatterns)dependencyIterator.next();
            try {
                abstractName = configuration.findGBean(referencePatterns);
            }
            catch (GBeanNotFoundException e) {
                throw new InvalidConfigException("Unable to resolve dependency in gbean " + gbeanData.getAbstractName(), e);
            }
            newDependencies.add(new ReferencePatterns(abstractName));
        }
        gbeanData.setDependencies(newDependencies);
        GAttributeInfo attribute = gbeanData.getGBeanInfo().getAttribute("configurationBaseUrl");
        if (attribute != null && attribute.getType().equals("java.net.URL")) {
            try {
                Set set = configuration.getConfigurationResolver().resolve("");
                if (set.size() != 1) {
                    throw new AssertionError((Object)("Expected one match for pattern \".\", but got " + set.size() + " matches"));
                }
                URL baseURL = (URL)set.iterator().next();
                gbeanData.setAttribute("configurationBaseUrl", baseURL);
            }
            catch (Exception e) {
                throw new InvalidConfigException("Unable to set attribute named configurationBaseUrl in gbean " + gbeanData.getAbstractName(), e);
            }
        }
        gbeanData.addDependency(configurationName);
    }

    static void startConfigurationGBeans(AbstractName configurationName, Configuration configuration, Kernel kernel) throws InvalidConfigException {
        ArrayList gbeans = new ArrayList(configuration.getGBeans().values());
        Collections.sort(gbeans, new GBeanData.PriorityComparator());
        ArrayList<AbstractName> loaded = new ArrayList<AbstractName>(gbeans.size());
        ArrayList<AbstractName> started = new ArrayList<AbstractName>(gbeans.size());
        try {
            GBeanData gbeanData;
            Iterator iterator = gbeans.iterator();
            while (iterator.hasNext()) {
                gbeanData = (GBeanData)iterator.next();
                gbeanData = new GBeanData(gbeanData);
                ConfigurationUtil.preprocessGBeanData(configurationName, configuration, gbeanData);
                try {
                    kernel.loadGBean(gbeanData, configuration.getConfigurationClassLoader());
                    loaded.add(gbeanData.getAbstractName());
                }
                catch (GBeanAlreadyExistsException e) {
                    throw new InvalidConfigException(e);
                }
                catch (Throwable e) {
                    log.warn((Object)("Could not load gbean " + gbeanData.getAbstractName()), e);
                    throw e;
                }
            }
            try {
                iterator = gbeans.iterator();
                while (iterator.hasNext()) {
                    gbeanData = (GBeanData)iterator.next();
                    AbstractName gbeanName = gbeanData.getAbstractName();
                    kernel.startRecursiveGBean(gbeanName);
                    started.add(gbeanName);
                }
                ArrayList<String> unstarted = new ArrayList<String>();
                Iterator iterator2 = gbeans.iterator();
                while (iterator2.hasNext()) {
                    GBeanData gbeanData2 = (GBeanData)iterator2.next();
                    AbstractName gbeanName = gbeanData2.getAbstractName();
                    if (1 == kernel.getGBeanState(gbeanName)) continue;
                    String stateReason = null;
                    if (kernel instanceof BasicKernel) {
                        stateReason = ((BasicKernel)kernel).getStateReason(gbeanName);
                    }
                    String name = gbeanName.toURI().getQuery();
                    if (stateReason != null) {
                        unstarted.add("The service " + name + " did not start because " + stateReason);
                        continue;
                    }
                    unstarted.add("The service " + name + " did not start for an unknown reason");
                }
                if (!unstarted.isEmpty()) {
                    StringBuffer message = new StringBuffer();
                    message.append("Configuration ").append(configuration.getId()).append(" failed to start due to the following reasons:\n");
                    Iterator iterator3 = unstarted.iterator();
                    while (iterator3.hasNext()) {
                        String reason = (String)iterator3.next();
                        message.append("  ").append(reason).append("\n");
                    }
                    throw new InvalidConfigurationException(message.toString());
                }
            }
            catch (GBeanNotFoundException e) {
                throw new InvalidConfigException(e);
            }
            iterator = configuration.getChildren().iterator();
            while (iterator.hasNext()) {
                Configuration childConfiguration = (Configuration)iterator.next();
                ConfigurationUtil.startConfigurationGBeans(configurationName, childConfiguration, kernel);
            }
        }
        catch (Throwable e) {
            AbstractName gbeanName;
            Iterator iterator = started.iterator();
            while (iterator.hasNext()) {
                gbeanName = (AbstractName)iterator.next();
                try {
                    kernel.stopGBean(gbeanName);
                }
                catch (GBeanNotFoundException ignored) {
                }
                catch (IllegalStateException ignored) {
                }
                catch (InternalKernelException kernelException) {
                    log.debug((Object)("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName), (Throwable)kernelException);
                }
            }
            iterator = loaded.iterator();
            while (iterator.hasNext()) {
                gbeanName = (AbstractName)iterator.next();
                try {
                    kernel.unloadGBean(gbeanName);
                }
                catch (GBeanNotFoundException ignored) {
                }
                catch (IllegalStateException ignored) {
                }
                catch (InternalKernelException kernelException) {
                    log.debug((Object)("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName), (Throwable)kernelException);
                }
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof InvalidConfigException) {
                throw (InvalidConfigException)e;
            }
            throw new InvalidConfigException("Unknown start exception", e);
        }
    }

    static {
        ConfigurationMarshaler marshaler = null;
        String marshalerClass = System.getProperty("Xorg.apache.geronimo.kernel.config.Marshaler");
        if (marshalerClass != null) {
            try {
                marshaler = ConfigurationUtil.createConfigurationMarshaler(marshalerClass);
            }
            catch (Exception e) {
                log.error((Object)("Error creating configuration marshaler class " + marshalerClass), (Throwable)e);
            }
        }
        if (marshaler == null) {
            marshaler = new SerializedConfigurationMarshaler();
        }
        configurationMarshaler = marshaler;
    }
}

