/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6.handler;

import org.apache.geronimo.jetty6.handler.LifecycleCommand;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;

public abstract class AbstractImmutableHandler
implements Handler {
    protected final Handler next;

    protected AbstractImmutableHandler(Handler next) {
        this.next = next;
    }

    protected void doStart() throws Exception {
        this.next.start();
    }

    protected void doStop() throws Exception {
        this.next.stop();
    }

    public void setServer(Server server) {
        this.next.setServer(server);
    }

    public Server getServer() {
        return this.next.getServer();
    }

    public void destroy() {
        this.next.destroy();
    }

    public void lifecycleCommand(LifecycleCommand lifecycleCommand) throws Exception {
        if (this.next instanceof AbstractImmutableHandler) {
            ((AbstractImmutableHandler)this.next).lifecycleCommand(lifecycleCommand);
        } else {
            lifecycleCommand.lifecycleMethod();
        }
    }

    public void addHandler(Handler handler) {
        if (!(this.next instanceof HandlerContainer)) {
            throw new RuntimeException("geronimo HandlerContainers are immutable");
        }
        ((HandlerContainer)this.next).addHandler(handler);
    }

    protected Object expandChildren(Object list, Class byClass) {
        return null;
    }

    public void start() throws Exception {
        this.next.start();
    }

    public void stop() throws Exception {
        this.next.stop();
    }

    public boolean isRunning() {
        return this.next.isRunning();
    }

    public boolean isStarted() {
        return this.next.isStarted();
    }

    public boolean isStarting() {
        return this.next.isStarting();
    }

    public boolean isStopping() {
        return this.next.isStopping();
    }

    public boolean isStopped() {
        return this.next.isStopped();
    }

    public boolean isFailed() {
        return false;
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
    }
}

