/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.jetty6.InternalJAASJettyRealm;
import org.apache.geronimo.jetty6.JAASJettyRealm;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jacc.PolicyContextHandlerHttpServletRequest;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.BasicAuthenticator;
import org.mortbay.jetty.security.ClientCertAuthenticator;
import org.mortbay.jetty.security.DigestAuthenticator;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.URIUtil;

public class JettyEJBWebServiceContext
extends ContextHandler {
    private final String contextPath;
    private final WebServiceContainer webServiceContainer;
    private final Authenticator authenticator;
    private final JAASJettyRealm realm;
    private final ClassLoader classLoader;
    private final AccessControlContext defaultAcc;
    private final String policyContextID;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JettyEJBWebServiceContext(String contextPath, WebServiceContainer webServiceContainer, InternalJAASJettyRealm internalJAASJettyRealm, String realmName, String authMethod, ClassLoader classLoader, Subject defaultSubject, String policyContextID) {
        this.contextPath = contextPath;
        this.webServiceContainer = webServiceContainer;
        this.setContextPath(contextPath);
        if (internalJAASJettyRealm != null) {
            this.realm = new JAASJettyRealm(realmName, internalJAASJettyRealm);
            if ("BASIC".equals(authMethod)) {
                this.authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equals(authMethod)) {
                this.authenticator = new DigestAuthenticator();
            } else if ("CLIENT-CERT".equals(authMethod)) {
                this.authenticator = new ClientCertAuthenticator();
            } else {
                if (!"NONE".equals(authMethod)) throw new IllegalArgumentException("Invalid authMethod: " + authMethod);
                this.authenticator = null;
            }
        } else {
            this.realm = null;
            this.authenticator = null;
        }
        this.classLoader = classLoader;
        if (defaultSubject == null) {
            defaultSubject = ContextManager.EMPTY;
        }
        this.defaultAcc = ContextManager.registerSubjectShort((Subject)defaultSubject, null, null);
        this.policyContextID = policyContextID;
    }

    public String getName() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest req, HttpServletResponse res, int dispatch) throws IOException, ServletException {
        if (!target.startsWith(this.contextPath)) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.classLoader);
        String oldPolicyContextID = PolicyContext.getContextID();
        PolicyContext.setContextID((String)this.policyContextID);
        HttpServletRequest oldRequest = PolicyContextHandlerHttpServletRequest.pushContextData((HttpServletRequest)req);
        try {
            this.handle(req, res);
        }
        finally {
            PolicyContextHandlerHttpServletRequest.popContextData((HttpServletRequest)oldRequest);
            PolicyContext.setContextID((String)oldPolicyContextID);
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }

    private void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Request jettyRequest = (Request)req;
        Response jettyResponse = (Response)res;
        res.setContentType("text/xml");
        RequestAdapter request = new RequestAdapter(jettyRequest);
        ResponseAdapter response = new ResponseAdapter(jettyResponse);
        request.setAttribute(WebServiceContainer.SERVLET_REQUEST, req);
        request.setAttribute(WebServiceContainer.SERVLET_RESPONSE, res);
        request.setAttribute(WebServiceContainer.SERVLET_CONTEXT, null);
        WebUserDataPermission udp = new WebUserDataPermission(req);
        if (this.realm != null) {
            try {
                this.defaultAcc.checkPermission((Permission)udp);
            }
            catch (AccessControlException e) {
                throw new HttpException(403);
            }
            if (this.authenticator != null) {
                String pathInContext = URIUtil.canonicalPath((String)req.getContextPath());
                if (this.authenticator.authenticate((UserRealm)this.realm, pathInContext, jettyRequest, jettyResponse) == null) {
                    throw new HttpException(403, null);
                }
            } else {
                ContextManager.popCallers(null);
            }
        }
        if (this.isWSDLRequest(req)) {
            try {
                this.webServiceContainer.getWsdl((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
                jettyRequest.setHandled(true);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (HttpException)new HttpException(500, "Could not fetch wsdl!").initCause((Throwable)e);
            }
        }
        try {
            this.webServiceContainer.invoke((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
            jettyRequest.setHandled(true);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (HttpException)new HttpException(500, "Could not process message!").initCause((Throwable)e);
        }
    }

    private boolean isWSDLRequest(HttpServletRequest req) {
        return "GET".equals(req.getMethod()) && (req.getParameter("wsdl") != null || req.getParameter("xsd") != null);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public static class ResponseAdapter
    implements WebServiceContainer.Response {
        private final Response response;

        public ResponseAdapter(Response response) {
            this.response = response;
        }

        public void setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        public String getHeader(String name) {
            return this.response.getHeader(name);
        }

        public OutputStream getOutputStream() {
            try {
                return this.response.getOutputStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        public void setStatusCode(int code) {
            this.response.setStatus(code);
        }

        public int getStatusCode() {
            return this.response.getStatus();
        }

        public void setContentType(String type) {
            this.response.setContentType(type);
        }

        public String getContentType() {
            return this.response.getContentType();
        }

        public void setStatusMessage(String responseString) {
            this.response.setStatus(this.response.getStatus(), responseString);
        }

        public void flushBuffer() throws IOException {
            this.response.flushBuffer();
        }
    }

    public static class RequestAdapter
    implements WebServiceContainer.Request {
        private final Request request;
        private URI uri;
        private static final Map<String, Integer> methods = new HashMap<String, Integer>();

        public RequestAdapter(Request request) {
            this.request = request;
        }

        public String getHeader(String name) {
            return this.request.getHeader(name);
        }

        public URI getURI() {
            if (this.uri == null) {
                try {
                    this.uri = new URI(this.request.getScheme(), null, this.request.getServerName(), this.request.getServerPort(), this.request.getRequestURI(), this.request.getQueryString(), null);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            return this.uri;
        }

        public int getContentLength() {
            return this.request.getContentLength();
        }

        public String getContentType() {
            return this.request.getContentType();
        }

        public InputStream getInputStream() throws IOException {
            return this.request.getInputStream();
        }

        public int getMethod() {
            Integer method = methods.get(this.request.getMethod());
            return method == null ? 8 : method;
        }

        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        public Map getParameters() {
            return this.request.getParameterMap();
        }

        public Object getAttribute(String name) {
            return this.request.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.request.setAttribute(name, value);
        }

        public String getRemoteAddr() {
            return this.request.getRemoteAddr();
        }

        public String getContextPath() {
            return this.request.getRequestURI();
        }

        static {
            methods.put("OPTIONS", 0);
            methods.put("GET", 1);
            methods.put("HEAD", 2);
            methods.put("POST", 3);
            methods.put("PUT", 4);
            methods.put("DELETE", 5);
            methods.put("TRACE", 6);
            methods.put("CONNECT", 7);
        }
    }
}

