/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.jetty6.handler.AbstractImmutableHandler;
import org.apache.geronimo.jetty6.handler.LifecycleCommand;
import org.mortbay.jetty.handler.AbstractHandler;

public class UserTransactionHandler
extends AbstractImmutableHandler {
    private final UserTransaction userTransaction;

    public UserTransactionHandler(AbstractHandler next, UserTransaction userTransaction) {
        super(next);
        this.userTransaction = userTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        boolean active = this.isActive();
        try {
            this.next.handle(target, request, response, dispatch);
        }
        finally {
            if (!active && this.isMarkedRollback() || dispatch == 1 && this.isActive()) {
                try {
                    this.userTransaction.rollback();
                }
                catch (SystemException e) {
                    throw new ServletException("Error rolling back transaction left open by user program", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifecycleCommand(LifecycleCommand lifecycleCommand) throws Exception {
        boolean active = this.isActive();
        try {
            super.lifecycleCommand(lifecycleCommand);
        }
        finally {
            if (!active && this.isActive()) {
                try {
                    this.userTransaction.rollback();
                }
                catch (SystemException e) {
                    throw new ServletException("Error rolling back transaction left open by user program", (Throwable)e);
                }
            }
        }
    }

    private boolean isActive() throws ServletException {
        try {
            return this.userTransaction.getStatus() != 6 && this.userTransaction.getStatus() != 3;
        }
        catch (SystemException e) {
            throw new ServletException("Could not determine transaction status", (Throwable)e);
        }
    }

    private boolean isMarkedRollback() throws ServletException {
        try {
            return this.userTransaction.getStatus() == 1;
        }
        catch (SystemException e) {
            throw new ServletException("Could not determine transaction status", (Throwable)e);
        }
    }
}

