/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.jetty6.JettyContainer;
import org.apache.geronimo.jetty6.JettyWebConnector;
import org.apache.geronimo.jetty6.connector.AJP13Connector;
import org.apache.geronimo.jetty6.connector.HTTPBlockingConnector;
import org.apache.geronimo.jetty6.connector.HTTPSSelectChannelConnector;
import org.apache.geronimo.jetty6.connector.HTTPSSocketConnector;
import org.apache.geronimo.jetty6.connector.HTTPSelectChannelConnector;
import org.apache.geronimo.jetty6.connector.HTTPSocketConnector;
import org.apache.geronimo.jetty6.requestlog.JettyLogManager;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.management.geronimo.KeystoreManager;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebAccessLog;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyManagerImpl
implements WebManager {
    private static final Log log = LogFactory.getLog(JettyManagerImpl.class);
    private static final WebManager.ConnectorType HTTP_NIO = new WebManager.ConnectorType("Jetty NIO HTTP Connector");
    private static final WebManager.ConnectorType HTTPS_NIO = new WebManager.ConnectorType("Jetty NIO HTTPS Connector");
    private static final WebManager.ConnectorType HTTP_BLOCKING_NIO = new WebManager.ConnectorType("Jetty Blocking HTTP Connector using NIO");
    private static final WebManager.ConnectorType HTTP_BIO = new WebManager.ConnectorType("Jetty BIO HTTP Connector");
    private static final WebManager.ConnectorType HTTPS_BIO = new WebManager.ConnectorType("Jetty BIO HTTPS Connector");
    private static final WebManager.ConnectorType AJP_NIO = new WebManager.ConnectorType("Jetty NIO AJP Connector");
    private static List<WebManager.ConnectorType> CONNECTOR_TYPES = Arrays.asList(HTTP_NIO, HTTPS_NIO, HTTP_BLOCKING_NIO, HTTP_BIO, HTTPS_BIO, AJP_NIO);
    private static Map<WebManager.ConnectorType, List<WebManager.ConnectorAttribute>> CONNECTOR_ATTRIBUTES = new HashMap<WebManager.ConnectorType, List<WebManager.ConnectorAttribute>>();
    private static Map<WebManager.ConnectorType, GBeanInfo> CONNECTOR_GBEAN_INFOS;
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;

    public JettyManagerImpl(Kernel kernel) {
        this.kernel = kernel;
    }

    public String getProductName() {
        return "Jetty";
    }

    public Object[] getContainers() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(JettyContainer.class.getName());
        Set names = this.kernel.listGBeans(query);
        Object[] results = new JettyContainer[names.size()];
        int i = 0;
        for (AbstractName name : names) {
            results[i] = (JettyContainer)proxyManager.createProxy(name, JettyContainer.class.getClassLoader());
            ++i;
        }
        return results;
    }

    public String[] getSupportedProtocols() {
        return new String[]{"HTTP", "HTTPS", "AJP"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(AbstractName connectorName) {
        block11: {
            try {
                GBeanInfo info = this.kernel.getGBeanInfo(connectorName);
                boolean found = false;
                Set intfs = info.getInterfaces();
                for (String intf : intfs) {
                    if (!intf.equals(JettyWebConnector.class.getName())) continue;
                    found = true;
                }
                if (!found) {
                    throw new GBeanNotFoundException(connectorName);
                }
                EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
                if (mgr != null) {
                    try {
                        mgr.removeGBeanFromConfiguration(connectorName.getArtifact(), connectorName);
                        break block11;
                    }
                    catch (InvalidConfigException e) {
                        log.error((Object)"Unable to add GBean", (Throwable)e);
                        break block11;
                    }
                    finally {
                        ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
                    }
                }
                log.warn((Object)"The ConfigurationManager in the kernel does not allow editing");
            }
            catch (GBeanNotFoundException e) {
                log.warn((Object)("No such GBean '" + connectorName + "'"));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public NetworkConnector[] getConnectors(String protocol) {
        if (protocol == null) {
            return this.getConnectors();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        for (AbstractName name : names) {
            try {
                if (!this.kernel.getAttribute(name, "protocol").equals(protocol)) continue;
                result.add(proxyManager.createProxy(name, JettyWebConnector.class.getClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)"Unable to check the protocol for a connector", (Throwable)e);
            }
        }
        return result.toArray(new JettyWebConnector[names.size()]);
    }

    public WebAccessLog getAccessLog(WebContainer container) {
        AbstractNameQuery query = new AbstractNameQuery(JettyLogManager.class.getName());
        Set names = this.kernel.listGBeans(query);
        if (names.size() == 0) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalStateException("Should not be more than one Jetty access log manager");
        }
        return (WebAccessLog)this.kernel.getProxyManager().createProxy((AbstractName)names.iterator().next(), JettyLogManager.class.getClassLoader());
    }

    public List<WebManager.ConnectorType> getConnectorTypes() {
        return CONNECTOR_TYPES;
    }

    public List<WebManager.ConnectorAttribute> getConnectorAttributes(WebManager.ConnectorType connectorType) {
        return WebManager.ConnectorAttribute.copy(CONNECTOR_ATTRIBUTES.get(connectorType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractName getConnectorConfiguration(WebManager.ConnectorType connectorType, List<WebManager.ConnectorAttribute> connectorAttributes, WebContainer container, String uniqueName) {
        EditableConfigurationManager mgr;
        GBeanInfo gbeanInfo = CONNECTOR_GBEAN_INFOS.get(connectorType);
        AbstractName containerName = this.kernel.getAbstractNameFor((Object)container);
        AbstractName name = this.kernel.getNaming().createSiblingName(containerName, uniqueName, "GBean");
        GBeanData gbeanData = new GBeanData(name, gbeanInfo);
        gbeanData.setReferencePattern("JettyContainer", containerName);
        for (WebManager.ConnectorAttribute connectorAttribute : connectorAttributes) {
            Object value = connectorAttribute.getValue();
            if (value == null) continue;
            gbeanData.setAttribute(connectorAttribute.getAttributeName(), connectorAttribute.getValue());
        }
        if (connectorType.equals((Object)HTTPS_NIO) || connectorType.equals((Object)HTTPS_BIO)) {
            AbstractNameQuery query = new AbstractNameQuery(KeystoreManager.class.getName());
            gbeanData.setReferencePattern("KeystoreManager", query);
        }
        if ((mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel)) != null) {
            try {
                mgr.addGBeanToConfiguration(containerName.getArtifact(), gbeanData, false);
            }
            catch (InvalidConfigException e) {
                log.error((Object)"Unable to add GBean", (Throwable)e);
                AbstractName abstractName = null;
                return abstractName;
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
            }
        } else {
            log.warn((Object)"The ConfigurationManager in the kernel does not allow editing");
            return null;
        }
        return name;
    }

    public WebManager.ConnectorType getConnectorType(AbstractName connectorName) {
        WebManager.ConnectorType connectorType = null;
        try {
            GBeanInfo info = this.kernel.getGBeanInfo(connectorName);
            boolean found = false;
            Set intfs = info.getInterfaces();
            Iterator it = intfs.iterator();
            while (it.hasNext() && !found) {
                String intf = (String)it.next();
                if (!intf.equals(JettyWebConnector.class.getName())) continue;
                found = true;
            }
            if (!found) {
                throw new GBeanNotFoundException(connectorName);
            }
            String searchingFor = info.getName();
            for (Map.Entry<WebManager.ConnectorType, GBeanInfo> entry : CONNECTOR_GBEAN_INFOS.entrySet()) {
                String candidate = entry.getValue().getName();
                if (!candidate.equals(searchingFor)) continue;
                return entry.getKey();
            }
        }
        catch (GBeanNotFoundException e) {
            log.warn((Object)("No such GBean '" + connectorName + "'"));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return connectorType;
    }

    public NetworkConnector[] getConnectors() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        JettyWebConnector[] results = new JettyWebConnector[names.size()];
        int i = 0;
        for (AbstractName name : names) {
            results[i] = (JettyWebConnector)proxyManager.createProxy(name, JettyWebConnector.class.getClassLoader());
            ++i;
        }
        return results;
    }

    public NetworkConnector[] getConnectorsForContainer(Object container, String protocol) {
        if (protocol == null) {
            return this.getConnectorsForContainer(container);
        }
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            for (AbstractName name : set) {
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("JettyContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                try {
                    String testProtocol = (String)this.kernel.getAttribute(name, "protocol");
                    if (testProtocol == null || !testProtocol.equals(protocol)) break;
                    results.add(mgr.createProxy(name, JettyWebConnector.class.getClassLoader()));
                }
                catch (Exception e) {
                    log.error((Object)("Unable to look up protocol for connector '" + name + "'"), (Throwable)e);
                }
                break;
            }
            return results.toArray(new JettyWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Jetty container '" + containerName + "': ").initCause(e);
        }
    }

    public NetworkConnector[] getConnectorsForContainer(Object container) {
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            for (AbstractName name : set) {
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("JettyContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                results.add(mgr.createProxy(name, JettyWebConnector.class.getClassLoader()));
            }
            return results.toArray(new JettyWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Jetty container '" + containerName + "'").initCause(e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        ArrayList<WebManager.ConnectorAttribute> connectorAttributes = new ArrayList<WebManager.ConnectorAttribute>();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8080, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)10, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSizeBytes", (Object)8096, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptQueueSize", (Object)10, "acceptQueueSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("lingerMillis", (Object)30000, "lingerMillis", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        CONNECTOR_ATTRIBUTES.put(HTTP_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8443, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)10, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSizeBytes", (Object)8096, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptQueueSize", (Object)10, "acceptQueueSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("lingerMillis", (Object)30000, "lingerMillis", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("clientAuthRequired", (Object)false, "If set, then clients connecting through this connector must supply a valid client certificate.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keyStore", (Object)"", "The keystore to use for accessing the server's private key", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("trustStore", (Object)"", "The keystore containing the trusted certificate entries, including Certification Authority (CA) certificates", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("secureProtocol", (Object)"", "This should normally be set to TLS, though some (IBM) JVMs don't work properly with popular browsers unless it is changed to SSL.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("algorithm", (Object)"Default", "This should normally be set to match the JVM vendor.", String.class));
        CONNECTOR_ATTRIBUTES.put(HTTPS_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8080, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)10, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSizeBytes", (Object)8096, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptQueueSize", (Object)10, "acceptQueueSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("lingerMillis", (Object)30000, "lingerMillis", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        CONNECTOR_ATTRIBUTES.put(HTTP_BIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8443, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)10, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSizeBytes", (Object)8096, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptQueueSize", (Object)10, "acceptQueueSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("lingerMillis", (Object)30000, "lingerMillis", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("clientAuthRequired", (Object)false, "If set, then clients connecting through this connector must supply a valid client certificate.", Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keyStore", (Object)"", "The keystore to use for accessing the server's private key", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("trustStore", (Object)"", "The keystore containing the trusted certificate entries, including Certification Authority (CA) certificates", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("secureProtocol", (Object)"", "This should normally be set to TLS, though some (IBM) JVMs don't work properly with popular browsers unless it is changed to SSL.", String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("algorithm", (Object)"Default", "This should normally be set to match the JVM vendor.", String.class));
        CONNECTOR_ATTRIBUTES.put(HTTPS_BIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8080, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)10, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSizeBytes", (Object)8096, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptQueueSize", (Object)10, "acceptQueueSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("lingerMillis", (Object)30000, "lingerMillis", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        CONNECTOR_ATTRIBUTES.put(HTTP_BLOCKING_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", "The host name or IP to bind to. The normal values are 0.0.0.0 (all interfaces) or localhost (local connections only)", String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8009, "The network port to bind to.", Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)10, "The maximum number of threads this connector should use to handle incoming requests", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSizeBytes", (Object)8096, "Buffer size", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptQueueSize", (Object)10, "acceptQueueSize", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("lingerMillis", (Object)30000, "lingerMillis", Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, "redirectPort", Integer.class));
        CONNECTOR_ATTRIBUTES.put(AJP_NIO, connectorAttributes);
        CONNECTOR_GBEAN_INFOS = new HashMap<WebManager.ConnectorType, GBeanInfo>();
        CONNECTOR_GBEAN_INFOS.put(HTTP_NIO, HTTPSelectChannelConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTPS_NIO, HTTPSSelectChannelConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTP_BLOCKING_NIO, HTTPBlockingConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTP_BIO, HTTPSocketConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTPS_BIO, HTTPSSocketConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(AJP_NIO, AJP13Connector.GBEAN_INFO);
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Jetty Web Manager", JettyManagerImpl.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(WebManager.class);
        infoFactory.setConstructor(new String[]{"kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

