/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.jetty.DefaultWebApplicationHandlerFactory;
import org.apache.geronimo.jetty.Host;
import org.apache.geronimo.jetty.JettyDefaultServletHolder;
import org.apache.geronimo.jetty.JettyFilterHolder;
import org.apache.geronimo.jetty.JettyFilterMapping;
import org.apache.geronimo.jetty.JettyServletHolder;
import org.apache.geronimo.jetty.JettyWebAppContext;
import org.apache.geronimo.jetty.NonAuthenticator;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.web.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.web.deployment.GenericToSpecificPlanConverter;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerClusteringDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.web.jetty.JettyWebAppDocument;
import org.apache.geronimo.xbeans.geronimo.web.jetty.JettyWebAppType;
import org.apache.geronimo.xbeans.geronimo.web.jetty.config.GerJettyDocument;
import org.apache.geronimo.xbeans.j2ee.DispatcherType;
import org.apache.geronimo.xbeans.j2ee.ErrorPageType;
import org.apache.geronimo.xbeans.j2ee.FilterMappingType;
import org.apache.geronimo.xbeans.j2ee.FilterType;
import org.apache.geronimo.xbeans.j2ee.FormLoginConfigType;
import org.apache.geronimo.xbeans.j2ee.JspConfigType;
import org.apache.geronimo.xbeans.j2ee.ListenerType;
import org.apache.geronimo.xbeans.j2ee.LocaleEncodingMappingListType;
import org.apache.geronimo.xbeans.j2ee.LocaleEncodingMappingType;
import org.apache.geronimo.xbeans.j2ee.LoginConfigType;
import org.apache.geronimo.xbeans.j2ee.MimeMappingType;
import org.apache.geronimo.xbeans.j2ee.ParamValueType;
import org.apache.geronimo.xbeans.j2ee.ServletMappingType;
import org.apache.geronimo.xbeans.j2ee.ServletType;
import org.apache.geronimo.xbeans.j2ee.TaglibType;
import org.apache.geronimo.xbeans.j2ee.WebAppDocument;
import org.apache.geronimo.xbeans.j2ee.WebAppType;
import org.apache.geronimo.xbeans.j2ee.WelcomeFileListType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.mortbay.http.BasicAuthenticator;
import org.mortbay.http.ClientCertAuthenticator;
import org.mortbay.http.DigestAuthenticator;
import org.mortbay.jetty.servlet.FormAuthenticator;

public class JettyModuleBuilder
extends AbstractWebModuleBuilder {
    private static final Log log;
    private final Environment defaultEnvironment;
    private final AbstractNameQuery jettyContainerObjectName;
    private final Collection defaultServlets;
    private final Collection defaultFilters;
    private final Collection defaultFilterMappings;
    private final GBeanData pojoWebServiceTemplate;
    private final Collection webServiceBuilder;
    protected final NamespaceDrivenBuilderCollection clusteringBuilders;
    private final List defaultWelcomeFiles;
    private final Integer defaultSessionTimeoutSeconds;
    private static final String JETTY_NAMESPACE;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JettyModuleBuilder(Environment defaultEnvironment, Integer defaultSessionTimeoutSeconds, List defaultWelcomeFiles, AbstractNameQuery jettyContainerName, Collection defaultServlets, Collection defaultFilters, Collection defaultFilterMappings, Object pojoWebServiceTemplate, Collection webServiceBuilder, Collection clusteringBuilders, Collection securityBuilders, Collection serviceBuilders, NamingBuilder namingBuilders, ResourceEnvironmentSetter resourceEnvironmentSetter, Kernel kernel) throws GBeanNotFoundException {
        super(kernel, securityBuilders, serviceBuilders, namingBuilders, resourceEnvironmentSetter);
        this.defaultEnvironment = defaultEnvironment;
        this.defaultSessionTimeoutSeconds = defaultSessionTimeoutSeconds == null ? new Integer(1800) : defaultSessionTimeoutSeconds;
        this.jettyContainerObjectName = jettyContainerName;
        this.defaultServlets = defaultServlets;
        this.defaultFilters = defaultFilters;
        this.defaultFilterMappings = defaultFilterMappings;
        this.pojoWebServiceTemplate = JettyModuleBuilder.getGBeanData(kernel, pojoWebServiceTemplate);
        this.webServiceBuilder = webServiceBuilder;
        this.clusteringBuilders = new NamespaceDrivenBuilderCollection(clusteringBuilders, GerClusteringDocument.type.getDocumentElementName());
        this.defaultWelcomeFiles = defaultWelcomeFiles;
    }

    private static GBeanData getGBeanData(Kernel kernel, Object template) throws GBeanNotFoundException {
        if (template == null) {
            return null;
        }
        AbstractName templateName = kernel.getAbstractNameFor(template);
        return kernel.getGBeanData(templateName);
    }

    protected Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, boolean standAlone, String contextRoot, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        Boolean distributable;
        WebAppType webApp;
        String specDD;
        if (!$assertionsDisabled && moduleFile == null) {
            throw new AssertionError((Object)"moduleFile is null");
        }
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && targetPath.endsWith("/")) {
            throw new AssertionError((Object)"targetPath must not end with a '/'");
        }
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/web.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            return null;
        }
        try {
            XmlObject parsed = XmlBeansUtil.parse((String)specDD);
            WebAppDocument webAppDoc = JettyModuleBuilder.convertToServletSchema((XmlObject)parsed);
            webApp = webAppDoc.getWebApp();
        }
        catch (XmlException xmle) {
            throw new DeploymentException("Error parsing web.xml for " + targetPath, (Throwable)xmle);
        }
        JettyModuleBuilder.check((WebAppType)webApp);
        JettyWebAppType jettyWebApp = this.getJettyWebApp(plan, moduleFile, standAlone, targetPath, webApp);
        if (contextRoot == null || contextRoot.trim().equals("")) {
            contextRoot = jettyWebApp.isSetContextRoot() ? jettyWebApp.getContextRoot() : this.determineDefaultContextRoot(webApp, standAlone, moduleFile, targetPath);
        }
        contextRoot = contextRoot.trim();
        EnvironmentType environmentType = jettyWebApp.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        Boolean bl = distributable = webApp.getDistributableArray().length == 1 ? Boolean.TRUE : Boolean.FALSE;
        if (Boolean.TRUE == distributable) {
            this.clusteringBuilders.buildEnvironment((XmlObject)jettyWebApp, environment);
        }
        this.getNamingBuilders().buildEnvironment((XmlObject)webApp, (XmlObject)jettyWebApp, environment);
        String warName = "";
        File temp = new File(moduleFile.getName());
        if (temp.isFile()) {
            warName = temp.getName();
            if (warName.lastIndexOf(46) > -1) {
                warName = warName.substring(0, warName.lastIndexOf(46));
            }
        } else {
            try {
                warName = temp.getCanonicalFile().getName();
                if (warName.equals("")) {
                    warName = "$root-dir$";
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        idBuilder.resolve(environment, warName, "war");
        Map servletNameToPathMap = this.buildServletNameToPathMap(webApp, contextRoot);
        HashMap sharedContext = new HashMap();
        Iterator iterator = this.webServiceBuilder.iterator();
        while (iterator.hasNext()) {
            WebServiceBuilder serviceBuilder = (WebServiceBuilder)iterator.next();
            serviceBuilder.findWebServices(moduleFile, false, servletNameToPathMap, environment, sharedContext);
        }
        if (earName == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "WebModule");
        } else {
            moduleName = naming.createChildName(earName, targetPath, "WebModule");
        }
        return new WebModule(standAlone, moduleName, environment, moduleFile, targetPath, (XmlObject)webApp, (XmlObject)jettyWebApp, specDD, contextRoot, sharedContext, JETTY_NAMESPACE);
    }

    JettyWebAppType getJettyWebApp(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, WebAppType webApp) throws DeploymentException {
        XmlObject rawPlan = null;
        try {
            JettyWebAppType jettyWebApp;
            block12: {
                try {
                    if (plan instanceof XmlObject) {
                        rawPlan = (XmlObject)plan;
                        break block12;
                    }
                    if (plan != null) {
                        rawPlan = XmlBeansUtil.parse((URL)((File)plan).toURL(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                        break block12;
                    }
                    URL path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/geronimo-web.xml");
                    try {
                        rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    }
                    catch (FileNotFoundException e) {
                        path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/geronimo-jetty.xml");
                        try {
                            rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                        }
                        catch (FileNotFoundException e1) {
                            log.warn((Object)("Web application " + targetPath + " does not contain a WEB-INF/geronimo-web.xml deployment plan.  This may or may not be a problem, depending on whether you have things like resource references that need to be resolved.  You can also give the deployer a separate deployment plan file on the command line."));
                        }
                    }
                }
                catch (IOException e) {
                    log.warn((Object)e);
                }
            }
            if (rawPlan != null) {
                XmlObject webPlan = new GenericToSpecificPlanConverter(GerJettyDocument.type.getDocumentElementName().getNamespaceURI(), JettyWebAppDocument.type.getDocumentElementName().getNamespaceURI(), "jetty").convertToSpecificPlan(rawPlan);
                jettyWebApp = (JettyWebAppType)webPlan.changeType(JettyWebAppType.type);
                XmlBeansUtil.validateDD((XmlObject)jettyWebApp);
            } else {
                String defaultContextRoot = this.determineDefaultContextRoot(webApp, standAlone, moduleFile, targetPath);
                jettyWebApp = this.createDefaultPlan(defaultContextRoot);
            }
            return jettyWebApp;
        }
        catch (XmlException e) {
            throw new DeploymentException("xml problem for web app " + targetPath, (Throwable)e);
        }
    }

    private JettyWebAppType createDefaultPlan(String contextRoot) {
        JettyWebAppType jettyWebApp = JettyWebAppType.Factory.newInstance();
        jettyWebApp.setContextRoot(contextRoot);
        return jettyWebApp;
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        WebAppType webApp = (WebAppType)module.getSpecDD();
        JettyWebAppType gerWebApp = (JettyWebAppType)module.getVendorDD();
        this.getNamingBuilders().initContext((XmlObject)webApp, (XmlObject)gerWebApp, module.getEarContext().getConfiguration(), earContext.getConfiguration(), module);
        if (!(webApp.getSecurityConstraintArray().length <= 0 && webApp.getSecurityRoleArray().length <= 0 || gerWebApp.isSetSecurityRealmName())) {
            throw new DeploymentException("web.xml for web app " + module.getName() + " includes security elements but Geronimo deployment plan is not provided or does not contain <security-realm-name> element necessary to configure security accordingly.");
        }
        boolean hasSecurityRealmName = gerWebApp.isSetSecurityRealmName();
        this.buildSubstitutionGroups(gerWebApp, hasSecurityRealmName, module, earContext);
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repository) throws DeploymentException {
        EARContext moduleContext = module.getEarContext();
        AbstractName moduleName = moduleContext.getModuleName();
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        JettyWebAppType jettyWebApp = (JettyWebAppType)webModule.getVendorDD();
        GBeanData webModuleData = new GBeanData(moduleName, JettyWebAppContext.GBEAN_INFO);
        try {
            moduleContext.addGBean(webModuleData);
            if (moduleContext.getServerName() != null) {
                webModuleData.setReferencePattern("J2EEServer", moduleContext.getServerName());
            }
            if (!module.isStandAlone()) {
                webModuleData.setReferencePattern("J2EEApplication", earContext.getModuleName());
            }
            webModuleData.setAttribute("deploymentDescriptor", (Object)module.getOriginalSpecDD());
            Set securityRoles = JettyModuleBuilder.collectRoleNames((WebAppType)webApp);
            HashMap rolePermissions = new HashMap();
            this.configureHosts(earContext, jettyWebApp, webModuleData);
            Set dependencies = this.findGBeanDependencies(earContext);
            webModuleData.addDependencies(dependencies);
            HashMap buildingContext = new HashMap();
            buildingContext.put("JNDI_COMPONENT_CONTEXT", new HashMap());
            buildingContext.put("GBEAN_NAME", moduleName);
            Configuration earConfiguration = earContext.getConfiguration();
            this.getNamingBuilders().buildNaming((XmlObject)webApp, (XmlObject)jettyWebApp, earConfiguration, earConfiguration, (Module)webModule, buildingContext);
            Map compContext = (Map)buildingContext.get("JNDI_COMPONENT_CONTEXT");
            webModuleData.setAttribute("componentContext", (Object)compContext);
            GBeanResourceEnvironmentBuilder rebuilder = new GBeanResourceEnvironmentBuilder(webModuleData);
            this.resourceEnvironmentSetter.setResourceEnvironment((ResourceEnvironmentBuilder)rebuilder, (XmlObject[])webApp.getResourceRefArray(), jettyWebApp.getResourceRefArray());
            webModuleData.setAttribute("contextPath", (Object)webModule.getContextRoot());
            webModuleData.setReferencePattern("TransactionManager", moduleContext.getTransactionManagerName());
            webModuleData.setReferencePattern("TrackedConnectionAssociator", moduleContext.getConnectionTrackerName());
            if (jettyWebApp.isSetWebContainer()) {
                AbstractNameQuery webContainerName = ENCConfigBuilder.getGBeanQuery((String)"GBean", (GerGbeanLocatorType)jettyWebApp.getWebContainer());
                webModuleData.setReferencePattern("JettyContainer", webContainerName);
            } else {
                webModuleData.setReferencePattern("JettyContainer", this.jettyContainerObjectName);
            }
            if (webApp.getDisplayNameArray().length > 0) {
                webModuleData.setAttribute("displayName", (Object)webApp.getDisplayNameArray()[0].getStringValue());
            }
            this.configureContextParams(webApp, webModuleData);
            this.configureListeners(webApp, webModuleData);
            webModuleData.setAttribute("sessionTimeoutSeconds", (Object)(webApp.getSessionConfigArray().length == 1 && webApp.getSessionConfigArray(0).getSessionTimeout() != null ? new Integer(webApp.getSessionConfigArray(0).getSessionTimeout().getBigIntegerValue().intValue() * 60) : this.defaultSessionTimeoutSeconds));
            Boolean distributable = webApp.getDistributableArray().length == 1 ? Boolean.TRUE : Boolean.FALSE;
            webModuleData.setAttribute("distributable", (Object)distributable);
            if (Boolean.TRUE == distributable) {
                this.clusteringBuilders.build((XmlObject)jettyWebApp, (DeploymentContext)earContext, (DeploymentContext)moduleContext);
                if (webModuleData.getReferencePatterns("WebApplicationHandlerFactory") == null) {
                    log.warn((Object)"No clustering builders configured: app will not be clustered");
                    this.configureNoClustering(moduleContext, webModuleData);
                }
            } else {
                this.configureNoClustering(moduleContext, webModuleData);
            }
            this.configureMimeMappings(webApp, webModuleData);
            this.configureWelcomeFileLists(webApp, webModuleData);
            this.configureLocalEncodingMappingLists(webApp, webModuleData);
            this.configureErrorPages(webApp, webModuleData);
            this.configureTagLibs(module, webApp, webModuleData);
            this.configureLoginConfigs(module, webApp, jettyWebApp, webModuleData);
            HashSet knownServletMappings = new HashSet();
            HashMap servletMappings = new HashMap();
            this.buildServletMappings(module, webApp, servletMappings, knownServletMappings);
            AbstractName previous = null;
            if (this.defaultFilters != null) {
                previous = this.addDefaultFiltersGBeans(earContext, moduleContext, moduleName, previous);
            }
            this.addFilterMappingsGBeans(earContext, moduleContext, moduleName, webApp, previous);
            this.addFiltersGBeans(earContext, moduleContext, moduleName, webApp);
            if (this.defaultServlets != null) {
                this.addDefaultServletsGBeans(earContext, moduleContext, moduleName, knownServletMappings);
            }
            ServletType[] servletTypes = webApp.getServletArray();
            this.addServlets(moduleName, webModule, servletTypes, servletMappings, securityRoles, rolePermissions, moduleContext);
            if (jettyWebApp.isSetSecurityRealmName()) {
                this.configureSecurityRealm(earContext, webApp, jettyWebApp, webModuleData, securityRoles, rolePermissions);
            }
            if (!module.isStandAlone()) {
                ConfigurationData moduleConfigurationData = moduleContext.getConfigurationData();
                earContext.addChildConfiguration(module.getTargetPath(), moduleConfigurationData);
            }
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize webapp GBean for " + module.getName(), (Throwable)e);
        }
    }

    private void configureNoClustering(EARContext moduleContext, GBeanData webModuleData) throws GBeanAlreadyExistsException {
        AbstractName name = moduleContext.getNaming().createChildName(moduleContext.getModuleName(), "DefaultWebApplicationHandlerFactory", "GBean");
        GBeanData beanData = new GBeanData(name, DefaultWebApplicationHandlerFactory.GBEAN_INFO);
        webModuleData.setReferencePattern("WebApplicationHandlerFactory", name);
        moduleContext.addGBean(beanData);
    }

    private void configureSecurityRealm(EARContext earContext, WebAppType webApp, JettyWebAppType jettyWebApp, GBeanData webModuleData, Set securityRoles, Map rolePermissions) throws DeploymentException {
        AbstractName moduleName = webModuleData.getAbstractName();
        if (earContext.getSecurityConfiguration() == null) {
            throw new DeploymentException("You have specified a <security-realm-name> for the webapp " + moduleName + " but no <security> configuration (role mapping) is supplied in the Geronimo plan for the web application (or the Geronimo plan for the EAR if the web app is in an EAR)");
        }
        String securityRealmName = jettyWebApp.getSecurityRealmName().trim();
        webModuleData.setAttribute("securityRealmName", (Object)securityRealmName);
        String policyContextID = moduleName.toString().replaceAll("[, :]", "_");
        webModuleData.setAttribute("policyContextID", (Object)policyContextID);
        ComponentPermissions componentPermissions = this.buildSpecSecurityConfig(webApp, securityRoles, rolePermissions);
        webModuleData.setAttribute("excludedPermissions", (Object)componentPermissions.getExcludedPermissions());
        Permissions checkedPermissions = new Permissions();
        Iterator iterator = rolePermissions.values().iterator();
        while (iterator.hasNext()) {
            PermissionCollection permissionsForRole = (PermissionCollection)iterator.next();
            Enumeration<Permission> iterator2 = permissionsForRole.elements();
            while (iterator2.hasMoreElements()) {
                Permission permission = iterator2.nextElement();
                ((PermissionCollection)checkedPermissions).add(permission);
            }
        }
        webModuleData.setAttribute("checkedPermissions", (Object)checkedPermissions);
        earContext.addSecurityContext(policyContextID, (Object)componentPermissions);
        DefaultPrincipal defaultPrincipal = ((SecurityConfiguration)earContext.getSecurityConfiguration()).getDefaultPrincipal();
        webModuleData.setAttribute("defaultPrincipal", (Object)defaultPrincipal);
    }

    private void addDefaultServletsGBeans(EARContext earContext, EARContext moduleContext, AbstractName moduleName, Set knownServletMappings) throws GBeanNotFoundException, GBeanAlreadyExistsException {
        Iterator iterator = this.defaultServlets.iterator();
        while (iterator.hasNext()) {
            Object defaultServlet = iterator.next();
            GBeanData servletGBeanData = JettyModuleBuilder.getGBeanData(this.kernel, defaultServlet);
            AbstractName defaultServletObjectName = earContext.getNaming().createChildName(moduleName, (String)servletGBeanData.getAttribute("servletName"), "Servlet");
            servletGBeanData.setAbstractName(defaultServletObjectName);
            servletGBeanData.setReferencePattern("JettyServletRegistration", moduleName);
            HashSet defaultServletMappings = new HashSet((Collection)servletGBeanData.getAttribute("servletMappings"));
            defaultServletMappings.removeAll(knownServletMappings);
            servletGBeanData.setAttribute("servletMappings", defaultServletMappings);
            moduleContext.addGBean(servletGBeanData);
        }
    }

    private void addFiltersGBeans(EARContext earContext, EARContext moduleContext, AbstractName moduleName, WebAppType webApp) throws GBeanAlreadyExistsException {
        FilterType[] filterArray = webApp.getFilterArray();
        for (int i = 0; i < filterArray.length; ++i) {
            FilterType filterType = filterArray[i];
            String filterName = filterType.getFilterName().getStringValue().trim();
            AbstractName filterAbstractName = earContext.getNaming().createChildName(moduleName, filterName, "WebFilter");
            GBeanData filterData = new GBeanData(filterAbstractName, JettyFilterHolder.GBEAN_INFO);
            filterData.setAttribute("filterName", (Object)filterName);
            filterData.setAttribute("filterClass", (Object)filterType.getFilterClass().getStringValue().trim());
            HashMap<String, String> initParams = new HashMap<String, String>();
            ParamValueType[] initParamArray = filterType.getInitParamArray();
            for (int j = 0; j < initParamArray.length; ++j) {
                ParamValueType paramValueType = initParamArray[j];
                initParams.put(paramValueType.getParamName().getStringValue().trim(), paramValueType.getParamValue().getStringValue().trim());
            }
            filterData.setAttribute("initParams", initParams);
            filterData.setReferencePattern("JettyServletRegistration", moduleName);
            moduleContext.addGBean(filterData);
        }
    }

    private void addFilterMappingsGBeans(EARContext earContext, EARContext moduleContext, AbstractName moduleName, WebAppType webApp, AbstractName previous) throws GBeanAlreadyExistsException {
        FilterMappingType[] filterMappingArray = webApp.getFilterMappingArray();
        for (int i = 0; i < filterMappingArray.length; ++i) {
            FilterMappingType filterMappingType = filterMappingArray[i];
            String filterName = filterMappingType.getFilterName().getStringValue().trim();
            GBeanData filterMappingData = new GBeanData(JettyFilterMapping.GBEAN_INFO);
            if (previous != null) {
                filterMappingData.setReferencePattern("Previous", previous);
            }
            filterMappingData.setReferencePattern("JettyServletRegistration", moduleName);
            AbstractName filterAbstractName = earContext.getNaming().createChildName(moduleName, filterName, "WebFilter");
            AbstractName filterMappingName = null;
            if (filterMappingType.isSetUrlPattern()) {
                String urlPattern = filterMappingType.getUrlPattern().getStringValue().trim();
                filterMappingData.setAttribute("urlPattern", (Object)urlPattern);
                filterMappingName = earContext.getNaming().createChildName(filterAbstractName, ObjectName.quote(urlPattern), "URLWebFilterMapping");
            }
            if (filterMappingType.isSetServletName()) {
                String servletName = filterMappingType.getServletName().getStringValue().trim();
                AbstractName servletAbstractName = earContext.getNaming().createChildName(moduleName, servletName, "Servlet");
                filterMappingData.setReferencePattern("Servlet", servletAbstractName);
                filterMappingName = earContext.getNaming().createChildName(filterAbstractName, servletName, "ServletWebFilterMapping");
            }
            filterMappingData.setAbstractName(filterMappingName);
            previous = filterMappingName;
            boolean request = filterMappingType.getDispatcherArray().length == 0;
            boolean forward = false;
            boolean include = false;
            boolean error = false;
            for (int j = 0; j < filterMappingType.getDispatcherArray().length; ++j) {
                DispatcherType dispatcherType = filterMappingType.getDispatcherArray()[j];
                if (dispatcherType.getStringValue().equals("REQUEST")) {
                    request = true;
                    continue;
                }
                if (dispatcherType.getStringValue().equals("FORWARD")) {
                    forward = true;
                    continue;
                }
                if (dispatcherType.getStringValue().equals("INCLUDE")) {
                    include = true;
                    continue;
                }
                if (!dispatcherType.getStringValue().equals("ERROR")) continue;
                error = true;
            }
            filterMappingData.setAttribute("requestDispatch", (Object)request);
            filterMappingData.setAttribute("forwardDispatch", (Object)forward);
            filterMappingData.setAttribute("includeDispatch", (Object)include);
            filterMappingData.setAttribute("errorDispatch", (Object)error);
            filterMappingData.setReferencePattern("Filter", filterAbstractName);
            moduleContext.addGBean(filterMappingData);
        }
    }

    private AbstractName addDefaultFiltersGBeans(EARContext earContext, EARContext moduleContext, AbstractName moduleName, AbstractName previous) throws GBeanNotFoundException, GBeanAlreadyExistsException {
        Iterator iterator = this.defaultFilters.iterator();
        while (iterator.hasNext()) {
            Object defaultFilter = iterator.next();
            GBeanData filterGBeanData = JettyModuleBuilder.getGBeanData(this.kernel, defaultFilter);
            String filterName = (String)filterGBeanData.getAttribute("filterName");
            AbstractName defaultFilterAbstractName = earContext.getNaming().createChildName(moduleName, filterName, "WebFilter");
            filterGBeanData.setAbstractName(defaultFilterAbstractName);
            filterGBeanData.setReferencePattern("JettyServletRegistration", moduleName);
            moduleContext.addGBean(filterGBeanData);
            GBeanData filterMappingGBeanData = new GBeanData(JettyFilterMapping.GBEAN_INFO);
            if (previous != null) {
                filterMappingGBeanData.setReferencePattern("Previous", previous);
            }
            filterMappingGBeanData.setReferencePattern("JettyServletRegistration", moduleName);
            String urlPattern = "/*";
            filterMappingGBeanData.setAttribute("urlPattern", (Object)urlPattern);
            AbstractName filterMappingName = earContext.getNaming().createChildName(defaultFilterAbstractName, urlPattern, "URLWebFilterMapping");
            filterMappingGBeanData.setAbstractName(filterMappingName);
            previous = filterMappingName;
            filterMappingGBeanData.setAttribute("requestDispatch", (Object)Boolean.TRUE);
            filterMappingGBeanData.setAttribute("forwardDispatch", (Object)Boolean.TRUE);
            filterMappingGBeanData.setAttribute("includeDispatch", (Object)Boolean.TRUE);
            filterMappingGBeanData.setAttribute("errorDispatch", (Object)Boolean.FALSE);
            filterMappingGBeanData.setReferencePattern("Filter", defaultFilterAbstractName);
            moduleContext.addGBean(filterMappingGBeanData);
        }
        return previous;
    }

    private Map buildServletMappings(Module module, WebAppType webApp, Map servletMappings, Set knownServletMappings) throws DeploymentException {
        ServletType[] servletTypes = webApp.getServletArray();
        HashSet<String> knownServlets = new HashSet<String>();
        for (int i = 0; i < servletTypes.length; ++i) {
            ServletType type = servletTypes[i];
            knownServlets.add(type.getServletName().getStringValue().trim());
        }
        ServletMappingType[] servletMappingArray = webApp.getServletMappingArray();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            ServletMappingType servletMappingType = servletMappingArray[i];
            String servletName = servletMappingType.getServletName().getStringValue().trim();
            if (!knownServlets.contains(servletName)) {
                throw new DeploymentException("Web app " + module.getName() + " contains a servlet mapping that refers to servlet '" + servletName + "' but no such servlet was found!");
            }
            String urlPattern = servletMappingType.getUrlPattern().getStringValue().trim();
            if (knownServletMappings.contains(urlPattern)) continue;
            knownServletMappings.add(urlPattern);
            JettyModuleBuilder.checkString((String)urlPattern);
            HashSet<String> urlsForServlet = (HashSet<String>)servletMappings.get(servletName);
            if (urlsForServlet == null) {
                urlsForServlet = new HashSet<String>();
                servletMappings.put(servletName, urlsForServlet);
            }
            urlsForServlet.add(urlPattern);
        }
        return servletMappings;
    }

    private void configureLoginConfigs(Module module, WebAppType webApp, JettyWebAppType jettyWebApp, GBeanData webModuleData) throws DeploymentException {
        LoginConfigType[] loginConfigArray = webApp.getLoginConfigArray();
        if (loginConfigArray.length > 1) {
            throw new DeploymentException("Web app " + module.getName() + " cannot have more than one login-config element.  Currently has " + loginConfigArray.length + " login-config elements.");
        }
        if (loginConfigArray.length == 1) {
            LoginConfigType loginConfig = loginConfigArray[0];
            if (loginConfig.isSetAuthMethod()) {
                String authMethod = loginConfig.getAuthMethod().getStringValue();
                if ("BASIC".equals(authMethod)) {
                    webModuleData.setAttribute("authenticator", (Object)new BasicAuthenticator());
                } else if ("DIGEST".equals(authMethod)) {
                    webModuleData.setAttribute("authenticator", (Object)new DigestAuthenticator());
                } else if ("FORM".equals(authMethod)) {
                    FormAuthenticator formAuthenticator = new FormAuthenticator();
                    webModuleData.setAttribute("authenticator", (Object)formAuthenticator);
                    if (loginConfig.isSetFormLoginConfig()) {
                        FormLoginConfigType formLoginConfig = loginConfig.getFormLoginConfig();
                        formAuthenticator.setLoginPage(formLoginConfig.getFormLoginPage().getStringValue());
                        formAuthenticator.setErrorPage(formLoginConfig.getFormErrorPage().getStringValue());
                    }
                } else if ("CLIENT-CERT".equals(authMethod)) {
                    webModuleData.setAttribute("authenticator", (Object)new ClientCertAuthenticator());
                }
            }
            if (loginConfig.isSetRealmName()) {
                webModuleData.setAttribute("realmName", (Object)loginConfig.getRealmName().getStringValue());
            }
        } else if (jettyWebApp.isSetSecurityRealmName()) {
            webModuleData.setAttribute("authenticator", (Object)new NonAuthenticator());
        }
    }

    private void configureTagLibs(Module module, WebAppType webApp, GBeanData webModuleData) throws DeploymentException {
        JspConfigType[] jspConfigArray = webApp.getJspConfigArray();
        if (jspConfigArray.length > 1) {
            throw new DeploymentException("Web app " + module.getName() + " cannot have more than one jsp-config element.  Currently has " + jspConfigArray.length + " jsp-config elements.");
        }
        HashMap<String, String> tagLibMap = new HashMap<String, String>();
        for (int i = 0; i < jspConfigArray.length; ++i) {
            TaglibType[] tagLibArray = jspConfigArray[i].getTaglibArray();
            for (int j = 0; j < tagLibArray.length; ++j) {
                TaglibType taglib = tagLibArray[j];
                tagLibMap.put(taglib.getTaglibUri().getStringValue().trim(), taglib.getTaglibLocation().getStringValue().trim());
            }
        }
        webModuleData.setAttribute("tagLibMap", tagLibMap);
    }

    private void configureErrorPages(WebAppType webApp, GBeanData webModuleData) {
        ErrorPageType[] errorPageArray = webApp.getErrorPageArray();
        HashMap<String, String> errorPageMap = new HashMap<String, String>();
        for (int i = 0; i < errorPageArray.length; ++i) {
            ErrorPageType errorPageType = errorPageArray[i];
            if (errorPageType.isSetErrorCode()) {
                errorPageMap.put(errorPageType.getErrorCode().getStringValue(), errorPageType.getLocation().getStringValue());
                continue;
            }
            errorPageMap.put(errorPageType.getExceptionType().getStringValue(), errorPageType.getLocation().getStringValue());
        }
        webModuleData.setAttribute("errorPages", errorPageMap);
    }

    private void configureLocalEncodingMappingLists(WebAppType webApp, GBeanData webModuleData) {
        LocaleEncodingMappingListType[] localeEncodingMappingListArray = webApp.getLocaleEncodingMappingListArray();
        HashMap<String, String> localeEncodingMappingMap = new HashMap<String, String>();
        for (int i = 0; i < localeEncodingMappingListArray.length; ++i) {
            LocaleEncodingMappingType[] localeEncodingMappingArray = localeEncodingMappingListArray[i].getLocaleEncodingMappingArray();
            for (int j = 0; j < localeEncodingMappingArray.length; ++j) {
                LocaleEncodingMappingType localeEncodingMapping = localeEncodingMappingArray[j];
                localeEncodingMappingMap.put(localeEncodingMapping.getLocale(), localeEncodingMapping.getEncoding());
            }
        }
        webModuleData.setAttribute("localeEncodingMapping", localeEncodingMappingMap);
    }

    private void configureWelcomeFileLists(WebAppType webApp, GBeanData webModuleData) {
        ArrayList<String> welcomeFiles;
        WelcomeFileListType[] welcomeFileArray = webApp.getWelcomeFileListArray();
        if (welcomeFileArray.length > 0) {
            welcomeFiles = new ArrayList<String>();
            for (int i = 0; i < welcomeFileArray.length; ++i) {
                String[] welcomeFileListType = welcomeFileArray[i].getWelcomeFileArray();
                for (int j = 0; j < welcomeFileListType.length; ++j) {
                    String welcomeFile = welcomeFileListType[j].trim();
                    welcomeFiles.add(welcomeFile);
                }
            }
        } else {
            welcomeFiles = new ArrayList(this.defaultWelcomeFiles);
        }
        webModuleData.setAttribute("welcomeFiles", (Object)welcomeFiles.toArray(new String[welcomeFiles.size()]));
    }

    private void configureMimeMappings(WebAppType webApp, GBeanData webModuleData) {
        MimeMappingType[] mimeMappingArray = webApp.getMimeMappingArray();
        HashMap<String, String> mimeMappingMap = new HashMap<String, String>();
        for (int i = 0; i < mimeMappingArray.length; ++i) {
            MimeMappingType mimeMappingType = mimeMappingArray[i];
            mimeMappingMap.put(mimeMappingType.getExtension().getStringValue(), mimeMappingType.getMimeType().getStringValue());
        }
        webModuleData.setAttribute("mimeMap", mimeMappingMap);
    }

    private void configureListeners(WebAppType webApp, GBeanData webModuleData) {
        ListenerType[] listenerArray = webApp.getListenerArray();
        ArrayList<String> listeners = new ArrayList<String>();
        for (int i = 0; i < listenerArray.length; ++i) {
            ListenerType listenerType = listenerArray[i];
            listeners.add(listenerType.getListenerClass().getStringValue());
        }
        webModuleData.setAttribute("listenerClassNames", listeners);
    }

    private void configureContextParams(WebAppType webApp, GBeanData webModuleData) {
        ParamValueType[] contextParamArray = webApp.getContextParamArray();
        HashMap<String, String> contextParams = new HashMap<String, String>();
        for (int i = 0; i < contextParamArray.length; ++i) {
            ParamValueType contextParam = contextParamArray[i];
            contextParams.put(contextParam.getParamName().getStringValue().trim(), contextParam.getParamValue().getStringValue().trim());
        }
        webModuleData.setAttribute("contextParamMap", contextParams);
    }

    private void configureHosts(EARContext earContext, JettyWebAppType jettyWebApp, GBeanData webModuleData) throws GBeanAlreadyExistsException {
        String[] hosts = jettyWebApp.getHostArray();
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i].trim();
        }
        String[] virtualHosts = jettyWebApp.getVirtualHostArray();
        for (int i = 0; i < virtualHosts.length; ++i) {
            virtualHosts[i] = virtualHosts[i].trim();
        }
        if (hosts.length > 0 || virtualHosts.length > 0) {
            AbstractName hostName = earContext.getNaming().createChildName(webModuleData.getAbstractName(), "Host", "Host");
            GBeanData hostData = new GBeanData(hostName, Host.GBEAN_INFO);
            hostData.setAttribute("hosts", (Object)hosts);
            hostData.setAttribute("virtualHosts", (Object)virtualHosts);
            earContext.addGBean(hostData);
            webModuleData.setReferencePattern("Host", hostName);
        }
    }

    public String getSchemaNamespace() {
        return JETTY_NAMESPACE;
    }

    private void addServlets(AbstractName webModuleName, WebModule module, ServletType[] servletTypes, Map servletMappings, Set securityRoles, Map rolePermissions, EARContext moduleContext) throws DeploymentException {
        TreeSet<ServletType> loadOrder = new TreeSet<ServletType>(new StartupOrderComparator());
        for (int i = 0; i < servletTypes.length; ++i) {
            loadOrder.add(servletTypes[i]);
        }
        AbstractName previousServlet = null;
        Iterator servlets = loadOrder.iterator();
        while (servlets.hasNext()) {
            ServletType servletType = (ServletType)servlets.next();
            previousServlet = this.addServlet(webModuleName, module, previousServlet, servletType, servletMappings, securityRoles, rolePermissions, moduleContext);
        }
        this.addUnmappedJSPPermissions(securityRoles, rolePermissions);
    }

    private AbstractName addServlet(AbstractName webModuleName, WebModule module, AbstractName previousServlet, ServletType servletType, Map servletMappings, Set securityRoles, Map rolePermissions, EARContext moduleContext) throws DeploymentException {
        Set mappings;
        GBeanData servletData;
        Class<?> baseServletClass;
        ClassLoader webClassLoader = moduleContext.getClassLoader();
        String servletName = servletType.getServletName().getStringValue().trim();
        AbstractName servletAbstractName = moduleContext.getNaming().createChildName(webModuleName, servletName, "Servlet");
        HashMap<String, String> initParams = new HashMap<String, String>();
        try {
            baseServletClass = webClassLoader.loadClass(Servlet.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load javax.servlet.Servlet in web classloader", (Throwable)e);
        }
        if (servletType.isSetServletClass()) {
            Class<?> servletClass;
            String servletClassName = servletType.getServletClass().getStringValue().trim();
            try {
                servletClass = webClassLoader.loadClass(servletClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load servlet class " + servletClassName, (Throwable)e);
            }
            if (baseServletClass.isAssignableFrom(servletClass)) {
                servletData = new GBeanData(servletAbstractName, JettyServletHolder.GBEAN_INFO);
                servletData.setAttribute("servletClass", (Object)servletClassName);
            } else {
                servletData = new GBeanData(this.pojoWebServiceTemplate);
                servletData.setAbstractName(servletAbstractName);
                boolean configured = false;
                Iterator iterator = this.webServiceBuilder.iterator();
                while (iterator.hasNext()) {
                    WebServiceBuilder serviceBuilder = (WebServiceBuilder)iterator.next();
                    if (!serviceBuilder.configurePOJO(servletData, servletName, (Module)module, servletClassName, (DeploymentContext)moduleContext)) continue;
                    configured = true;
                    break;
                }
                if (!configured) {
                    throw new DeploymentException("POJO web service: " + servletName + " not configured by any web service builder");
                }
            }
        } else if (servletType.isSetJspFile()) {
            servletData = new GBeanData(servletAbstractName, JettyServletHolder.GBEAN_INFO);
            servletData.setAttribute("jspFile", (Object)servletType.getJspFile().getStringValue().trim());
            servletData.setAttribute("servletClass", (Object)"org.apache.jasper.servlet.JspServlet");
            initParams.put("development", "false");
        } else {
            throw new DeploymentException("Neither servlet class nor jsp file is set for " + servletName);
        }
        if (null != previousServlet) {
            servletData.setReferencePattern("Previous", previousServlet);
        }
        servletData.setReferencePattern("JettyServletRegistration", webModuleName);
        servletData.setAttribute("servletName", (Object)servletName);
        ParamValueType[] initParamArray = servletType.getInitParamArray();
        for (int j = 0; j < initParamArray.length; ++j) {
            ParamValueType paramValueType = initParamArray[j];
            initParams.put(paramValueType.getParamName().getStringValue().trim(), paramValueType.getParamValue().getStringValue().trim());
        }
        servletData.setAttribute("initParams", initParams);
        if (servletType.isSetLoadOnStartup()) {
            Integer loadOnStartup = new Integer(servletType.getLoadOnStartup().getBigIntegerValue().intValue());
            servletData.setAttribute("loadOnStartup", (Object)loadOnStartup);
        }
        servletData.setAttribute("servletMappings", (Object)((mappings = (Set)servletMappings.get(servletName)) == null ? Collections.EMPTY_SET : mappings));
        if (servletType.isSetRunAs()) {
            servletData.setAttribute("runAsRole", (Object)servletType.getRunAs().getRoleName().getStringValue().trim());
        }
        this.processRoleRefPermissions(servletType, securityRoles, rolePermissions);
        try {
            moduleContext.addGBean(servletData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add servlet gbean to context", (Throwable)e);
        }
        return servletAbstractName;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !JettyModuleBuilder.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)JettyModuleBuilder.class);
        JETTY_NAMESPACE = JettyWebAppDocument.type.getDocumentElementName().getNamespaceURI();
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)JettyModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultSessionTimeoutSeconds", Integer.class, true, true);
        infoBuilder.addAttribute("defaultWelcomeFiles", List.class, true, true);
        infoBuilder.addAttribute("jettyContainerObjectName", AbstractNameQuery.class, true, true);
        infoBuilder.addReference("DefaultServlets", JettyDefaultServletHolder.class, "ServletTemplate");
        infoBuilder.addReference("DefaultFilters", Object.class);
        infoBuilder.addReference("DefaultFilterMappings", Object.class);
        infoBuilder.addReference("PojoWebServiceTemplate", Object.class, "ServletWebServiceTemplate");
        infoBuilder.addReference("WebServiceBuilder", WebServiceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ClusteringBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("SecurityBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("NamingBuilders", NamingBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ResourceEnvironmentSetter", ResourceEnvironmentSetter.class, "ModuleBuilder");
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "defaultSessionTimeoutSeconds", "defaultWelcomeFiles", "jettyContainerObjectName", "DefaultServlets", "DefaultFilters", "DefaultFilterMappings", "PojoWebServiceTemplate", "WebServiceBuilder", "ClusteringBuilders", "SecurityBuilders", "ServiceBuilders", "NamingBuilders", "ResourceEnvironmentSetter", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    static class StartupOrderComparator
    implements Comparator {
        StartupOrderComparator() {
        }

        public int compare(Object o1, Object o2) {
            ServletType s1 = (ServletType)o1;
            ServletType s2 = (ServletType)o2;
            if (!s1.isSetLoadOnStartup() && !s2.isSetLoadOnStartup()) {
                return s1.equals(s2) ? 0 : s1.getServletName().getStringValue().trim().compareTo(s2.getServletName().getStringValue().trim());
            }
            if (s1.isSetLoadOnStartup() && !s2.isSetLoadOnStartup()) {
                return -1;
            }
            if (!s1.isSetLoadOnStartup() && s2.isSetLoadOnStartup()) {
                return 1;
            }
            int comp = s1.getLoadOnStartup().getBigIntegerValue().compareTo(s2.getLoadOnStartup().getBigIntegerValue());
            if (comp == 0) {
                return s1.getServletName().getStringValue().trim().compareTo(s2.getServletName().getStringValue().trim());
            }
            return comp;
        }
    }
}

