/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.handler;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import org.apache.geronimo.xbeans.javaee.HandlerChainType;
import org.apache.geronimo.xbeans.javaee.HandlerChainsDocument;
import org.apache.geronimo.xbeans.javaee.HandlerChainsType;
import org.apache.geronimo.xbeans.javaee.PortComponentHandlerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandlerChainBuilder {
    private static final Logger log = LoggerFactory.getLogger(AnnotationHandlerChainBuilder.class);

    public List<Handler> buildHandlerChainFromClass(Class<?> clz, List<Handler> existingHandlers) {
        log.debug("building handler chain");
        HandlerChainAnnotation hcAnn = this.findHandlerChainAnnotation(clz, true);
        ArrayList<Object> chain = null;
        if (hcAnn == null) {
            log.debug("no HandlerChain annotation on " + clz);
            chain = new ArrayList<Handler>();
        } else {
            hcAnn.validate();
            try {
                URL handlerFileURL = clz.getResource(hcAnn.getFileName());
                HandlerChainsType handlerChainsType = HandlerChainsDocument.Factory.parse((URL)handlerFileURL).getHandlerChains();
                if (null == handlerChainsType || handlerChainsType.getHandlerChainArray() == null) {
                    throw new WebServiceException("Chain not specified");
                }
                chain = new ArrayList();
                for (HandlerChainType hc : handlerChainsType.getHandlerChainArray()) {
                    chain.addAll(this.buildHandlerChain(hc, clz.getClassLoader()));
                }
            }
            catch (Exception e) {
                throw new WebServiceException("Chain not specified", (Throwable)e);
            }
        }
        assert (chain != null);
        if (existingHandlers != null) {
            chain.addAll(existingHandlers);
        }
        return this.sortHandlers(chain);
    }

    public List<Handler> buildHandlerChainFromClass(Class<?> clz) {
        return this.buildHandlerChainFromClass(clz, null);
    }

    private HandlerChainAnnotation findHandlerChainAnnotation(Class<?> clz, boolean searchSEI) {
        if (log.isDebugEnabled()) {
            log.debug("Checking for HandlerChain annotation on " + clz.getName());
        }
        HandlerChainAnnotation hcAnn = null;
        HandlerChain ann = clz.getAnnotation(HandlerChain.class);
        if (ann == null) {
            WebService ws;
            if (searchSEI && (ws = clz.getAnnotation(WebService.class)) != null && ws.endpointInterface() != null && ws.endpointInterface().trim().length() > 0) {
                String seiClassName = ws.endpointInterface().trim();
                Class<?> seiClass = null;
                try {
                    seiClass = clz.getClassLoader().loadClass(seiClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new WebServiceException("Failed to load SEI class: " + seiClassName, (Throwable)e);
                }
                hcAnn = this.findHandlerChainAnnotation(seiClass, false);
            }
            if (hcAnn == null) {
                for (Class<?> iface : clz.getInterfaces()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Checking for HandlerChain annotation on " + iface.getName());
                    }
                    if ((ann = iface.getAnnotation(HandlerChain.class)) == null) continue;
                    hcAnn = new HandlerChainAnnotation(ann, iface);
                    break;
                }
            }
        } else {
            hcAnn = new HandlerChainAnnotation(ann, clz);
        }
        return hcAnn;
    }

    protected List<Handler> buildHandlerChain(HandlerChainType hc, ClassLoader classLoader) {
        ArrayList<Handler> handlerChain = new ArrayList<Handler>();
        for (PortComponentHandlerType ht : hc.getHandlerArray()) {
            try {
                log.debug("loading handler :" + this.trimString(ht.getHandlerName().getStringValue()));
                Class<Handler> handlerClass = Class.forName(this.trimString(ht.getHandlerClass().getStringValue()), true, classLoader).asSubclass(Handler.class);
                Handler handler = handlerClass.newInstance();
                log.debug("adding handler to chain: " + handler);
                handlerChain.add(handler);
            }
            catch (Exception e) {
                throw new WebServiceException("Failed to instantiate handler", (Throwable)e);
            }
        }
        return handlerChain;
    }

    private String trimString(String str) {
        return str != null ? str.trim() : null;
    }

    public List<Handler> sortHandlers(List<Handler> handlers) {
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<Handler> protocolHandlers = new ArrayList<Handler>();
        for (Handler handler : handlers) {
            if (handler instanceof LogicalHandler) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            protocolHandlers.add(handler);
        }
        ArrayList<Handler> sortedHandlers = new ArrayList<Handler>();
        sortedHandlers.addAll(logicalHandlers);
        sortedHandlers.addAll(protocolHandlers);
        return sortedHandlers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerChainAnnotation {
        private final Class<?> declaringClass;
        private final HandlerChain ann;

        HandlerChainAnnotation(HandlerChain hc, Class<?> clz) {
            this.ann = hc;
            this.declaringClass = clz;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public String getFileName() {
            return this.ann.file();
        }

        public void validate() {
            if (null == this.ann.file() || "".equals(this.ann.file())) {
                throw new WebServiceException("@HandlerChain annotation does not contain a file name or url.");
            }
        }

        public String toString() {
            return "[" + this.declaringClass + "," + this.ann + "]";
        }
    }
}

