/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder.wsdl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.kernel.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsdlGeneratorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WsdlGeneratorUtils.class);

    public static void getModuleClasspath(Module module, DeploymentContext context, StringBuilder classPathBuilder) throws Exception {
        LinkedHashSet<URL> jars = new LinkedHashSet<URL>();
        WsdlGeneratorUtils.getModuleClasspath(module, context, jars);
        WsdlGeneratorUtils.buildClasspath(jars, classPathBuilder);
    }

    public static void getModuleClasspath(Module module, DeploymentContext context, LinkedHashSet<URL> classpath) throws Exception {
        WsdlGeneratorUtils.getModuleClasspath((DeploymentContext)module.getEarContext(), classpath);
        if (module.getRootEarContext() != module.getEarContext()) {
            WsdlGeneratorUtils.getModuleClasspath((DeploymentContext)module.getRootEarContext(), classpath);
        }
    }

    public static void getModuleClasspath(DeploymentContext deploymentContext, LinkedHashSet<URL> classpath) throws Exception {
        File configurationBaseDir = deploymentContext.getBaseDir();
        if (deploymentContext.getBundleClassPath() == null || deploymentContext.getBundleClassPath().isEmpty()) {
            classpath.add(configurationBaseDir.toURI().toURL());
        } else {
            for (String bundleClassPath : deploymentContext.getBundleClassPath()) {
                classpath.add(new File(configurationBaseDir, bundleClassPath).toURI().toURL());
            }
        }
    }

    public static void getModuleClasspath(Configuration configuration, LinkedHashSet<URL> classpath) throws Exception {
    }

    public static Set<URL> getClassLoaderClasspath(ClassLoader loader) {
        LinkedHashSet<URL> jars = new LinkedHashSet<URL>();
        WsdlGeneratorUtils.getClassLoaderClasspath(loader, jars);
        return jars;
    }

    public static void getClassLoaderClasspath(ClassLoader loader, LinkedHashSet<URL> classpath) {
        if (loader == null || loader == ClassLoader.getSystemClassLoader()) {
            return;
        }
        if (loader instanceof URLClassLoader) {
            URLClassLoader cl = (URLClassLoader)loader;
            WsdlGeneratorUtils.getClassLoaderClasspath(cl.getParent(), classpath);
            for (URL u : cl.getURLs()) {
                classpath.add(u);
            }
        } else {
            WsdlGeneratorUtils.getClassLoaderClasspath(loader.getParent(), classpath);
        }
    }

    public static String buildClasspath(Set<URL> files) {
        StringBuilder classpath = new StringBuilder();
        WsdlGeneratorUtils.buildClasspath(files, classpath);
        return classpath.toString();
    }

    public static void buildClasspath(Set<URL> files, StringBuilder classpath) {
        for (URL url : files) {
            if (!"file".equals(url.getProtocol())) continue;
            String path = WsdlGeneratorUtils.toFileName(url);
            classpath.append(path);
            classpath.append(File.pathSeparator);
        }
    }

    public static String getClasspath(ClassLoader loader) {
        Set<URL> jars = WsdlGeneratorUtils.getClassLoaderClasspath(loader);
        return WsdlGeneratorUtils.buildClasspath(jars);
    }

    public static File toFile(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = WsdlGeneratorUtils.toFileName(url);
        return new File(filename);
    }

    public static String toFileName(URL url) {
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return filename;
    }

    public static File createTempDirectory(File baseDir) throws IOException {
        String dirName;
        File dir;
        Random rand = new Random();
        while ((dir = new File(baseDir, dirName = String.valueOf(Math.abs(rand.nextInt())))).exists()) {
        }
        if (!dir.mkdir()) {
            throw new IOException("Failed to create temporary directory: " + dir);
        }
        return dir;
    }

    private static File[] getWsdlFiles(File baseDir) {
        File[] files = baseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".wsdl");
            }
        });
        return files;
    }

    public static File findWsdlFile(File baseDir, String serviceName) {
        File[] files = WsdlGeneratorUtils.getWsdlFiles(baseDir);
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        if (serviceName != null) {
            String wsdlFileName = serviceName + ".wsdl";
            for (File file : files) {
                if (!wsdlFileName.equalsIgnoreCase(file.getName())) continue;
                return file;
            }
            return null;
        }
        return null;
    }

    public static String getRelativeNameOrURL(File baseDir, File file) {
        String basePath = baseDir.getAbsolutePath();
        String path = file.getAbsolutePath();
        if (path.startsWith(basePath)) {
            return baseDir.toURI().relativize(file.toURI()).toString();
        }
        return file.toURI().toString();
    }

    public static boolean execJava(List<String> arguments, long timeout) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        String java = javaHome + File.separator + "bin" + File.separator + "java";
        cmd.add(java);
        cmd.addAll(arguments);
        return WsdlGeneratorUtils.exec(cmd, timeout);
    }

    public static boolean exec(List<String> cmd, long timeout) throws Exception {
        LOG.debug("Executing process: {}", cmd);
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        return WsdlGeneratorUtils.waitFor(process, timeout);
    }

    private static boolean waitFor(Process process, long timeout) throws Exception {
        CaptureOutputThread outputThread = new CaptureOutputThread(process.getInputStream());
        outputThread.start();
        for (long sleepTime = 0L; sleepTime < timeout; sleepTime += 2000L) {
            try {
                int errorCode = process.exitValue();
                if (errorCode == 0) {
                    System.err.println("Process output: {}" + outputThread.getOutput());
                    return true;
                }
                System.err.println("Process output: {}" + outputThread.getOutput());
                return false;
            }
            catch (IllegalThreadStateException e) {
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException ee) {
                    process.destroy();
                    throw new Exception("Process was interrupted");
                }
            }
        }
        process.destroy();
        LOG.error("Process timed out: {}", (Object)outputThread.getOutput());
        throw new Exception("Process timed out");
    }

    private static class CaptureOutputThread
    extends Thread {
        private InputStream in;
        private ByteArrayOutputStream out;

        public CaptureOutputThread(InputStream in) {
            this.in = in;
            this.out = new ByteArrayOutputStream();
        }

        public String getOutput() {
            try {
                this.join(10000L);
                if (this.isAlive()) {
                    this.interrupt();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            byte[] arr = this.out.toByteArray();
            String output = new String(arr, 0, arr.length);
            return output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CaptureOutputThread.copyAll(this.in, this.out);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException ee) {}
                try {
                    this.in.close();
                }
                catch (IOException ee) {}
            }
        }

        private static void copyAll(InputStream in, OutputStream out) throws IOException {
            int count;
            byte[] buffer = new byte[4096];
            while ((count = in.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
            out.flush();
        }
    }
}

