/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.AbstractWARWebServiceFinder;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.ServletMapping;
import org.apache.openejb.jee.WebApp;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWARWebServiceFinder
extends AbstractWARWebServiceFinder {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleWARWebServiceFinder.class);

    @Override
    public Map<String, PortInfo> discoverWebServices(WebModule module, Map<String, String> correctedPortLocations) throws DeploymentException {
        HashMap<String, PortInfo> servletNamePortInfoMap = new HashMap<String, PortInfo>();
        Bundle bundle = module.getEarContext().getDeploymentBundle();
        WebApp webApp = (WebApp)module.getSpecDD();
        List servletTypes = webApp.getServlet();
        Set<String> ignoredEJBWebServiceClassNames = this.getEJBWebServiceClassNames((Module)module);
        if (webApp.getServlet().size() == 0) {
            List<Class<?>> services = this.discoverWebServices(module);
            String string = module.getContextRoot();
            for (Class<?> service : services) {
                if (!JAXWSUtils.isWebService(service)) continue;
                if (ignoredEJBWebServiceClassNames.contains(service.getName())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Web service " + service.getClass().getName() + "  is ignored as it is also an EJB, it will exposed as an EJB Web Service ");
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Discovered POJO Web Service: " + service.getName());
                }
                Servlet servlet = new Servlet();
                servlet.setServletName(service.getName());
                servlet.setServletClass(service.getName());
                webApp.getServlet().add(servlet);
                String location = "/" + JAXWSUtils.getServiceName(service);
                ServletMapping servletMapping = new ServletMapping();
                servletMapping.setServletName(service.getName());
                servletMapping.getUrlPattern().add(location);
                PortInfo portInfo = new PortInfo();
                portInfo.setLocation(string + location);
                servletNamePortInfoMap.put(service.getName(), portInfo);
            }
        } else {
            String servletName;
            for (Servlet servlet : servletTypes) {
                servletName = servlet.getServletName().trim();
                if (servlet.getServletClass() == null) continue;
                String servletClassName = servlet.getServletClass().trim();
                try {
                    Class servletClass = bundle.loadClass(servletClassName);
                    if (!JAXWSUtils.isWebService((Class)servletClass)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found POJO Web Service: " + servletName);
                    }
                    PortInfo portInfo = new PortInfo();
                    servletNamePortInfoMap.put(servletName, portInfo);
                }
                catch (Exception e) {
                    throw new DeploymentException("Failed to load servlet class " + servletClassName + " from bundle " + bundle, (Throwable)e);
                }
            }
            for (Map.Entry entry : servletNamePortInfoMap.entrySet()) {
                servletName = (String)entry.getKey();
                PortInfo portInfo = (PortInfo)entry.getValue();
                String location = correctedPortLocations.get(servletName);
                if (location == null) continue;
                portInfo.setLocation(location);
            }
        }
        return servletNamePortInfoMap;
    }
}

