/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableBundle;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.jaxws.builder.WebServiceFinder;
import org.apache.geronimo.jaxws.handler.AnnotationHandlerChainFinder;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.kernel.util.NestedJarFile;
import org.apache.geronimo.kernel.util.UnpackedJarFile;
import org.apache.xbean.classloader.JarFileClassLoader;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWARWebServiceFinder
implements WebServiceFinder<WebModule> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWARWebServiceFinder.class);
    protected AnnotationHandlerChainFinder annotationHandlerChainFinder = new AnnotationHandlerChainFinder();

    protected Set<String> getEJBWebServiceClassNames(Module module) {
        if (module.getModules().size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> ejbWebServiceClassNames = new HashSet<String>();
        for (Module subModule : module.getModules()) {
            if (subModule.getType() != ConfigurationModuleType.EJB) continue;
            Set currentEJBWebServiceClassNames = (Set)subModule.getSharedContext().get("EJB_WEB_SERVICE_CLASS_NAMES");
            if (ejbWebServiceClassNames == null) continue;
            ejbWebServiceClassNames.addAll(currentEJBWebServiceClassNames);
        }
        return ejbWebServiceClassNames;
    }

    protected List<Class<?>> discoverWebServices(WebModule module) throws DeploymentException {
        Deployable deployable = module.getDeployable();
        if (deployable instanceof DeployableJarFile) {
            return this.discoverWebServices(((DeployableJarFile)deployable).getJarFile(), AbstractWARWebServiceFinder.class.getClassLoader());
        }
        if (deployable instanceof DeployableBundle) {
            return this.discoverWebServices(((DeployableBundle)deployable).getBundle());
        }
        throw new DeploymentException("Unsupported deployable: " + deployable.getClass());
    }

    private List<Class<?>> discoverWebServices(Bundle bundle) throws DeploymentException {
        logger.debug("Discovering web service classes");
        ServiceReference sr = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)bundle.getBundleContext().getService(sr);
        try {
            BundleAnnotationFinder classFinder = new BundleAnnotationFinder(packageAdmin, bundle);
            ArrayList classes = new ArrayList();
            classes.addAll(classFinder.findAnnotatedClasses(WebService.class));
            classes.addAll(classFinder.findAnnotatedClasses(WebServiceProvider.class));
            ArrayList arrayList = classes;
            return arrayList;
        }
        catch (Exception e) {
            throw new DeploymentException("Error scanning for web service annotations in bundle", (Throwable)e);
        }
        finally {
            bundle.getBundleContext().ungetService(sr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private List<Class<?>> discoverWebServices(JarFile moduleFile, ClassLoader parentClassLoader) throws DeploymentException {
        File baseDir;
        logger.debug("Discovering web service classes");
        File tmpDir = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (moduleFile instanceof UnpackedJarFile) {
            baseDir = ((UnpackedJarFile)moduleFile).getBaseDir();
        } else if (moduleFile instanceof NestedJarFile && ((NestedJarFile)moduleFile).isUnpacked()) {
            baseDir = new File(moduleFile.getName());
        } else {
            try {
                tmpDir = FileUtils.createTempDir();
                JarFile module = new JarFile(moduleFile.getName());
                JarUtils.unzipToDirectory((ZipFile)module, (File)tmpDir);
            }
            catch (IOException e) {
                if (tmpDir != null) {
                    FileUtils.recursiveDelete((File)tmpDir);
                }
                throw new DeploymentException("Failed to expand the module archive", (Throwable)e);
            }
            baseDir = tmpDir;
        }
        Enumeration<JarEntry> jarEnum = moduleFile.entries();
        while (jarEnum.hasMoreElements()) {
            JarEntry entry = jarEnum.nextElement();
            String name = entry.getName();
            if (name.equals("WEB-INF/classes/")) {
                File classesDir = new File(baseDir, "WEB-INF/classes/");
                try {
                    urlList.add(0, classesDir.toURI().toURL());
                }
                catch (MalformedURLException e) {}
                continue;
            }
            if (!name.startsWith("WEB-INF/lib/") || !name.endsWith(".jar")) continue;
            File jarFile = new File(baseDir, name);
            try {
                urlList.add(jarFile.toURI().toURL());
            }
            catch (MalformedURLException e) {}
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        JarFileClassLoader tempClassLoader = null;
        try {
            tempClassLoader = new JarFileClassLoader(null, urls, parentClassLoader);
            ArrayList classes = new ArrayList();
            for (URL url : urlList) {
                try {
                    ClassFinder classFinder = new ClassFinder((ClassLoader)tempClassLoader, Collections.singletonList(url));
                    classes.addAll(classFinder.findAnnotatedClasses(WebService.class));
                    classes.addAll(classFinder.findAnnotatedClasses(WebServiceProvider.class));
                }
                catch (Exception e) {
                    logger.warn("Fail to search Web Service in jar [" + url + "]", (Throwable)e);
                }
            }
            ArrayList arrayList = classes;
            return arrayList;
        }
        finally {
            if (tempClassLoader != null) {
                tempClassLoader.destroy();
            }
            if (tmpDir != null) {
                FileUtils.recursiveDelete((File)tmpDir);
            }
        }
    }
}

