/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentConfigurationManager;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.JAXWSTools;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationResolver;
import org.apache.geronimo.kernel.config.NoSuchConfigException;

public class WsdlGenerator {
    private static final Log LOG = LogFactory.getLog(WsdlGenerator.class);
    private static final String FORK_WSGEN_PROPERTY = "org.apache.geronimo.jaxws.wsgen.fork";
    private static final String FORK_TIMEOUT_WSGEN_PROPERTY = "org.apache.geronimo.jaxws.wsgen.fork.timeout";
    private static final long FORK_POLL_FREQUENCY = 2000L;
    private QName wsdlService;
    private QName wsdlPort;
    private boolean forkWsgen = WsdlGenerator.getForkWsgen();
    private long forkTimeout = WsdlGenerator.getForTimeout();
    private JAXWSTools jaxwsTools = new JAXWSTools();

    private static boolean getForkWsgen() {
        String value = System.getProperty(FORK_WSGEN_PROPERTY);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return false;
        }
        return (osName = osName.toLowerCase()).indexOf("windows") != -1;
    }

    private static long getForTimeout() {
        String value = System.getProperty(FORK_TIMEOUT_WSGEN_PROPERTY);
        if (value != null) {
            return Long.parseLong(value);
        }
        return 60000L;
    }

    public void setSunSAAJ() {
        this.jaxwsTools.setUseSunSAAJ();
    }

    public void setAxis2SAAJ() {
        this.jaxwsTools.setUseAxis2SAAJ();
    }

    public void setWsdlService(QName name) {
        this.wsdlService = name;
    }

    public QName getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlPort(QName port) {
        this.wsdlPort = port;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    private URL[] getWsgenClasspath(DeploymentContext context) throws Exception {
        DeploymentConfigurationManager cm = (DeploymentConfigurationManager)context.getConfigurationManager();
        Collection repositories = cm.getRepositories();
        File[] jars = this.jaxwsTools.getClasspath(repositories);
        return JAXWSTools.toURL(jars);
    }

    private static void getModuleClasspath(Module module, DeploymentContext context, StringBuilder classpath) throws DeploymentException {
        WsdlGenerator.getModuleClasspath(classpath, (DeploymentContext)module.getEarContext());
        if (module.getRootEarContext() != module.getEarContext()) {
            WsdlGenerator.getModuleClasspath(classpath, (DeploymentContext)module.getRootEarContext());
        }
    }

    private static void getModuleClasspath(StringBuilder classpath, DeploymentContext deploymentContext) throws DeploymentException {
        Configuration configuration = deploymentContext.getConfiguration();
        ConfigurationResolver resolver = configuration.getConfigurationResolver();
        List moduleClassPath = configuration.getClassPath();
        for (String pattern : moduleClassPath) {
            try {
                Set files = resolver.resolve(pattern);
                for (URL url : files) {
                    String path = WsdlGenerator.toFileName(url);
                    classpath.append(path).append(File.pathSeparator);
                }
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Could not resolve pattern: " + pattern, (Throwable)e);
            }
            catch (NoSuchConfigException e) {
                throw new DeploymentException("Could not resolve pattern: " + pattern, (Throwable)e);
            }
        }
    }

    private static File toFile(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = WsdlGenerator.toFileName(url);
        return new File(filename);
    }

    private static String toFileName(URL url) {
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return filename;
    }

    private String[] buildArguments(String sei, String classPath, File moduleBaseDir, PortInfo portInfo) {
        QName portName;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-cp");
        arguments.add(classPath);
        arguments.add("-keep");
        arguments.add("-wsdl");
        arguments.add("-d");
        arguments.add(moduleBaseDir.getAbsolutePath());
        QName serviceName = this.getWsdlService();
        if (serviceName != null) {
            arguments.add("-servicename");
            arguments.add(serviceName.toString());
        }
        if ((portName = this.getWsdlPort()) != null) {
            arguments.add("-portname");
            arguments.add(portName.toString());
        }
        arguments.add(sei);
        return arguments.toArray(new String[0]);
    }

    private File getFirstWsdlFile(File baseDir) throws IOException {
        LOG.debug((Object)("Looking for service wsdl file in " + baseDir.getAbsolutePath()));
        File[] files = baseDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".wsdl");
            }
        });
        if (files.length == 1) {
            return files[0];
        }
        return null;
    }

    private File findWsdlFile(File baseDir, PortInfo portInfo) throws IOException {
        QName serviceName = this.getWsdlService();
        if (serviceName != null) {
            File wsdlFile;
            String wsdlFileName = serviceName.getLocalPart() + ".wsdl";
            if (Character.isLowerCase(wsdlFileName.charAt(0))) {
                wsdlFileName = Character.toUpperCase(wsdlFileName.charAt(0)) + wsdlFileName.substring(1);
            }
            if ((wsdlFile = new File(baseDir, wsdlFileName)).exists()) {
                return wsdlFile;
            }
            return this.getFirstWsdlFile(baseDir);
        }
        return this.getFirstWsdlFile(baseDir);
    }

    private static String getRelativeNameOrURL(File baseDir, File file) {
        String basePath = baseDir.getAbsolutePath();
        String path = file.getAbsolutePath();
        if (path.startsWith(basePath)) {
            if (File.separatorChar == path.charAt(basePath.length())) {
                return path.substring(basePath.length() + 1);
            }
            return path.substring(basePath.length());
        }
        return file.toURI().toString();
    }

    private static File createTempDirectory(File baseDir) throws IOException {
        String dirName;
        File dir;
        Random rand = new Random();
        while ((dir = new File(baseDir, dirName = String.valueOf(Math.abs(rand.nextInt())))).exists()) {
        }
        if (!dir.mkdir()) {
            throw new IOException("Failed to create temporary directory: " + dir);
        }
        return dir;
    }

    public String generateWsdl(Module module, String serviceClass, DeploymentContext context, PortInfo portInfo) throws DeploymentException {
        URL[] urls;
        File baseDir;
        File moduleBase = module.getEarContext().getBaseDir();
        File moduleBaseDir = moduleBase.isFile() ? moduleBase.getParentFile() : moduleBase;
        try {
            baseDir = WsdlGenerator.createTempDirectory(moduleBaseDir);
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
        StringBuilder classPath = new StringBuilder();
        try {
            urls = this.getWsgenClasspath(context);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to generate the wsdl file using wsgen: unable to get the location of the required artifact(s).", (Throwable)e);
        }
        if (urls != null && urls.length > 0) {
            for (URL url : urls) {
                classPath.append(WsdlGenerator.toFile(url).getAbsolutePath()).append(File.pathSeparator);
            }
        }
        WsdlGenerator.getModuleClasspath(module, context, classPath);
        String[] arguments = this.buildArguments(serviceClass, classPath.toString(), baseDir, portInfo);
        try {
            boolean result = false;
            result = this.forkWsgen ? this.forkWsgen(classPath, arguments) : this.invokeWsgen(urls, arguments);
            if (result) {
                File wsdlFile = this.findWsdlFile(baseDir, portInfo);
                if (wsdlFile == null) {
                    throw new DeploymentException("Unable to find the service wsdl file");
                }
                return WsdlGenerator.getRelativeNameOrURL(moduleBase, wsdlFile);
            }
            throw new DeploymentException("wsgen failed");
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to generate the wsdl file using wsgen.", (Throwable)e);
        }
    }

    private boolean invokeWsgen(URL[] jars, String[] arguments) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean rs = this.jaxwsTools.invokeWsgen(jars, os, arguments);
        os.close();
        if (LOG.isDebugEnabled()) {
            byte[] arr = os.toByteArray();
            String wsgenOutput = new String(arr, 0, arr.length);
            LOG.debug((Object)("wsgen output: " + wsgenOutput));
        }
        return rs;
    }

    private boolean forkWsgen(StringBuilder classPath, String[] arguments) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        String java = javaHome + File.separator + "bin" + File.separator + "java";
        cmd.add(java);
        cmd.add("-classpath");
        cmd.add(classPath.toString());
        cmd.add("com.sun.tools.ws.WsGen");
        cmd.addAll(Arrays.asList(arguments));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing wsgen: " + cmd));
        }
        String[] cmdArray = cmd.toArray(new String[0]);
        Process process = Runtime.getRuntime().exec(cmdArray);
        int errorCode = this.waitFor(process);
        if (errorCode == 0) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("wsgen error code: " + errorCode));
        }
        return false;
    }

    private int waitFor(Process process) throws DeploymentException {
        for (long sleepTime = 0L; sleepTime < this.forkTimeout; sleepTime += 2000L) {
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException ee) {
                    process.destroy();
                    throw new DeploymentException("wsgen interrupted");
                }
            }
        }
        process.destroy();
        throw new DeploymentException("wsgen timed out");
    }
}

