/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceContext;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.annotation.Injection;
import org.apache.xbean.finder.ClassFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceContextAnnotationHelper {
    public static final String RELATIVE_JNDI_NAME = "env/WebServiceContext";
    public static final String ABSOLUTE_JNDI_NAME = "java:comp/env/WebServiceContext";

    public static void addWebServiceContextInjections(Holder holder, ClassFinder finder) {
        List fields = finder.findAnnotatedFields(Resource.class);
        for (Field field : fields) {
            Resource resource = field.getAnnotation(Resource.class);
            Class<?> type = WebServiceContextAnnotationHelper.getInjectionType(resource.type(), null, field);
            if (WebServiceContext.class != type) continue;
            holder.addInjection(field.getDeclaringClass().getName(), new Injection(field.getDeclaringClass().getName(), WebServiceContextAnnotationHelper.getInjectionName(null, field), ABSOLUTE_JNDI_NAME));
        }
        List methods = finder.findAnnotatedMethods(Resource.class);
        for (Method method : methods) {
            Resource resource = method.getAnnotation(Resource.class);
            Class<?> type = WebServiceContextAnnotationHelper.getInjectionType(resource.type(), method, null);
            if (WebServiceContext.class != type) continue;
            holder.addInjection(method.getDeclaringClass().getName(), new Injection(method.getDeclaringClass().getName(), WebServiceContextAnnotationHelper.getInjectionName(method, null), ABSOLUTE_JNDI_NAME));
        }
    }

    private static Class<?> getInjectionType(Class<?> type, Method method, Field field) {
        if (type == null || Object.class == type) {
            if (field != null) {
                return field.getType();
            }
            if (method != null) {
                return method.getParameterTypes()[0];
            }
            throw new IllegalArgumentException("You must supply exactly one of Method, Field");
        }
        return type;
    }

    private static String getInjectionName(Method method, Field field) {
        if (method != null) {
            String injectionJavaType = method.getName().substring(3);
            StringBuilder stringBuilder = new StringBuilder(injectionJavaType);
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
            return stringBuilder.toString();
        }
        if (field != null) {
            return field.getName();
        }
        throw new IllegalArgumentException("You must supply exactly one of Method, Field");
    }
}

