/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GShellCommandRegistration {
    private static String INDENT = "    ";

    private static boolean updateClassworlds(File classworldsFile, String classworlsTest, String classworlds) throws Exception {
        boolean updated = GShellCommandRegistration.checkClassworlds(classworldsFile, classworlsTest);
        if (updated) {
            return false;
        }
        File tmpFile = new File(classworldsFile.getAbsolutePath() + ".tmp");
        PrintWriter writer = new PrintWriter(new FileWriter(tmpFile));
        BufferedReader reader = new BufferedReader(new FileReader(classworldsFile));
        boolean inGShellSection = false;
        String line = null;
        while ((line = reader.readLine()) != null) {
            writer.println(line);
            if (line.startsWith("[gshell]")) {
                inGShellSection = true;
                continue;
            }
            if (line.startsWith("[")) {
                inGShellSection = false;
                continue;
            }
            if (!inGShellSection || line.startsWith(INDENT)) continue;
        }
        if (inGShellSection) {
            writer.println(INDENT + classworlds);
        }
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        reader.close();
        writer.close();
        GShellCommandRegistration.switchFile(tmpFile, classworldsFile);
        return true;
    }

    private static boolean checkClassworlds(File classworldsFile, String classworlsTest) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(classworldsFile));
        String line = null;
        boolean matches = false;
        while ((line = reader.readLine()) != null) {
            if (!line.matches(classworlsTest)) continue;
            matches = true;
            break;
        }
        reader.close();
        return matches;
    }

    private static boolean updateLayout(File layoutFile, String layoutTest, String layout) throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        Document layoutDocument = domFactory.newDocumentBuilder().parse(layoutFile);
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xPath = xpathFactory.newXPath();
        Boolean updated = (Boolean)xPath.evaluate(layoutTest, layoutDocument, XPathConstants.BOOLEAN);
        if (updated.booleanValue()) {
            return false;
        }
        Document doc = domFactory.newDocumentBuilder().parse(new InputSource(new StringReader(layout)));
        Element layoutElement = layoutDocument.getDocumentElement();
        NodeList nodes = layoutElement.getElementsByTagName("nodes");
        Node n = layoutDocument.importNode(doc.getDocumentElement(), true);
        nodes.item(0).appendChild(n);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(layoutDocument);
        File tmpFile = new File(layoutFile.getAbsolutePath() + ".tmp");
        FileOutputStream out = new FileOutputStream(tmpFile);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        out.close();
        GShellCommandRegistration.switchFile(tmpFile, layoutFile);
        return true;
    }

    private static void switchFile(File tmpFile, File realFile) {
        realFile.delete();
        if (!tmpFile.renameTo(realFile)) {
            throw new RuntimeException("Failed to rename " + tmpFile + " to " + realFile);
        }
    }

    public static void main(String[] args) throws Exception {
        File classworldsFile;
        File layoutFile;
        if (args.length != 2) {
            throw new Exception("Syntax: GShellCommandRegistration <geronimo_home> <properties file>");
        }
        String baseDir = args[0];
        String propsFile = args[1];
        ClassLoader loader = GShellCommandRegistration.class.getClassLoader();
        InputStream in = loader.getResourceAsStream(propsFile);
        if (in == null) {
            throw new Exception("Failed to load properties file: " + propsFile);
        }
        Properties p = new Properties();
        p.load(in);
        String layoutXPathTest = p.getProperty("layoutXPathTest");
        String layoutEntry = p.getProperty("layoutEntry");
        if (layoutXPathTest != null && layoutEntry != null && GShellCommandRegistration.updateLayout(layoutFile = new File(baseDir, "etc/layout.xml"), layoutXPathTest, layoutEntry)) {
            System.out.println("Registered commands in layout.xml");
        }
        String classworldsRegExTest = p.getProperty("classworldsRegExTest");
        String classworldsEntry = p.getProperty("classworldsEntry");
        if (classworldsRegExTest != null && classworldsEntry != null && GShellCommandRegistration.updateClassworlds(classworldsFile = new File(baseDir, "etc/gsh-classworlds.conf"), classworldsRegExTest, classworldsEntry)) {
            System.out.println("Updated gsh-classworlds.conf");
        }
    }
}

