/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jasper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;
import org.apache.geronimo.jasper.TldProvider;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.JarResource;
import org.apache.jasper.compiler.TldLocation;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.compiler.WebXml;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.jar.BundleJarFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoTldLocationsCache
extends TldLocationsCache {
    private static final Logger log = LoggerFactory.getLogger(GeronimoTldLocationsCache.class);
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_INF = "/WEB-INF/";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static final String JAR_EXT = ".jar";
    private static final String TLD_EXT = ".tld";
    private Hashtable<String, TldLocation> mappings;
    private boolean initialized;
    private ServletContext ctxt;

    public GeronimoTldLocationsCache(ServletContext ctxt) {
        super(ctxt);
        this.ctxt = ctxt;
        this.mappings = new Hashtable();
    }

    public static void setNoTldJars(String jarNames) {
    }

    public TldLocation getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return this.mappings.get(uri);
    }

    private void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        try {
            this.tldScanWebXml();
            this.tldScanResourcePaths(WEB_INF);
            Bundle bundle = BundleUtils.getContextBundle((boolean)true);
            if (bundle != null) {
                this.tldScanClassPath(bundle);
                this.tldScanGlobal(bundle);
            }
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new JasperException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanWebXml() throws Exception {
        WebXml webXml = null;
        try {
            webXml = new WebXml(this.ctxt);
            TreeNode webtld = null;
            webtld = new ParserUtils().parseXMLDocument(webXml.getSystemId(), webXml.getInputSource());
            TreeNode jspConfig = webtld.findChild("jsp-config");
            if (jspConfig != null) {
                webtld = jspConfig;
            }
            Iterator taglibs = webtld.findChildren("taglib");
            while (taglibs.hasNext()) {
                TreeNode taglib = (TreeNode)taglibs.next();
                String tagUri = null;
                String tagLoc = null;
                TreeNode child = taglib.findChild("taglib-uri");
                if (child != null) {
                    tagUri = child.getBody();
                }
                if ((child = taglib.findChild("taglib-location")) != null) {
                    tagLoc = child.getBody();
                }
                if (tagLoc == null) continue;
                if (GeronimoTldLocationsCache.uriType((String)tagLoc) == 2) {
                    tagLoc = WEB_INF + tagLoc;
                }
                TldLocation location = tagLoc.endsWith(JAR_EXT) ? new TldLocation("META-INF/taglib.tld", this.ctxt.getResource(tagLoc).toString()) : new TldLocation(tagLoc);
                this.mappings.put(tagUri, location);
            }
        }
        finally {
            if (webXml != null) {
                webXml.close();
            }
        }
    }

    private void tldScanResourcePaths(String startPath) throws Exception {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (!path.endsWith(TLD_EXT) && (path.startsWith(WEB_INF_LIB) || path.startsWith("/WEB-INF/classes/"))) continue;
                if (path.endsWith(TLD_EXT)) {
                    if (path.startsWith("/WEB-INF/tags/") && !path.endsWith("implicit.tld")) continue;
                    InputStream stream = this.ctxt.getResourceAsStream(path);
                    this.tldScanStream(stream, new TldLocation(path));
                    continue;
                }
                this.tldScanResourcePaths(path);
            }
        }
    }

    private void tldScanClassPath(Bundle bundle) throws Exception {
        ServiceReference reference = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)bundle.getBundleContext().getService(reference);
        BundleResourceFinder resourceFinder = new BundleResourceFinder(packageAdmin, bundle, "META-INF/", TLD_EXT);
        resourceFinder.find(new BundleResourceFinder.ResourceFinderCallback(){

            public void foundInDirectory(Bundle bundle, String basePath, URL url) throws Exception {
                GeronimoTldLocationsCache.this.tldScanStream(url, new TldLocation(url.getPath()));
            }

            public void foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
                URL jarURL = bundle.getEntry(jarName);
                GeronimoTldLocationsCache.this.tldScanStream(in, new TldLocation(entry.getName(), jarURL.toExternalForm()));
            }
        });
        bundle.getBundleContext().ungetService(reference);
    }

    private void tldScanGlobal(Bundle bundle) throws JasperException, IOException, InvalidSyntaxException {
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference[] references = bundleContext.getServiceReferences(TldProvider.class.getName(), null);
        if (references != null) {
            for (ServiceReference reference : references) {
                TldProvider provider = (TldProvider)bundleContext.getService(reference);
                for (TldProvider.TldEntry entry : provider.getTlds()) {
                    URL url = entry.getURL();
                    if (entry.getJarUrl() != null) {
                        this.tldScanStream(url, new TldLocation(entry.getName(), entry.getJarUrl().toExternalForm()));
                        continue;
                    }
                    this.tldScanStream(url, new TldLocation(entry.getName(), (JarResource)new BundleJarResource(entry.getBundle())));
                }
                bundleContext.ungetService(reference);
            }
        }
    }

    private void tldScanStream(URL url, TldLocation location) throws IOException {
        InputStream in = url.openStream();
        this.tldScanStream(in, location);
    }

    private void tldScanStream(InputStream stream, TldLocation location) throws IOException {
        String path = location.getJarResource() == null ? location.getName() : location.getJarResource().getUrl();
        try {
            String body;
            String uri = null;
            TreeNode tld = new ParserUtils().parseXMLDocument(path, stream);
            TreeNode uriNode = tld.findChild("uri");
            if (uriNode != null && (body = uriNode.getBody()) != null) {
                uri = body;
            }
            if (uri != null && this.mappings.get(uri) == null) {
                this.mappings.put(uri, location);
            }
        }
        catch (JasperException e) {
            throw new IOException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ignore) {}
        }
    }

    private static class BundleJarResource
    implements JarResource {
        private Bundle bundle;
        private URL url;

        public BundleJarResource(Bundle bundle) {
            this.bundle = bundle;
            this.url = bundle.getEntry("/");
        }

        public JarFile getJarFile() throws IOException {
            return new BundleJarFile(this.bundle);
        }

        public String getUrl() {
            return this.url.toExternalForm();
        }

        public URL getEntry(String name) {
            return this.bundle.getEntry(name);
        }
    }
}

