/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.jndi;

import java.util.LinkedHashSet;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.jndi.ApplicationJndi;
import org.apache.geronimo.j2ee.jndi.ContextSource;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.osgi.framework.Bundle;

@GBean
public class WebContextSource
implements ContextSource {
    private final Context context;

    public WebContextSource(@ParamAttribute(name="moduleContext") Map<String, Object> moduleContext, @ParamAttribute(name="componentContext") Map<String, Object> componentContext, @ParamReference(name="TransactionManager") TransactionManager transactionManager, @ParamReference(name="ApplicationJndi") ApplicationJndi applicationJndi, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle) throws NamingException {
        GeronimoUserTransaction userTransaction = new GeronimoUserTransaction(transactionManager);
        LinkedHashSet<Context> contexts = new LinkedHashSet<Context>(3);
        Context localCompContext = EnterpriseNamingContext.livenReferences(componentContext, (UserTransaction)userTransaction, (Kernel)kernel, (ClassLoader)classLoader, (Bundle)bundle, (String)"comp/");
        Context localModuleContext = EnterpriseNamingContext.livenReferences(moduleContext, null, (Kernel)kernel, (ClassLoader)classLoader, (Bundle)bundle, (String)"module/");
        contexts.add(localCompContext);
        contexts.add(localModuleContext);
        if (applicationJndi != null) {
            if (applicationJndi.getApplicationContext() != null) {
                contexts.add(applicationJndi.getApplicationContext());
            }
            if (applicationJndi.getGlobalContext() != null) {
                contexts.add((Context)applicationJndi.getGlobalContext());
            }
        }
        this.context = EnterpriseNamingContext.createEnterpriseNamingContext(contexts);
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

