/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import java.util.Collection;
import java.util.Hashtable;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.J2EEManagedObject;
import org.apache.geronimo.management.geronimo.J2EEDomain;
import org.apache.geronimo.management.geronimo.J2EEServer;

public class J2EEDomainImpl
implements J2EEDomain {
    private final String objectName;
    private final Collection servers;
    public static final GBeanInfo GBEAN_INFO;

    public J2EEDomainImpl(String objectName, Collection servers) {
        this.objectName = objectName;
        ObjectName myObjectName = ObjectNameUtil.getObjectName((String)this.objectName);
        this.verifyObjectName(myObjectName);
        this.servers = servers;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"J2EEDomain".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("J2EEDomain object name j2eeType property must be 'J2EEDomain'", objectName);
        }
        String name = keyPropertyList.get("name");
        if (!objectName.getDomain().equals(name)) {
            throw new InvalidObjectNameException("Domain part of J2EEDomain object name must match name propert", objectName);
        }
    }

    public String[] getServers() {
        return Util.getObjectNames((J2EEManagedObject[])this.getServerInstances());
    }

    public J2EEServer[] getServerInstances() {
        if (this.servers == null) {
            return new J2EEServer[0];
        }
        return this.servers.toArray(new J2EEServer[this.servers.size()]);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(J2EEDomainImpl.class, (String)"J2EEDomain");
        infoFactory.addReference("Servers", J2EEServer.class, "J2EEServer");
        infoFactory.setConstructor(new String[]{"objectName", "Servers"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

