/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.xbean.finder.AbstractFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistenceUnitAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(PersistenceUnitAnnotationHelper.class);

    private PersistenceUnitAnnotationHelper() {
    }

    public static void processAnnotations(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        if (annotatedApp != null) {
            if (classFinder.isAnnotationPresent(PersistenceUnits.class)) {
                PersistenceUnitAnnotationHelper.processPersistenceUnits(annotatedApp, classFinder);
            }
            if (classFinder.isAnnotationPresent(PersistenceUnit.class)) {
                PersistenceUnitAnnotationHelper.processPersistenceUnit(annotatedApp, classFinder);
            }
        }
    }

    private static void processPersistenceUnit(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        PersistenceUnit persistenceUnit;
        log.debug("processPersistenceUnit(): Entry: AnnotatedApp: " + annotatedApp.toString());
        List classeswithPersistenceUnit = classFinder.findAnnotatedClasses(PersistenceUnit.class);
        List methodswithPersistenceUnit = classFinder.findAnnotatedMethods(PersistenceUnit.class);
        List fieldswithPersistenceUnit = classFinder.findAnnotatedFields(PersistenceUnit.class);
        for (Class cls : classeswithPersistenceUnit) {
            persistenceUnit = cls.getAnnotation(PersistenceUnit.class);
            if (persistenceUnit == null) continue;
            PersistenceUnitAnnotationHelper.addPersistenceUnit(annotatedApp, persistenceUnit, cls, null, null);
        }
        for (Method method : methodswithPersistenceUnit) {
            persistenceUnit = method.getAnnotation(PersistenceUnit.class);
            if (persistenceUnit == null) continue;
            PersistenceUnitAnnotationHelper.addPersistenceUnit(annotatedApp, persistenceUnit, null, method, null);
        }
        for (Field field : fieldswithPersistenceUnit) {
            persistenceUnit = field.getAnnotation(PersistenceUnit.class);
            if (persistenceUnit == null) continue;
            PersistenceUnitAnnotationHelper.addPersistenceUnit(annotatedApp, persistenceUnit, null, null, field);
        }
        log.debug("processPersistenceUnit(): Exit: AnnotatedApp: " + annotatedApp.toString());
    }

    private static void processPersistenceUnits(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        log.debug("processPersistenceUnits(): Entry");
        List classeswithPersistenceUnits = classFinder.findAnnotatedClasses(PersistenceUnits.class);
        ArrayList<PersistenceUnit> persistenceUnitList = new ArrayList<PersistenceUnit>();
        for (Class cls : classeswithPersistenceUnits) {
            PersistenceUnits persistenceUnits = cls.getAnnotation(PersistenceUnits.class);
            if (persistenceUnits != null) {
                persistenceUnitList.addAll(Arrays.asList(persistenceUnits.value()));
            }
            for (PersistenceUnit persistenceUnit : persistenceUnitList) {
                PersistenceUnitAnnotationHelper.addPersistenceUnit(annotatedApp, persistenceUnit, cls, null, null);
            }
            persistenceUnitList.clear();
        }
        log.debug("processPersistenceUnits(): Exit");
    }

    private static void addPersistenceUnit(JndiConsumer annotatedApp, PersistenceUnit annotation, Class cls, Method method, Field field) {
        log.debug("addPersistenceUnit( [annotatedApp] " + annotatedApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
        String persistenceUnitRefName = PersistenceUnitAnnotationHelper.getName(annotation.name(), method, field);
        log.debug("addPersistenceUnit(): persistenceUnitRefName: " + persistenceUnitRefName);
        Collection persistenceUnitRefs = annotatedApp.getPersistenceUnitRef();
        for (PersistenceUnitRef persistenceUnitRef : persistenceUnitRefs) {
            Set targets;
            if (!persistenceUnitRef.getPersistenceUnitRefName().trim().equals(persistenceUnitRefName)) continue;
            if (!(method == null && field == null || PersistenceUnitAnnotationHelper.hasTarget(method, field, targets = persistenceUnitRef.getInjectionTarget()))) {
                persistenceUnitRef.getInjectionTarget().add(PersistenceUnitAnnotationHelper.configureInjectionTarget(method, field));
            }
            return;
        }
        PersistenceUnitRef persistenceUnitRef = new PersistenceUnitRef();
        persistenceUnitRef.setPersistenceUnitRefName(persistenceUnitRefName);
        String unitNameAnnotation = annotation.unitName();
        if (!unitNameAnnotation.equals("")) {
            persistenceUnitRef.setPersistenceUnitName(unitNameAnnotation);
        }
        if (method != null || field != null) {
            persistenceUnitRef.getInjectionTarget().add(PersistenceUnitAnnotationHelper.configureInjectionTarget(method, field));
        }
        annotatedApp.getPersistenceUnitRef().add(persistenceUnitRef);
    }
}

