/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.net.URI;
import java.util.jar.JarFile;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.xmlbeans.XmlObject;

public abstract class Module {
    private final boolean standAlone;
    private final AbstractName moduleName;
    private final String name;
    private final Environment environment;
    private final URI moduleURI;
    private final JarFile moduleFile;
    private final String targetPath;
    private final URI targetPathURI;
    private final XmlObject specDD;
    private final XmlObject vendorDD;
    private final String originalSpecDD;
    private final String namespace;
    private EARContext earContext;
    private EARContext rootEarContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Module(boolean standAlone, AbstractName moduleName, Environment environment, JarFile moduleFile, String targetPath, XmlObject specDD, XmlObject vendorDD, String originalSpecDD, String namespace) {
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && moduleName == null) {
            throw new AssertionError((Object)"moduleName is null");
        }
        this.standAlone = standAlone;
        this.moduleName = moduleName;
        this.environment = environment;
        this.moduleFile = moduleFile;
        this.targetPath = targetPath;
        this.specDD = specDD;
        this.vendorDD = vendorDD;
        this.originalSpecDD = originalSpecDD;
        this.namespace = namespace;
        if (standAlone) {
            this.name = environment.getConfigId().toString();
            this.moduleURI = URI.create("");
        } else {
            this.name = targetPath;
            this.moduleURI = URI.create(targetPath);
        }
        this.targetPathURI = URI.create(targetPath + "/");
    }

    public abstract ConfigurationModuleType getType();

    public String getName() {
        return this.name;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public URI getModuleURI() {
        return this.moduleURI;
    }

    public JarFile getModuleFile() {
        return this.moduleFile;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public URI getTargetPathURI() {
        return this.targetPathURI;
    }

    public XmlObject getSpecDD() {
        return this.specDD;
    }

    public XmlObject getVendorDD() {
        return this.vendorDD;
    }

    public String getOriginalSpecDD() {
        return this.originalSpecDD;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Module) {
            Module module = (Module)obj;
            return this.name.equals(module.name);
        }
        return false;
    }

    public void close() {
        DeploymentUtil.close((JarFile)this.moduleFile);
    }

    public EARContext getEarContext() {
        return this.earContext;
    }

    public void setEarContext(EARContext earContext) {
        this.earContext = earContext;
    }

    public EARContext getRootEarContext() {
        return this.rootEarContext;
    }

    public void setRootEarContext(EARContext rootEarContext) {
        this.rootEarContext = rootEarContext;
    }

    static {
        $assertionsDisabled = !Module.class.desiredAssertionStatus();
    }
}

