/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.hot;

import java.io.File;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.hot.DirectoryMonitor;
import org.apache.geronimo.deployment.hot.HotDeployer;
import org.apache.geronimo.deployment.plugin.factories.DeploymentFactoryWithKernel;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class DirectoryHotDeployer
implements HotDeployer,
DeploymentWatcher,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog(DirectoryHotDeployer.class);
    private static final String BAD_LAYOUT_MESSAGE = "CANNOT DEPLOY: It looks like you unpacked an application or module directly into the hot deployment directory.  THIS DOES NOT WORK.  You need to unpack into a subdirectory directly under the hot deploy directory.  For example, if the hot deploy directory is 'deploy/' and your file is 'webapp.war' then you could unpack it into a directory 'deploy/webapp.war/'";
    private DirectoryMonitor monitor;
    private String path;
    private ServerInfo serverInfo;
    private ConfigurationManager configManager;
    private int pollIntervalMillis;
    private String deploymentURI = "deployer:geronimo:inVM";
    private String deploymentUser;
    private String deploymentPassword;
    private transient Kernel kernel;
    private transient DeploymentFactory factory;
    private transient TargetModuleID[] startupModules = null;
    private transient boolean serverRunning = false;
    public static final GBeanInfo GBEAN_INFO;

    public DirectoryHotDeployer(String path, int pollIntervalMillis, ServerInfo serverInfo, ConfigurationManager configManager, Kernel kernel) {
        this.path = path;
        this.serverInfo = serverInfo;
        this.pollIntervalMillis = pollIntervalMillis;
        this.kernel = kernel;
        this.configManager = configManager;
    }

    public void deployed(Artifact id) {
    }

    public void undeployed(Artifact id) {
        this.monitor.removeModuleId(id);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public int getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    public void setPollIntervalMillis(int pollIntervalMillis) {
        this.pollIntervalMillis = pollIntervalMillis;
    }

    public String getDeploymentURI() {
        return this.deploymentURI;
    }

    public void setDeploymentURI(String deploymentURI) {
        if (deploymentURI != null && !deploymentURI.trim().equals("")) {
            this.deploymentURI = deploymentURI.trim();
        }
    }

    public String getDeploymentUser() {
        return this.deploymentUser;
    }

    public void setDeploymentUser(String deploymentUser) {
        this.deploymentUser = deploymentUser;
    }

    public String getDeploymentPassword() {
        return this.deploymentPassword;
    }

    public void setDeploymentPassword(String deploymentPassword) {
        this.deploymentPassword = deploymentPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        File dir;
        if (this.factory == null) {
            this.factory = new DeploymentFactoryWithKernel(this.kernel);
        }
        if (!(dir = this.serverInfo.resolveServer(this.path)).exists()) {
            if (!dir.mkdirs()) {
                throw new IllegalStateException("Hot deploy directory " + dir.getAbsolutePath() + " does not exist and cannot be created!");
            }
        } else if (!dir.canRead() || !dir.isDirectory()) {
            throw new IllegalStateException("Hot deploy directory " + dir.getAbsolutePath() + " is not a readable directory!");
        }
        DeploymentManager mgr = null;
        try {
            mgr = this.getDeploymentManager();
            Target[] targets = mgr.getTargets();
            this.startupModules = mgr.getAvailableModules(null, targets);
            mgr.release();
            mgr = null;
            this.monitor = new DirectoryMonitor(dir, this, this.pollIntervalMillis);
            log.debug((Object)"Hot deploy scanner intialized; starting main loop.");
            Thread t = new Thread((Runnable)this.monitor, "Geronimo hot deploy scanner");
            t.setDaemon(true);
            t.start();
        }
        finally {
            if (mgr != null) {
                mgr.release();
            }
        }
    }

    public void doStop() throws Exception {
        this.monitor.close();
    }

    public void doFail() {
        if (this.monitor != null) {
            this.monitor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileDeployed(File file, String configId) {
        DeploymentManager mgr = null;
        try {
            if (this.startupModules != null) {
                DeployUtils.identifyTargetModuleIDs((TargetModuleID[])this.startupModules, (String)configId, (boolean)true).toArray(new TargetModuleID[0]);
            } else {
                mgr = this.getDeploymentManager();
                Target[] targets = mgr.getTargets();
                TargetModuleID[] ids = mgr.getAvailableModules(null, targets);
                DeployUtils.identifyTargetModuleIDs((TargetModuleID[])ids, (String)configId, (boolean)true).toArray(new TargetModuleID[0]);
                mgr.release();
                mgr = null;
            }
            boolean targets = true;
            return targets;
        }
        catch (DeploymentException e) {
            log.debug((Object)("Found new file in deploy directory on startup with ID " + configId));
        }
        catch (Exception e) {
            log.error((Object)"Unable to check status", (Throwable)e);
        }
        finally {
            if (mgr != null) {
                mgr.release();
                mgr = null;
            }
        }
        return false;
    }

    public boolean isServerRunning() {
        if (this.serverRunning) {
            return true;
        }
        Set configLists = this.kernel.listGBeans(new AbstractNameQuery(PersistentConfigurationList.class.getName()));
        for (AbstractName configListName : configLists) {
            try {
                Boolean result = (Boolean)this.kernel.getAttribute(configListName, "kernelFullyStarted");
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Exception e) {
                log.warn((Object)"Hot deployer unable to determine whether kernel is started", (Throwable)e);
            }
        }
        this.serverRunning = true;
        return true;
    }

    public long getDeploymentTime(File file, String configId) {
        try {
            Artifact art = this.configManager.getArtifactResolver().resolveInClassLoader(Artifact.create((String)configId));
            Configuration config = this.configManager.getConfiguration(art);
            return config.getCreated();
        }
        catch (MissingDependencyException e) {
            log.error((Object)("Unknown configuration " + configId));
            return -1L;
        }
    }

    public void started() {
        this.startupModules = null;
        log.debug((Object)"Initialization complete; directory scanner entering normal scan mode");
    }

    public boolean validateFile(File file, String configId) {
        if (file.isDirectory() && (file.getName().equals("WEB-INF") || file.getName().equals("META-INF"))) {
            log.error((Object)("(" + file.getName() + ") " + BAD_LAYOUT_MESSAGE));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileAdded(File file) {
        boolean completed;
        TargetModuleID[] modules;
        block23: {
            log.info((Object)("Deploying " + file.getName()));
            DeploymentManager mgr = null;
            modules = null;
            completed = false;
            try {
                mgr = this.getDeploymentManager();
                Target[] targets = mgr.getTargets();
                ProgressObject po = DeployUtils.isJarFile((File)file) || file.isDirectory() ? mgr.distribute(targets, file, null) : mgr.distribute(targets, null, file);
                this.waitForProgress(po);
                if (po.getDeploymentStatus().isCompleted()) {
                    modules = po.getResultTargetModuleIDs();
                    po = mgr.start(modules);
                    this.waitForProgress(po);
                    if (po.getDeploymentStatus().isCompleted()) {
                        completed = true;
                    } else {
                        log.warn((Object)("Unable to start some modules for " + file.getAbsolutePath()));
                    }
                    modules = po.getResultTargetModuleIDs();
                    for (int i = 0; i < modules.length; ++i) {
                        TargetModuleID result = modules[i];
                        log.info((Object)DeployUtils.reformat((String)("Deployed " + result.getModuleID() + (targets.length > 1 ? " to " + result.getTarget().getName() : "") + (result.getWebURL() == null ? "" : " @ " + result.getWebURL())), (int)4, (int)72));
                        if (result.getChildTargetModuleID() == null) continue;
                        for (int j = 0; j < result.getChildTargetModuleID().length; ++j) {
                            TargetModuleID child = result.getChildTargetModuleID()[j];
                            log.info((Object)DeployUtils.reformat((String)("  `-> " + child.getModuleID() + (child.getWebURL() == null ? "" : " @ " + child.getWebURL())), (int)4, (int)72));
                        }
                    }
                    break block23;
                }
                log.error((Object)("Unable to deploy: " + po.getDeploymentStatus().getMessage()));
                String delfile = file.getAbsolutePath();
                File fd = new File(delfile);
                if (fd.isDirectory()) {
                    log.info((Object)("Deleting the Directory: " + delfile));
                    if (DeploymentUtil.recursiveDelete((File)fd)) {
                        log.debug((Object)("Successfully deleted the Directory: " + delfile));
                    } else {
                        log.error((Object)("Couldn't delete the hot deployed directory" + delfile));
                    }
                } else if (fd.isFile()) {
                    log.info((Object)("Deleting the File: " + delfile));
                    if (fd.delete()) {
                        log.debug((Object)("Successfully deleted the File: " + delfile));
                    } else {
                        log.error((Object)("Couldn't delete the hot deployed directory" + delfile));
                    }
                }
                String string = null;
                return string;
            }
            catch (DeploymentManagerCreationException e) {
                log.error((Object)"Unable to open deployer", (Throwable)e);
                String string = null;
                return string;
            }
            catch (DeploymentException e) {
                log.error((Object)"Unable to determine if file is a jar", (Throwable)e);
            }
            finally {
                if (mgr != null) {
                    mgr.release();
                }
            }
        }
        if (completed && modules != null) {
            if (modules.length == 1) {
                return modules[0].getModuleID();
            }
            return "";
        }
        if (modules != null) {
            return "";
        }
        return null;
    }

    private DeploymentManager getDeploymentManager() throws DeploymentManagerCreationException {
        DeploymentManager manager = this.factory.getDeploymentManager(this.deploymentURI, this.deploymentUser, this.deploymentPassword);
        if (manager instanceof JMXDeploymentManager) {
            ((JMXDeploymentManager)manager).setLogConfiguration(false, true);
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileRemoved(File file, String configId) {
        block10: {
            log.info((Object)("Undeploying " + file.getName()));
            DeploymentManager mgr = null;
            try {
                mgr = this.getDeploymentManager();
                Target[] targets = mgr.getTargets();
                TargetModuleID[] ids = mgr.getAvailableModules(null, targets);
                ids = DeployUtils.identifyTargetModuleIDs((TargetModuleID[])ids, (String)configId, (boolean)true).toArray(new TargetModuleID[0]);
                ProgressObject po = mgr.undeploy(ids);
                this.waitForProgress(po);
                if (po.getDeploymentStatus().isCompleted()) {
                    TargetModuleID[] modules = po.getResultTargetModuleIDs();
                    for (int i = 0; i < modules.length; ++i) {
                        TargetModuleID result = modules[i];
                        log.info((Object)DeployUtils.reformat((String)("Undeployed " + result.getModuleID() + (targets.length > 1 ? " to " + result.getTarget().getName() : "")), (int)4, (int)72));
                    }
                    break block10;
                }
                log.error((Object)("Unable to undeploy " + file.getAbsolutePath() + "(" + configId + ")" + po.getDeploymentStatus().getMessage()));
                boolean bl = false;
                return bl;
            }
            catch (DeploymentManagerCreationException e) {
                log.error((Object)"Unable to open deployer", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                log.error((Object)"Unable to undeploy", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (mgr != null) {
                    mgr.release();
                }
            }
        }
        return true;
    }

    public String getModuleId(String config) {
        DeploymentManager mgr = null;
        Object modules = null;
        try {
            mgr = this.getDeploymentManager();
            Target[] targets = mgr.getTargets();
            TargetModuleID[] ids = mgr.getAvailableModules(null, targets);
            for (int j = 0; j < ids.length; ++j) {
                String moduleId = ids[j].getModuleID();
                String[] parts = moduleId.split("/", -1);
                if (parts.length != 4 || parts[1] == null || !parts[1].equals(config)) continue;
                return ids[j].getModuleID();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Unable to getModuleId", (Throwable)ex);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileUpdated(File file, String configId) {
        log.info((Object)("Redeploying " + file.getName()));
        DeploymentManager mgr = null;
        TargetModuleID[] modules = null;
        try {
            mgr = this.getDeploymentManager();
            Target[] targets = mgr.getTargets();
            TargetModuleID[] ids = mgr.getAvailableModules(null, targets);
            ids = DeployUtils.identifyTargetModuleIDs((TargetModuleID[])ids, (String)configId, (boolean)true).toArray(new TargetModuleID[0]);
            ProgressObject po = DeployUtils.isJarFile((File)file) || file.isDirectory() ? mgr.redeploy(ids, file, null) : mgr.redeploy(ids, null, file);
            this.waitForProgress(po);
            if (po.getDeploymentStatus().isCompleted()) {
                modules = po.getResultTargetModuleIDs();
                for (int i = 0; i < modules.length; ++i) {
                    TargetModuleID result = modules[i];
                    log.info((Object)DeployUtils.reformat((String)("Redeployed " + result.getModuleID() + (targets.length > 1 ? " to " + result.getTarget().getName() : "") + (result.getWebURL() == null ? "" : " @ " + result.getWebURL())), (int)4, (int)72));
                    if (result.getChildTargetModuleID() == null) continue;
                    for (int j = 0; j < result.getChildTargetModuleID().length; ++j) {
                        TargetModuleID child = result.getChildTargetModuleID()[j];
                        log.info((Object)DeployUtils.reformat((String)("  `-> " + child.getModuleID() + (child.getWebURL() == null ? "" : " @ " + child.getWebURL())), (int)4, (int)72));
                    }
                }
            } else {
                log.error((Object)("Unable to undeploy " + file.getAbsolutePath() + "(" + configId + ")" + po.getDeploymentStatus().getMessage()));
            }
        }
        catch (DeploymentManagerCreationException e) {
            log.error((Object)"Unable to open deployer", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Unable to undeploy", (Throwable)e);
        }
        finally {
            if (mgr != null) {
                mgr.release();
            }
        }
        if (modules != null) {
            if (modules.length == 1) {
                return modules[0].getModuleID();
            }
            return "";
        }
        return null;
    }

    private void waitForProgress(ProgressObject po) {
        while (po.getDeploymentStatus().isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(DirectoryHotDeployer.class);
        infoFactory.addAttribute("path", String.class, true, true);
        infoFactory.addAttribute("pollIntervalMillis", Integer.TYPE, true, true);
        infoFactory.addAttribute("deploymentURI", String.class, true, true);
        infoFactory.addAttribute("deploymentUser", String.class, true, true);
        infoFactory.addAttribute("deploymentPassword", String.class, true, true);
        infoFactory.addReference("ConfigManager", ConfigurationManager.class, "ConfigurationManager");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addAttribute("kernel", Kernel.class, false, false);
        infoFactory.addInterface(HotDeployer.class);
        infoFactory.setConstructor(new String[]{"path", "pollIntervalMillis", "ServerInfo", "ConfigManager", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

