/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.service;

import java.io.Serializable;
import org.apache.geronimo.farm.service.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeServiceVitals
implements Serializable {
    static final Logger log = LoggerFactory.getLogger(NodeServiceVitals.class);
    private static final long serialVersionUID = -7874058757277568424L;
    private long initialReconnectDelay;
    private long maxReconnectDelay;
    private long backOffMultiplier;
    private boolean useExponentialBackOff;
    private int maxReconnectAttempts;
    private final NodeService service;
    long lastHeartBeat;
    long recoveryTime;
    int failureCount;
    boolean dead;

    public NodeService getService() {
        return this.service;
    }

    NodeServiceVitals(NodeService service) {
        this.service = service;
        this.lastHeartBeat = System.currentTimeMillis();
    }

    public synchronized void heartbeat() {
        this.lastHeartBeat = System.currentTimeMillis();
        if (!this.dead && this.failureCount > 0 && this.lastHeartBeat - this.recoveryTime > 60000L) {
            log.debug("I now think that the " + this.service + " service has recovered.");
            this.failureCount = 0;
            this.recoveryTime = 0L;
        }
    }

    public synchronized long getLastHeartbeat() {
        return this.lastHeartBeat;
    }

    public synchronized boolean pronounceDead() {
        if (!this.dead) {
            long reconnectDelay;
            this.dead = true;
            ++this.failureCount;
            if (this.useExponentialBackOff) {
                reconnectDelay = (long)Math.pow(this.backOffMultiplier, this.failureCount);
                if (reconnectDelay > this.maxReconnectDelay) {
                    reconnectDelay = this.maxReconnectDelay;
                }
            } else {
                reconnectDelay = this.initialReconnectDelay;
            }
            log.debug("Remote failure of " + this.service + " while still receiving multicast advertisements.  " + "Advertising events will be suppressed for " + reconnectDelay + " ms, the current failure count is: " + this.failureCount);
            this.recoveryTime = System.currentTimeMillis() + reconnectDelay;
            return true;
        }
        return false;
    }

    public synchronized boolean doRecovery() {
        if (!this.dead) {
            return false;
        }
        if (this.maxReconnectAttempts > 0 && this.failureCount > this.maxReconnectAttempts) {
            log.debug("Max reconnect attempts of the " + this.service + " service has been reached.");
            return false;
        }
        if (System.currentTimeMillis() < this.recoveryTime) {
            return false;
        }
        log.debug("Resuming event advertisement of the " + this.service + " service.");
        this.dead = false;
        return true;
    }

    public boolean isDead() {
        return this.dead;
    }

    void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    void setBackOffMultiplier(long backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public String toString() {
        return "ServiceVitals [backOffMultiplier=" + this.backOffMultiplier + ", dead=" + this.dead + ", failureCount=" + this.failureCount + ", initialReconnectDelay=" + this.initialReconnectDelay + ", lastHeartBeat=" + this.lastHeartBeat + ", maxReconnectAttempts=" + this.maxReconnectAttempts + ", maxReconnectDelay=" + this.maxReconnectDelay + ", recoveryTime=" + this.recoveryTime + ", useExponentialBackOff=" + this.useExponentialBackOff + "]";
    }
}

