/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.cli.deployer.ListModulesCommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandListModules
extends AbstractCommand {
    public void execute(PrintWriter out, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        if (!(commandArgs instanceof ListModulesCommandArgs)) {
            throw new DeploymentSyntaxException("CommandArgs has the type [" + commandArgs.getClass() + "]; expected [" + ListModulesCommandArgs.class + "]");
        }
        ListModulesCommandArgs listModulesCommandArgs = (ListModulesCommandArgs)commandArgs;
        Boolean started = null;
        if (listModulesCommandArgs.isStarted()) {
            started = Boolean.TRUE;
        } else if (listModulesCommandArgs.isStopped()) {
            started = Boolean.FALSE;
        }
        List<String> targets = Arrays.asList(listModulesCommandArgs.getArgs());
        DeploymentManager mgr = connection.getDeploymentManager();
        TargetModuleID[] running = null;
        TargetModuleID[] notrunning = null;
        Target[] tlist = CommandListModules.identifyTargets(targets, mgr);
        if (tlist.length == 0) {
            tlist = mgr.getTargets();
        }
        try {
            if (started == null || started.booleanValue()) {
                running = mgr.getRunningModules(null, tlist);
            }
            if (started == null || !started.booleanValue()) {
                notrunning = mgr.getNonRunningModules(null, tlist);
            }
        }
        catch (TargetException e) {
            throw new DeploymentException("Unable to query modules", (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new DeploymentSyntaxException(e.getMessage(), e);
        }
        if (running == null) {
            running = new TargetModuleID[]{};
        }
        if (notrunning == null) {
            notrunning = new TargetModuleID[]{};
        }
        int total = running.length + notrunning.length;
        out.print("Found " + total + " module" + (total != 1 ? "s" : ""));
        if (tlist != null && tlist.length > 1) {
            out.println(" deployed to " + tlist.length + " target" + (tlist.length != 1 ? "s" : ""));
        } else {
            out.println("");
        }
        for (int i = 0; tlist != null && i < tlist.length; ++i) {
            Target target = tlist[i];
            if (tlist.length > 1) {
                out.println("\n Target " + target);
            }
            this.printTargetModules(out, target, running, "  + ");
            this.printTargetModules(out, target, notrunning, "    ");
        }
    }

    void printTargetModules(PrintWriter out, Target target, TargetModuleID[] modules, String prefix) {
        for (int i = 0; i < modules.length; ++i) {
            TargetModuleID result = modules[i];
            if (!result.getTarget().equals(target)) continue;
            out.println(prefix + result.getModuleID());
            if (result.getChildTargetModuleID() == null) continue;
            for (int j = 0; j < result.getChildTargetModuleID().length; ++j) {
                TargetModuleID child = result.getChildTargetModuleID()[j];
                out.println("      `-> " + child.getModuleID());
            }
        }
    }
}

