/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.jmx;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.deployment.plugin.TargetImpl;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.jmx.CommandContext;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.deployment.plugin.local.DistributeCommand;
import org.apache.geronimo.deployment.plugin.local.RedeployCommand;
import org.apache.geronimo.deployment.plugin.local.StartCommand;
import org.apache.geronimo.deployment.plugin.local.StopCommand;
import org.apache.geronimo.deployment.plugin.local.UndeployCommand;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.management.State;

public abstract class JMXDeploymentManager
implements DeploymentManager {
    private static final Log log = LogFactory.getLog((Class)JMXDeploymentManager.class);
    protected Kernel kernel;
    private ConfigurationManager configurationManager;
    private CommandContext commandContext;

    protected void initialize(Kernel kernel) {
        this.kernel = kernel;
        this.configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
        this.commandContext = new CommandContext(true, true, null, null, false);
    }

    public void setAuthentication(String username, String password) {
        this.commandContext.setUsername(username);
        this.commandContext.setPassword(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.kernel != null && this.configurationManager != null) {
            try {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)this.configurationManager);
            }
            finally {
                this.configurationManager = null;
                this.kernel = null;
            }
        }
    }

    public Target[] getTargets() {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        List stores = this.configurationManager.listStores();
        if (stores.size() == 0) {
            return null;
        }
        Target[] targets = new Target[stores.size()];
        for (int i = 0; i < stores.size(); ++i) {
            AbstractName storeName = (AbstractName)stores.get(i);
            targets[i] = new TargetImpl(storeName, null);
        }
        return targets;
    }

    public TargetModuleID[] getAvailableModules(final ModuleType moduleType, Target[] targetList) throws TargetException {
        ConfigFilter filter = new ConfigFilter(){

            public boolean accept(ConfigurationInfo info) {
                return moduleType == null || info.getType() == ConfigurationModuleType.getFromValue((int)moduleType.getValue());
            }
        };
        return this.getModules(targetList, filter);
    }

    public TargetModuleID[] getNonRunningModules(final ModuleType moduleType, Target[] targetList) throws TargetException {
        ConfigFilter filter = new ConfigFilter(){

            public boolean accept(ConfigurationInfo info) {
                return info.getState() != State.RUNNING && (moduleType == null || info.getType() == ConfigurationModuleType.getFromValue((int)moduleType.getValue()));
            }
        };
        return this.getModules(targetList, filter);
    }

    public TargetModuleID[] getRunningModules(final ModuleType moduleType, Target[] targetList) throws TargetException {
        ConfigFilter filter = new ConfigFilter(){

            public boolean accept(ConfigurationInfo info) {
                return info.getState() == State.RUNNING && (moduleType == null || info.getType() == ConfigurationModuleType.getFromValue((int)moduleType.getValue()));
            }
        };
        return this.getModules(targetList, filter);
    }

    private TargetModuleID[] getModules(Target[] targetList, ConfigFilter filter) throws TargetException {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        try {
            ArrayList<TargetModuleIDImpl> result = new ArrayList<TargetModuleIDImpl>();
            for (int i = 0; i < targetList.length; ++i) {
                TargetImpl target = (TargetImpl)targetList[i];
                AbstractName storeName = target.getAbstractName();
                List infos = this.configurationManager.listConfigurations(storeName);
                for (int j = 0; j < infos.size(); ++j) {
                    ConfigurationInfo info = (ConfigurationInfo)infos.get(j);
                    if (!filter.accept(info)) continue;
                    String name = info.getConfigID().toString();
                    List list = CommandSupport.loadChildren(this.kernel, name);
                    TargetModuleIDImpl moduleID = new TargetModuleIDImpl((Target)target, name, list.toArray(new String[list.size()]));
                    moduleID.setType(CommandSupport.convertModuleType(info.getType()));
                    if (moduleID.getChildTargetModuleID() != null) {
                        for (int k = 0; k < moduleID.getChildTargetModuleID().length; ++k) {
                            TargetModuleIDImpl child = (TargetModuleIDImpl)moduleID.getChildTargetModuleID()[k];
                            if (!CommandSupport.isWebApp(this.kernel, child.getModuleID())) continue;
                            child.setType(ModuleType.WAR);
                        }
                    }
                    result.add(moduleID);
                }
            }
            CommandSupport.addWebURLs(this.kernel, result);
            return result.size() == 0 ? null : result.toArray(new TargetModuleID[result.size()]);
        }
        catch (Exception e) {
            throw (TargetException)new TargetException(e.getMessage()).initCause((Throwable)e);
        }
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan) {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        DistributeCommand command = this.createDistributeCommand(targetList, moduleArchive, deploymentPlan);
        command.setCommandContext(this.commandContext);
        new Thread(command).start();
        return command;
    }

    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        DistributeCommand command = this.createDistributeCommand(targetList, moduleArchive, deploymentPlan);
        command.setCommandContext(this.commandContext);
        new Thread(command).start();
        return command;
    }

    public ProgressObject start(TargetModuleID[] moduleIDList) {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        StartCommand command = new StartCommand(this.kernel, moduleIDList);
        command.setCommandContext(this.commandContext);
        new Thread(command).start();
        return command;
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList) {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        StopCommand command = new StopCommand(this.kernel, moduleIDList);
        command.setCommandContext(this.commandContext);
        new Thread(command).start();
        return command;
    }

    public ProgressObject undeploy(TargetModuleID[] moduleIDList) {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        UndeployCommand command = new UndeployCommand(this.kernel, moduleIDList);
        command.setCommandContext(this.commandContext);
        new Thread(command).start();
        return command;
    }

    public boolean isRedeploySupported() {
        return true;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        RedeployCommand command = this.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        command.setCommandContext(this.commandContext);
        new Thread(command).start();
        return command;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        RedeployCommand command = this.createRedeployCommand(moduleIDList, moduleArchive, deploymentPlan);
        command.setCommandContext(this.commandContext);
        new Thread(command).start();
        return command;
    }

    public Locale[] getSupportedLocales() {
        return new Locale[]{this.getDefaultLocale()};
    }

    public Locale getCurrentLocale() {
        return this.getDefaultLocale();
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public boolean isLocaleSupported(Locale locale) {
        return this.getDefaultLocale().equals(locale);
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException("Cannot set Locale");
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V1_4;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return DConfigBeanVersionType.V1_4.equals(version);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
        if (!this.isDConfigBeanVersionSupported(version)) {
            throw new DConfigBeanVersionUnsupportedException("Version not supported " + version);
        }
    }

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        if (!dObj.getType().equals(ModuleType.CAR) && !dObj.getType().equals(ModuleType.EAR)) {
            if (dObj.getType().equals(ModuleType.EJB)) {
                try {
                    Class<?> cls = Class.forName("org.apache.openejb.deployment.EJBConfigurer");
                    return (DeploymentConfiguration)cls.getMethod("createConfiguration", DeployableObject.class).invoke(cls.newInstance(), dObj);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to invoke EJB deployer", (Throwable)e);
                }
            } else if (dObj.getType().equals(ModuleType.RAR) || dObj.getType().equals(ModuleType.WAR)) {
                // empty if block
            }
        }
        throw new InvalidModuleException("Not supported");
    }

    protected DistributeCommand createDistributeCommand(Target[] targetList, File moduleArchive, File deploymentPlan) {
        return new DistributeCommand(this.kernel, targetList, moduleArchive, deploymentPlan);
    }

    protected DistributeCommand createDistributeCommand(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) {
        return new DistributeCommand(this.kernel, targetList, moduleArchive, deploymentPlan);
    }

    protected RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) {
        return new RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }

    protected RedeployCommand createRedeployCommand(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) {
        return new RedeployCommand(this.kernel, moduleIDList, moduleArchive, deploymentPlan);
    }

    public void setLogConfiguration(boolean shouldLog, boolean verboseStatus) {
        this.commandContext.setLogErrors(shouldLog);
        this.commandContext.setVerbose(verboseStatus);
    }

    public void setInPlace(boolean inPlace) {
        this.commandContext.setInPlace(inPlace);
    }

    private static interface ConfigFilter {
        public boolean accept(ConfigurationInfo var1);
    }
}

