/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.client;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.geronimo.cxf.CXFCatalogUtils;
import org.apache.geronimo.cxf.CXFWebServiceContainer;
import org.apache.geronimo.cxf.client.CXFPortMethodInterceptor;
import org.apache.geronimo.cxf.client.SAAJInterceptor;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.jaxws.JAXWSAnnotationProcessor;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.annotations.AnnotationProcessor;
import org.apache.geronimo.jaxws.client.EndpointInfo;
import org.apache.geronimo.jaxws.client.JAXWSServiceReference;
import org.apache.geronimo.jaxws.client.PortMethodInterceptor;
import org.apache.geronimo.jaxws.handler.GeronimoHandlerResolver;
import org.apache.geronimo.jaxws.info.HandlerChainsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXFServiceReference
extends JAXWSServiceReference {
    private static final Logger LOG = LoggerFactory.getLogger(CXFServiceReference.class);

    public CXFServiceReference(String serviceClassName, String referenceClassName, URI wsdlURI, QName serviceQName, AbstractName name, HandlerChainsInfo handlerChainsInfo, Map<Object, EndpointInfo> seiInfoMap) {
        super(handlerChainsInfo, seiInfoMap, name, serviceQName, wsdlURI, referenceClassName, serviceClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContent() throws NamingException {
        Bus bus = CXFWebServiceContainer.getDefaultBus();
        URL catalogURL = this.getCatalog();
        if (catalogURL != null) {
            bus = BusFactory.newInstance().createBus();
            CXFCatalogUtils.loadOASISCatalog(bus, catalogURL);
            SAAJInterceptor.registerInterceptors(bus);
        } else {
            SAAJInterceptor.registerInterceptors();
        }
        BusFactory.setThreadDefaultBus((Bus)bus);
        try {
            Object object = super.getContent();
            return object;
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }

    protected HandlerResolver getHandlerResolver(Class serviceClass) {
        JAXWSAnnotationProcessor annotationProcessor = new JAXWSAnnotationProcessor(new JNDIResolver(), (WebServiceContext)new WebServiceContextImpl());
        GeronimoHandlerResolver handlerResolver = new GeronimoHandlerResolver(this.bundle, serviceClass, this.handlerChainsInfo, (AnnotationProcessor)annotationProcessor);
        return handlerResolver;
    }

    protected PortMethodInterceptor getPortMethodInterceptor() {
        return new CXFPortMethodInterceptor(this.seiInfoMap);
    }
}

